/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of CryptX.xs. Do not edit this file, edit CryptX.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "CryptX.xs"
#define PERL_NO_GET_CONTEXT     /* we want efficiency */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#define NEED_sv_2pvbyte_GLOBAL
#define NEED_sv_2pv_flags_GLOBAL
#define NEED_newRV_noinc_GLOBAL
#include "ppport.h"

/* assert_not_ROK is broken in 5.8.1 */
#if PERL_VERSION == 8 && PERL_SUBVERSION == 1
# undef assert_not_ROK
# if defined(__GNUC__) && !defined(PERL_GCC_BRACE_GROUPS_FORBIDDEN)
#  define assert_not_ROK(sv)  ({assert(!SvROK(sv) || !SvRV(sv));}),
# else
#  define assert_not_ROK(sv)
# endif
#endif

#undef LTC_SOURCE
#include "tomcrypt.h"
#include "tommath.h"

typedef adler32_state           *Crypt__Checksum__Adler32;
typedef crc32_state             *Crypt__Checksum__CRC32;

typedef ccm_state               *Crypt__AuthEnc__CCM;
typedef eax_state               *Crypt__AuthEnc__EAX;
typedef gcm_state               *Crypt__AuthEnc__GCM;
typedef chacha20poly1305_state  *Crypt__AuthEnc__ChaCha20Poly1305;
typedef ocb3_state              *Crypt__AuthEnc__OCB;

typedef chacha_state            *Crypt__Stream__ChaCha;
typedef salsa20_state           *Crypt__Stream__Salsa20;
typedef sosemanuk_state         *Crypt__Stream__Sosemanuk;
typedef rabbit_state            *Crypt__Stream__Rabbit;
typedef rc4_state               *Crypt__Stream__RC4;
typedef sober128_state          *Crypt__Stream__Sober128;

typedef f9_state                *Crypt__Mac__F9;
typedef hmac_state              *Crypt__Mac__HMAC;
typedef omac_state              *Crypt__Mac__OMAC;
typedef pelican_state           *Crypt__Mac__Pelican;
typedef pmac_state              *Crypt__Mac__PMAC;
typedef xcbc_state              *Crypt__Mac__XCBC;
typedef poly1305_state          *Crypt__Mac__Poly1305;
typedef blake2smac_state        *Crypt__Mac__BLAKE2s;
typedef blake2bmac_state        *Crypt__Mac__BLAKE2b;

typedef struct cipher_struct {          /* used by Crypt::Cipher */
  symmetric_key skey;
  struct ltc_cipher_descriptor *desc;
} *Crypt__Cipher;

typedef struct digest_struct {          /* used by Crypt::Digest */
  hash_state state;
  struct ltc_hash_descriptor *desc;
} *Crypt__Digest;

typedef struct digest_shake_struct {    /* used by Crypt::Digest::SHAKE */
  hash_state state;
  int num;
} *Crypt__Digest__SHAKE;

typedef struct cbc_struct {             /* used by Crypt::Mode::CBC */
  int cipher_id, cipher_rounds;
  symmetric_CBC state;
  unsigned char pad[MAXBLOCKSIZE];
  int padlen;
  int padding_mode;
  int direction;
} *Crypt__Mode__CBC;

typedef struct ecb_struct {             /* used by Crypt::Mode::ECB */
  int cipher_id, cipher_rounds;
  symmetric_ECB state;
  unsigned char pad[MAXBLOCKSIZE];
  int padlen;
  int padding_mode;
  int direction;
} *Crypt__Mode__ECB;

typedef struct cfb_struct {             /* used by Crypt::Mode::CFB */
  int cipher_id, cipher_rounds;
  symmetric_CFB state;
  int direction;
} *Crypt__Mode__CFB;

typedef struct ctr_struct {             /* used by Crypt::Mode::CTR */
  int cipher_id, cipher_rounds;
  int ctr_mode_param;
  symmetric_CTR state;
  int direction;
} *Crypt__Mode__CTR;

typedef struct f8_struct {              /* used by Crypt::Mode::F8 */
  int cipher_id, cipher_rounds;
  symmetric_F8 state;
  int direction;
} *Crypt__Mode__F8;

typedef struct lrw_struct {             /* used by Crypt::Mode::LRW */
  int cipher_id, cipher_rounds;
  symmetric_LRW state;
  int direction;
} *Crypt__Mode__LRW;

typedef struct ofb_struct {             /* used by Crypt::Mode::OFB */
  int cipher_id, cipher_rounds;
  symmetric_OFB state;
  int direction;
} *Crypt__Mode__OFB;

typedef struct xts_struct {             /* used by Crypt::Mode::XTS */
  int cipher_id, cipher_rounds;
  symmetric_xts state;
  int direction;
} *Crypt__Mode__XTS;

typedef struct prng_struct {            /* used by Crypt::PRNG */
  prng_state state;
  struct ltc_prng_descriptor *desc;
  IV last_pid;
} *Crypt__PRNG;

typedef struct rsa_struct {             /* used by Crypt::PK::RSA */
  prng_state pstate;
  int pindex;
  rsa_key key;
} *Crypt__PK__RSA;

typedef struct dsa_struct {             /* used by Crypt::PK::DSA */
  prng_state pstate;
  int pindex;
  dsa_key key;
} *Crypt__PK__DSA;

typedef struct dh_struct {              /* used by Crypt::PK::DH */
  prng_state pstate;
  int pindex;
  dh_key key;
} *Crypt__PK__DH;

typedef struct ecc_struct {             /* used by Crypt::PK::ECC */
  prng_state pstate;
  int pindex;
  ecc_key key;
} *Crypt__PK__ECC;

int mp_tohex_with_leading_zero(mp_int * a, char *str, int maxlen, int minlen) {
  int len, rv;

  if (mp_isneg(a) == MP_YES) {
    *str = '\0';
    return MP_VAL;
  }

  rv = mp_toradix_n(a, str, 16, maxlen);
  if (rv != MP_OKAY) {
    *str = '\0';
    return rv;
  }

  len = (int)strlen(str);
  if (len > 0 && len % 2 && len < maxlen-2) {
    memmove(str+1, str, len+1); /* incl. NUL byte */
    *str = '0';                 /* add leading zero */
  }

  len = (int)strlen(str);
  if (len < minlen && minlen < maxlen-1) {
    memmove(str+(minlen-len), str, len+1); /* incl. NUL byte */
    memset(str, '0', minlen-len);          /* add leading zero */
  }

  return MP_OKAY;
}

size_t _find_start(const char *name, char *ltcname, size_t ltclen)
{
   size_t i, start = 0;
   if (name == NULL || strlen(name) + 1 > ltclen) croak("FATAL: invalid name") ;
   /* normalize */
   for (i = 0; i < ltclen && name[i] > 0; i++) {
     if (name[i] >= 'A' && name[i] <= 'Z') {
       ltcname[i] = name[i] + 32; /* lowecase */
     }
     else if (name[i] == '_') {
       ltcname[i] = '-';
     }
     else {
       ltcname[i] = name[i];
     }
     if (name[i] == ':') start = i + 1;
   }
   return start;
}

int _find_hash(const char *name)
{
   char ltcname[100] = { 0 };
   size_t start = _find_start(name, ltcname, sizeof(ltcname) - 1);
   /* special cases */
   if (strcmp(ltcname + start, "ripemd128") == 0) return find_hash("rmd128");
   if (strcmp(ltcname + start, "ripemd160") == 0) return find_hash("rmd160");
   if (strcmp(ltcname + start, "ripemd256") == 0) return find_hash("rmd256");
   if (strcmp(ltcname + start, "ripemd320") == 0) return find_hash("rmd320");
   if (strcmp(ltcname + start, "tiger192")  == 0) return find_hash("tiger");
   if (strcmp(ltcname + start, "chaes")     == 0) return find_hash("chc_hash");
   if (strcmp(ltcname + start, "chc-hash")  == 0) return find_hash("chc_hash");
   return find_hash(ltcname + start);
}

int _find_cipher(const char *name)
{
   char ltcname[100] = { 0 };
   size_t start = _find_start(name, ltcname, sizeof(ltcname) - 1);
   /* special cases */
   if (strcmp(ltcname + start, "des-ede") == 0) return find_cipher("3des");
   if (strcmp(ltcname + start, "saferp")  == 0) return find_cipher("safer+");
   return find_cipher(ltcname + start);
}

int _find_prng(const char *name)
{
  char ltcname[100] = { 0 };
  size_t start = _find_start(name, ltcname, sizeof(ltcname) - 1);
  return find_prng(ltcname + start);
}

/* Math::BigInt::LTM related */
typedef mp_int * Math__BigInt__LTM;
STATIC SV * sv_from_mpi(mp_int *mpi) {
  dTHX; /* fetch context */
  SV *obj = newSV(0);
  sv_setref_pv(obj, "Math::BigInt::LTM", (void*)mpi);
  return obj;
}

void _ecc_oid_lookup(ecc_key *key)
{
   int err;
   unsigned i, j;
   void *tmp;
   const ltc_ecc_curve *cu;

   key->dp.oidlen = 0;
   if ((err = ltc_mp.init(&tmp)) != CRYPT_OK) return;
   for (cu = ltc_ecc_curves; cu->prime != NULL; cu++) {
      if ((err = mp_read_radix(tmp, cu->prime, 16)) != CRYPT_OK) continue;
      if ((mp_cmp(tmp, key->dp.prime) != LTC_MP_EQ))             continue;
      if ((err = mp_read_radix(tmp, cu->order, 16)) != CRYPT_OK) continue;
      if ((mp_cmp(tmp, key->dp.order) != LTC_MP_EQ))             continue;
      if ((err = mp_read_radix(tmp, cu->A,     16)) != CRYPT_OK) continue;
      if ((mp_cmp(tmp, key->dp.A) != LTC_MP_EQ))                 continue;
      if ((err = mp_read_radix(tmp, cu->B,     16)) != CRYPT_OK) continue;
      if ((mp_cmp(tmp, key->dp.B) != LTC_MP_EQ))                 continue;
      if ((err = mp_read_radix(tmp, cu->Gx,    16)) != CRYPT_OK) continue;
      if ((mp_cmp(tmp, key->dp.base.x) != LTC_MP_EQ))            continue;
      if ((err = mp_read_radix(tmp, cu->Gy,    16)) != CRYPT_OK) continue;
      if ((mp_cmp(tmp, key->dp.base.y) != LTC_MP_EQ))            continue;
      if (key->dp.cofactor != cu->cofactor)                      continue;
      break; /* found */
   }
   ltc_mp.deinit(tmp);
   if (cu->prime && cu->OID) {
     for (i = 0; i < 16; i++) key->dp.oid[i] = 0;
     for (i = 0, j = 0; i < strlen(cu->OID); i++) {
       if (cu->OID[i] == '.') {
         if (++j >= 16) return;
       }
       else if(cu->OID[i] >= '0' && cu->OID[i] <= '9') {
         key->dp.oid[j] = key->dp.oid[j] * 10 + (cu->OID[i] - '0');
       }
       else {
         return;
       }
     }
     key->dp.oidlen = j + 1;
   }
}

int _ecc_set_curve_from_SV(ecc_key *key, SV *curve)
{
  dTHX; /* fetch context */
  HV *hc, *h;
  SV *sv_crv, **pref;
  SV **sv_cofactor, **sv_prime, **sv_A, **sv_B, **sv_order, **sv_Gx, **sv_Gy, **sv_oid;
  char *ptr_crv;
  STRLEN len_crv;
  int err;

  if (!SvOK(curve)) croak("FATAL: undefined curve");

  if (SvPOK(curve)) {
    /* string */
    ptr_crv = SvPV(curve, len_crv);
    if ((hc = get_hv("Crypt::PK::ECC::curve", 0)) == NULL) croak("FATAL: no curve register");
    pref = hv_fetch(hc, ptr_crv, (U32)len_crv, 0);
    if (pref && SvOK(*pref)) {
      sv_crv = *pref; /* found in %curve */
    }
    else {
      sv_crv = curve;
    }
  }
  else if (SvROK(curve)) {
    /* hashref */
    sv_crv = curve;
  }
  else {
    croak("FATAL: curve has to be a string or a hashref");
  }

  if (SvPOK(sv_crv)) {
    /* string - curve name */
    const ltc_ecc_curve *cu;
    ptr_crv = SvPV(sv_crv, len_crv);
    if (ecc_find_curve(ptr_crv, &cu) != CRYPT_OK) croak("FATAL: ecparams: unknown curve '%s'", ptr_crv);
    return ecc_set_curve(cu, key);
  }
  else {
    /* hashref */
    ltc_ecc_curve cu = { 0 };

    if ((h = (HV*)(SvRV(sv_crv))) == NULL) croak("FATAL: ecparams: param is not valid hashref");

    if ((sv_prime    = hv_fetchs(h, "prime",    0)) == NULL) croak("FATAL: ecparams: missing param prime");
    if ((sv_A        = hv_fetchs(h, "A",        0)) == NULL) croak("FATAL: ecparams: missing param A");
    if ((sv_B        = hv_fetchs(h, "B",        0)) == NULL) croak("FATAL: ecparams: missing param B");
    if ((sv_order    = hv_fetchs(h, "order",    0)) == NULL) croak("FATAL: ecparams: missing param order");
    if ((sv_Gx       = hv_fetchs(h, "Gx",       0)) == NULL) croak("FATAL: ecparams: missing param Gx");
    if ((sv_Gy       = hv_fetchs(h, "Gy",       0)) == NULL) croak("FATAL: ecparams: missing param Gy");
    if ((sv_cofactor = hv_fetchs(h, "cofactor", 0)) == NULL) croak("FATAL: ecparams: missing param cofactor");

    if (!SvOK(*sv_prime   )) croak("FATAL: ecparams: undefined param prime");
    if (!SvOK(*sv_A       )) croak("FATAL: ecparams: undefined param A");
    if (!SvOK(*sv_B       )) croak("FATAL: ecparams: undefined param B");
    if (!SvOK(*sv_order   )) croak("FATAL: ecparams: undefined param order");
    if (!SvOK(*sv_Gx      )) croak("FATAL: ecparams: undefined param Gx");
    if (!SvOK(*sv_Gy      )) croak("FATAL: ecparams: undefined param Gy");
    if (!SvOK(*sv_cofactor)) croak("FATAL: ecparams: undefined param cofactor");

    sv_oid = hv_fetchs(h, "oid", 0); /* 'oid' is optional */
    cu.OID = (sv_oid && SvOK(*sv_oid)) ? SvPV_nolen(*sv_oid) : NULL;

    cu.prime    = SvPV_nolen(*sv_prime);
    cu.A        = SvPV_nolen(*sv_A);
    cu.B        = SvPV_nolen(*sv_B);
    cu.order    = SvPV_nolen(*sv_order);
    cu.Gx       = SvPV_nolen(*sv_Gx);
    cu.Gy       = SvPV_nolen(*sv_Gy);
    cu.cofactor = (unsigned long)SvUV(*sv_cofactor);

    if ((err = ecc_set_curve(&cu, key)) != CRYPT_OK) return err;
    if (key->dp.oidlen == 0) _ecc_oid_lookup(key);
    return CRYPT_OK;
  }
}

#line 372 "CryptX.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 516 "CryptX.c"

XS_EUPXS(XS_CryptX__ltc_build_settings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_CryptX__ltc_build_settings)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 375 "CryptX.xs"
        RETVAL = newSVpv(crypt_build_settings, 0);
#line 528 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_CryptX__ltc_mp_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_CryptX__ltc_mp_name)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 382 "CryptX.xs"
        RETVAL = newSVpv(ltc_mp.name, 0);
#line 546 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_CryptX__ltc_mp_bits_per_digit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_CryptX__ltc_mp_bits_per_digit)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 389 "CryptX.xs"
        RETVAL = ltc_mp.bits_per_digit;
#line 565 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc__radix_to_bin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc__radix_to_bin)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "in, radix");
    {
	SV *	RETVAL;
	char *        in = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	int	radix = (int)SvIV(ST(1))
;
#line 400 "CryptX.xs"
    {
        STRLEN len;
        unsigned char *out_data;
        mp_int mpi;

        if (in == NULL) XSRETURN_UNDEF;
        if (mp_init(&mpi) != MP_OKAY) XSRETURN_UNDEF;
        if (strlen(in) == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else if (mp_read_radix(&mpi, in, radix) == CRYPT_OK) {
          len = mp_unsigned_bin_size(&mpi);
          if (len == 0) {
            RETVAL = newSVpvn("", 0);
          }
          else {
            RETVAL = NEWSV(0, len); /* avoid zero! */
            SvPOK_only(RETVAL);
            SvCUR_set(RETVAL, len);
            out_data = (unsigned char *)SvPVX(RETVAL);
            if (mp_to_unsigned_bin(&mpi, out_data) != MP_OKAY) {
              SvREFCNT_dec(RETVAL);
              RETVAL = newSVpvn(NULL, 0); /* undef */
            }
          }
        }
        else {
          RETVAL = newSVpvn(NULL, 0); /* undef */
        }
        mp_clear(&mpi);
    }
#line 617 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc__bin_to_radix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc__bin_to_radix)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "in, radix");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
	int	radix = (int)SvIV(ST(1))
;
#line 437 "CryptX.xs"
    {
        STRLEN len;
        unsigned char *in_data;
        char *out_data;
        mp_int mpi, tmp;
        mp_digit d;
        mp_err merr;
        int digits = 0;

        if (!SvPOK(in) || radix < 2 || radix > 64) XSRETURN_UNDEF;
        in_data = (unsigned char *) SvPVbyte(in, len);
        if (mp_init_multi(&mpi, &tmp, NULL) != MP_OKAY) XSRETURN_UNDEF;
        if (len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          if (mp_read_unsigned_bin(&mpi, in_data, (unsigned long)len) == CRYPT_OK) {
            merr = mp_copy(&mpi, &tmp);
            while (merr == MP_OKAY && mp_iszero(&tmp) == MP_NO) {
              merr = mp_div_d(&tmp, (mp_digit)radix, &tmp, &d);
              digits++;
            }
            if (merr != MP_OKAY) {
              RETVAL = newSVpvn(NULL, 0); /* undef */
            }
            else if (digits == 0) {
              RETVAL = newSVpvn("", 0);
            }
            else {
              RETVAL = NEWSV(0, digits + 2); /* +2 for sign and NUL byte */
              SvPOK_only(RETVAL);
              out_data = SvPVX(RETVAL);
              if (mp_toradix(&mpi, out_data, radix) == MP_OKAY) {
                SvCUR_set(RETVAL, strlen(out_data));
              }
              else {
                SvREFCNT_dec(RETVAL);
                RETVAL = newSVpvn(NULL, 0); /* undef */
              }
            }
          }
          else {
            RETVAL = newSVpvn(NULL, 0); /* undef */
          }
        }
        mp_clear_multi(&tmp, &mpi, NULL);
    }
#line 685 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc_encode_b64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc_encode_b64)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
#line 492 "CryptX.xs"
    {
        int rv;
        STRLEN in_len;
        unsigned long out_len;
        unsigned char *in_data;
        char *out_data;

        if (!SvPOK(in)) XSRETURN_UNDEF;
        in_data = (unsigned char *) SvPVbyte(in, in_len);
        if (in_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          out_len = (unsigned long)(4 * ((in_len + 2) / 3) + 1);
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          out_data = SvPVX(RETVAL);
          if (ix == 1)
            rv = base64url_encode(in_data, (unsigned long)in_len, out_data, &out_len);
          else
            rv = base64_encode(in_data, (unsigned long)in_len, out_data, &out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            XSRETURN_UNDEF;
          }
          SvCUR_set(RETVAL, out_len);
        }
    }
#line 733 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc_decode_b64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc_decode_b64)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
#line 528 "CryptX.xs"
    {
        int rv;
        STRLEN in_len;
        unsigned long out_len;
        unsigned char *out_data;
        char *in_data;

        if (!SvPOK(in)) XSRETURN_UNDEF;
        in_data = SvPVbyte(in, in_len);
        if (in_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          out_len = (unsigned long)in_len;
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          out_data = (unsigned char *)SvPVX(RETVAL);
          if (ix == 1)
            rv = base64url_sane_decode(in_data, (unsigned long)in_len, out_data, &out_len);
          else
            rv = base64_sane_decode(in_data, (unsigned long)in_len, out_data, &out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            XSRETURN_UNDEF;
          }
          SvCUR_set(RETVAL, out_len);
        }
    }
#line 781 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc_encode_b32r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc_encode_b32r)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
#line 566 "CryptX.xs"
    {
        STRLEN in_len;
        unsigned long out_len;
        unsigned char *in_data;
        char *out_data;
        int id = -1, err;

        if (!SvPOK(in)) XSRETURN_UNDEF;
        if (ix == 0) id = BASE32_RFC4648;
        if (ix == 1) id = BASE32_BASE32HEX;
        if (ix == 2) id = BASE32_ZBASE32;
        if (ix == 3) id = BASE32_CROCKFORD;
        if (id == -1) XSRETURN_UNDEF;
        in_data = (unsigned char *) SvPVbyte(in, in_len);
        if (in_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          out_len = (unsigned long)((8 * in_len + 4) / 5 + 1);
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          out_data = SvPVX(RETVAL);
          err = base32_encode(in_data, (unsigned long)in_len, out_data, &out_len, id);
          if (err != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            XSRETURN_UNDEF;
          }
          SvCUR_set(RETVAL, out_len);
        }
    }
#line 831 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc_decode_b32r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc_decode_b32r)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
#line 606 "CryptX.xs"
    {
        STRLEN in_len;
        unsigned long out_len;
        unsigned char *out_data;
        char *in_data;
        int id = -1, err;

        if (!SvPOK(in)) XSRETURN_UNDEF;
        if (ix == 0) id = BASE32_RFC4648;
        if (ix == 1) id = BASE32_BASE32HEX;
        if (ix == 2) id = BASE32_ZBASE32;
        if (ix == 3) id = BASE32_CROCKFORD;
        if (id == -1) XSRETURN_UNDEF;
        in_data = SvPVbyte(in, in_len);
        if (in_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          out_len = (unsigned long)in_len;
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          out_data = (unsigned char *)SvPVX(RETVAL);
          err = base32_decode(in_data, (unsigned long)in_len, out_data, &out_len, id);
          if (err != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            XSRETURN_UNDEF;
          }
          SvCUR_set(RETVAL, out_len);
        }
    }
#line 881 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc_increment_octets_le); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc_increment_octets_le)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
#line 642 "CryptX.xs"
    {
        STRLEN len, i = 0;
        unsigned char *out_data, *in_data;

        if (!SvPOK(in)) XSRETURN_UNDEF;
        in_data = (unsigned char *)SvPVbyte(in, len);
        if (len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          Copy(in_data, out_data, len, unsigned char);
          while (i < len) {
            out_data[i]++;
            if (0 != out_data[i]) break;
            i++;
          }
          if (i == len) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: increment_octets_le overflow");
          }
        }
    }
#line 926 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Misc_increment_octets_be); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Misc_increment_octets_be)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
#line 674 "CryptX.xs"
    {
        STRLEN len, i = 0;
        unsigned char *out_data, *in_data;

        if (!SvPOK(in)) XSRETURN_UNDEF;
        in_data = (unsigned char *)SvPVbyte(in, len);
        if (len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          Copy(in_data, out_data, len, unsigned char);
          while (i < len) {
            out_data[len - 1 - i]++;
            if (0 != out_data[len - 1 - i]) break;
            i++;
          }
          if (i == len) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: increment_octets_be overflow");
          }
        }
    }
#line 971 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE:  Including 'inc/CryptX_Digest.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_Digest_SHAKE.xs.inc' from 'inc/CryptX_Digest.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Cipher.xs.inc' from 'inc/CryptX_Digest_SHAKE.xs.inc' */


XS_EUPXS(XS_Crypt__Cipher_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_new)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "class, ...");
    {
	Crypt__Cipher	RETVAL;
	char *        class = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
#line 8 "./inc/CryptX_Cipher.xs.inc"
    {
        STRLEN key_len;
        unsigned char *key_data = NULL;
        SV *key;
        char *cipher_name;
        int rv, id, rounds = 0, idx;

        /* we need to handle:
           Crypt::Cipher->new('AES');
           Crypt::Cipher::AES->new();
         */
        idx = strcmp("Crypt::Cipher", class) == 0 ? 1 : 0;
        if (idx + 1 > items) croak("FATAL: missing argument");
        cipher_name = SvPVX(ST(idx));
        key = ST(idx + 1);
        if (idx + 3 <= items) rounds = (int)SvIV(ST(idx + 2));

        if (!SvPOK (key)) croak("FATAL: key must be string scalar");
        key_data = (unsigned char *)SvPVbyte(key, key_len);

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        Newz(0, RETVAL, 1, struct cipher_struct);
        if (!RETVAL) croak("FATAL: Newz failed");

        RETVAL->desc = &cipher_descriptor[id];
        rv = RETVAL->desc->setup(key_data, (int)key_len, rounds, &RETVAL->skey);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: cipher setup failed: %s", error_to_string(rv));
        }
    }
#line 1032 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Cipher", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Cipher_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Cipher	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Cipher,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Cipher::DESTROY",
			"self")
;
#line 47 "./inc/CryptX_Cipher.xs.inc"
        Safefree(self);
#line 1064 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Cipher_encrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_encrypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Cipher	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Cipher")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Cipher,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Cipher::encrypt",
			"self", "Crypt::Cipher",
			refstr, ST(0)
		);
	}
;
#line 52 "./inc/CryptX_Cipher.xs.inc"
    {
        int rv;
        STRLEN len;
        void *plaintext = SvPVbyte(data, len);

        if (len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else if (len == (STRLEN)self->desc->block_length) {
          RETVAL = NEWSV(0, len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, len);
          rv = self->desc->ecb_encrypt((unsigned char *)plaintext, (unsigned char *)SvPVX(RETVAL), &self->skey);
          if (rv!=CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: encrypt failed: %s", error_to_string(rv));
          }
        }
        else {
          croak ("FATAL: input size not equal to blocksize (%d)", self->desc->block_length);
        }
    }
#line 1118 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Cipher_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_decrypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Cipher	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Cipher")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Cipher,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Cipher::decrypt",
			"self", "Crypt::Cipher",
			refstr, ST(0)
		);
	}
;
#line 80 "./inc/CryptX_Cipher.xs.inc"
    {
        int rv;
        STRLEN len;
        void *ciphertext = SvPVbyte(data, len);

        if (len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else if (len == (STRLEN)self->desc->block_length) {
          RETVAL = NEWSV(0, len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, len);
          rv = self->desc->ecb_decrypt((unsigned char *)ciphertext, (unsigned char *)SvPVX(RETVAL), &self->skey);
          if (rv!=CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: decrypt failed: %s", error_to_string(rv));
          }
        }
        else {
          croak ("FATAL: input size not equal to blocksize (%d)", self->desc->block_length);
        }
    }
#line 1174 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Cipher_blocksize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_blocksize)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "param, extra= NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	param = ST(0)
;
	char *	extra;

	if (items < 2)
	    extra = NULL;
	else {
	extra = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}
#line 108 "./inc/CryptX_Cipher.xs.inc"
    {
        if (sv_isobject(param) && sv_derived_from(param, "Crypt::Cipher")) {
          IV tmp = SvIV((SV*)SvRV(param));
          Crypt__Cipher obj = INT2PTR(Crypt__Cipher, tmp);
          RETVAL = obj->desc->block_length;
        }
        else {
          char *name = SvPOK(param) && strcmp(SvPVX(param), "Crypt::Cipher") ? SvPVX(param) : extra;
          int rv, id = _find_cipher(name);
          if (id == -1) croak("FATAL: find_cipher failed for '%s'", name);
          rv = cipher_descriptor[id].block_length;
          if (!rv) croak("FATAL: invalid block_length for '%s'", name);
          RETVAL = rv;
        }
    }
#line 1217 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Cipher_max_keysize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_max_keysize)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "param, extra= NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	param = ST(0)
;
	char *	extra;

	if (items < 2)
	    extra = NULL;
	else {
	extra = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}
#line 129 "./inc/CryptX_Cipher.xs.inc"
    {
        if (sv_isobject(param) && sv_derived_from(param, "Crypt::Cipher")) {
          IV tmp = SvIV((SV*)SvRV(param));
          Crypt__Cipher obj = INT2PTR(Crypt__Cipher, tmp);
          RETVAL = obj->desc->max_key_length;
        }
        else {
          char *name = SvPOK(param) && strcmp(SvPVX(param), "Crypt::Cipher") ? SvPVX(param) : extra;
          int rv, id = _find_cipher(name);
          if (id == -1) croak("FATAL: find_cipher failed for '%s'", name);
          rv = cipher_descriptor[id].max_key_length;
          if (!rv) croak("FATAL: invalid max_key_length for '%s'", name);
          RETVAL = rv;
        }
    }
#line 1260 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Cipher_min_keysize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_min_keysize)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "param, extra= NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	param = ST(0)
;
	char *	extra;

	if (items < 2)
	    extra = NULL;
	else {
	extra = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}
#line 150 "./inc/CryptX_Cipher.xs.inc"
    {
        if (sv_isobject(param) && sv_derived_from(param, "Crypt::Cipher")) {
          IV tmp = SvIV((SV*)SvRV(param));
          Crypt__Cipher obj = INT2PTR(Crypt__Cipher, tmp);
          RETVAL = obj->desc->min_key_length;
        }
        else {
          char *name = SvPOK(param) && strcmp(SvPVX(param), "Crypt::Cipher") ? SvPVX(param) : extra;
          int rv, id = _find_cipher(name);
          if (id == -1) croak("FATAL: find_cipher failed for '%s'", name);
          rv = cipher_descriptor[id].min_key_length;
          if (!rv) croak("FATAL: invalid min_key_length for '%s'", name);
          RETVAL = rv;
        }
    }
#line 1303 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Cipher_default_rounds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Cipher_default_rounds)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "param, extra= NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	param = ST(0)
;
	char *	extra;

	if (items < 2)
	    extra = NULL;
	else {
	extra = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}
#line 171 "./inc/CryptX_Cipher.xs.inc"
    {
        if (sv_isobject(param) && sv_derived_from(param, "Crypt::Cipher")) {
          IV tmp = SvIV((SV*)SvRV(param));
          Crypt__Cipher obj = INT2PTR(Crypt__Cipher, tmp);
          RETVAL = obj->desc->default_rounds;
        }
        else {
          char *name = SvPOK(param) && strcmp(SvPVX(param), "Crypt::Cipher") ? SvPVX(param) : extra;
          int rv, id = _find_cipher(name);
          if (id == -1) croak("FATAL: find_cipher failed for '%s'", name);
          rv = cipher_descriptor[id].default_rounds;
          if (!rv) XSRETURN_UNDEF;
          RETVAL = rv;
        }
    }
#line 1346 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Digest_SHAKE.xs.inc' from 'inc/CryptX_Cipher.xs.inc' */


XS_EUPXS(XS_Crypt__Digest__SHAKE_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest__SHAKE_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, num");
    {
	Crypt__Digest__SHAKE	RETVAL;
	int	num = (int)SvIV(ST(1))
;
#line 8 "./inc/CryptX_Digest_SHAKE.xs.inc"
    {
        int rv;

        Newz(0, RETVAL, 1, struct digest_shake_struct);
        if (!RETVAL) croak("FATAL: Newz failed");

        RETVAL->num = num;
        rv = sha3_shake_init(&RETVAL->state, RETVAL->num);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: sha3_shake_init failed: %s", error_to_string(rv));
        }
    }
#line 1381 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Digest::SHAKE", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Digest__SHAKE_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest__SHAKE_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Digest__SHAKE	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest__SHAKE,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Digest::SHAKE::DESTROY",
			"self")
;
#line 27 "./inc/CryptX_Digest_SHAKE.xs.inc"
        Safefree(self);
#line 1413 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Digest__SHAKE_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest__SHAKE_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Digest__SHAKE	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest::SHAKE")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest__SHAKE,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::SHAKE::reset",
			"self", "Crypt::Digest::SHAKE",
			refstr, ST(0)
		);
	}
;
#line 32 "./inc/CryptX_Digest_SHAKE.xs.inc"
    {
        int rv;
        rv = sha3_shake_init(&self->state, self->num);
        if (rv != CRYPT_OK) croak("FATAL: sha3_shake_init failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 1450 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Digest__SHAKE_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest__SHAKE_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Digest__SHAKE	RETVAL;
	Crypt__Digest__SHAKE	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest::SHAKE")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest__SHAKE,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::SHAKE::clone",
			"self", "Crypt::Digest::SHAKE",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_Digest_SHAKE.xs.inc"
        Newz(0, RETVAL, 1, struct digest_shake_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(&self->state, &RETVAL->state, 1, struct digest_shake_struct);
#line 1484 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Digest::SHAKE", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Digest__SHAKE_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest__SHAKE_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Digest__SHAKE	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest::SHAKE")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest__SHAKE,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::SHAKE::add",
			"self", "Crypt::Digest::SHAKE",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Digest_SHAKE.xs.inc"
    {
        STRLEN inlen;
        int rv, i;
        unsigned char *in;

        for(i=1; i<items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen>0) {
            rv = sha3_shake_process(&self->state, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: sha3_shake_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 1535 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Digest__SHAKE_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest__SHAKE_done)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Digest__SHAKE	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest::SHAKE")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest__SHAKE,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::SHAKE::done",
			"self", "Crypt::Digest::SHAKE",
			refstr, ST(0)
		);
	}
;
#line 69 "./inc/CryptX_Digest_SHAKE.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = sha3_shake_done(&self->state, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: sha3_shake_done failed: %s", error_to_string(rv));
          }
        }
    }
#line 1587 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Digest.xs.inc' from 'inc/CryptX_Digest_SHAKE.xs.inc' */


XS_EUPXS(XS_Crypt__Digest_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "cname, pname= NULL");
    {
	Crypt__Digest	RETVAL;
	char *        cname = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	char *	pname;

	if (items < 2)
	    pname = NULL;
	else {
	pname = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}
#line 8 "./inc/CryptX_Digest.xs.inc"
    {
        int rv;
        int id;
        char *digest_name = strcmp(cname, "Crypt::Digest") == 0 ? pname : cname;

        id = _find_hash(digest_name);
        if (id == -1) croak("FATAL: find_hash failed for '%s'", digest_name);

        Newz(0, RETVAL, 1, struct digest_struct);
        if (!RETVAL) croak("FATAL: Newz failed");

        RETVAL->desc = &hash_descriptor[id];
        rv = RETVAL->desc->init(&RETVAL->state);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: digest setup failed: %s", error_to_string(rv));
        }
    }
#line 1635 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Digest", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Digest_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Digest	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Digest::DESTROY",
			"self")
;
#line 32 "./inc/CryptX_Digest.xs.inc"
        Safefree(self);
#line 1667 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Digest_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Digest	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::reset",
			"self", "Crypt::Digest",
			refstr, ST(0)
		);
	}
;
#line 37 "./inc/CryptX_Digest.xs.inc"
    {
        int rv;
        rv = self->desc->init(&self->state);
        if (rv != CRYPT_OK) croak("FATAL: digest init failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 1704 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Digest_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Digest	RETVAL;
	Crypt__Digest	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::clone",
			"self", "Crypt::Digest",
			refstr, ST(0)
		);
	}
;
#line 47 "./inc/CryptX_Digest.xs.inc"
        Newz(0, RETVAL, 1, struct digest_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(&self->state, &RETVAL->state, 1, struct digest_struct);
#line 1738 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Digest", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Digest_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Digest	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Digest::add",
			"self", "Crypt::Digest",
			refstr, ST(0)
		);
	}
;
#line 56 "./inc/CryptX_Digest.xs.inc"
    {
        STRLEN inlen;
        int rv, i;
        unsigned char *in;

        for(i = 1; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = self->desc->process(&self->state, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: digest process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 1789 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Digest_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_digest)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Digest	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Digest")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Digest,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Digest",
			refstr, ST(0)
		);
	}
;
#line 78 "./inc/CryptX_Digest.xs.inc"
    {
        int rv;
        unsigned long outlen;
        unsigned char hash[MAXBLOCKSIZE];
        char out[MAXBLOCKSIZE*2+1];

        rv = self->desc->done(&self->state, hash);
        if (rv != CRYPT_OK) croak("FATAL: digest done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(hash, self->desc->hashsize, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(hash, self->desc->hashsize, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(hash, self->desc->hashsize, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) hash, self->desc->hashsize);
        }
    }
#line 1850 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Digest_digest_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_digest_data)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "digest_name, ...");
    {
	SV *	RETVAL;
	char *        digest_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
#line 117 "./inc/CryptX_Digest.xs.inc"
    {
        STRLEN inlen;
        int rv, id, i;
        unsigned char *in, hash[MAXBLOCKSIZE];
        unsigned long len = sizeof(hash), outlen;
        char out[MAXBLOCKSIZE*2+1];
        hash_state md;

        id = _find_hash(digest_name);
        if (id == -1) croak("FATAL: find_digest failed for '%s'", digest_name);

        /* digest_data("SHA1", $data1, $data2, $data3); */
        len = hash_descriptor[id].hashsize;
        rv = hash_descriptor[id].init(&md);
        if (rv != CRYPT_OK) croak("FATAL: digest init failed: %s", error_to_string(rv));
        for (i = 1; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = hash_descriptor[id].process(&md, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: digest process failed: %s", error_to_string(rv));
          }
        }
        rv = hash_descriptor[id].done(&md, hash);
        if (rv != CRYPT_OK) croak("FATAL: digest done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(hash, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(hash, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(hash, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) hash, len);
        }
    }
#line 1915 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Digest_hashsize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Digest_hashsize)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "param, extra= NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	param = ST(0)
;
	char *	extra;

	if (items < 2)
	    extra = NULL;
	else {
	extra = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}
#line 168 "./inc/CryptX_Digest.xs.inc"
    {
        if (sv_isobject(param) && sv_derived_from(param, "Crypt::Digest")) {
          IV tmp = SvIV((SV*)SvRV(param));
          Crypt__Digest obj = INT2PTR(Crypt__Digest, tmp);
          RETVAL = obj->desc->hashsize;
        }
        else {
          char *digest_name;
          int rv, id;
          digest_name = SvPOK(param) && strcmp(SvPVX(param), "Crypt::Digest") ? SvPVX(param) : extra;
          id = _find_hash(digest_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", digest_name);
          rv = hash_descriptor[id].hashsize;
          if (!rv) croak("FATAL: invalid hashsize for '%s'", digest_name);;
          RETVAL = rv;
        }
    }
#line 1960 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_Digest.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Checksum_Adler32.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_Checksum_CRC32.xs.inc' from 'inc/CryptX_Checksum_Adler32.xs.inc' */


XS_EUPXS(XS_Crypt__Checksum__CRC32_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
	Crypt__Checksum__CRC32	RETVAL;
#line 8 "./inc/CryptX_Checksum_CRC32.xs.inc"
    {
        Newz(0, RETVAL, 1, crc32_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        crc32_init(RETVAL); /* returns void */
    }
#line 1991 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Checksum::CRC32", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Checksum__CRC32_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Checksum__CRC32	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__CRC32,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Checksum::CRC32::DESTROY",
			"self")
;
#line 19 "./inc/CryptX_Checksum_CRC32.xs.inc"
        Safefree(self);
#line 2023 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Checksum__CRC32_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Checksum__CRC32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::CRC32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__CRC32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Checksum::CRC32::reset",
			"self", "Crypt::Checksum::CRC32",
			refstr, ST(0)
		);
	}
;
#line 24 "./inc/CryptX_Checksum_CRC32.xs.inc"
    {
        crc32_init(self); /* returns void */
        XPUSHs(ST(0)); /* return self */
    }
#line 2058 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Checksum__CRC32_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Checksum__CRC32	RETVAL;
	Crypt__Checksum__CRC32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::CRC32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__CRC32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Checksum::CRC32::clone",
			"self", "Crypt::Checksum::CRC32",
			refstr, ST(0)
		);
	}
;
#line 32 "./inc/CryptX_Checksum_CRC32.xs.inc"
        Newz(0, RETVAL, 1, crc32_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, crc32_state);
#line 2092 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Checksum::CRC32", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Checksum__CRC32_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Checksum__CRC32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::CRC32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__CRC32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Checksum::CRC32::add",
			"self", "Crypt::Checksum::CRC32",
			refstr, ST(0)
		);
	}
;
#line 41 "./inc/CryptX_Checksum_CRC32.xs.inc"
    {
        STRLEN inlen;
        int i;
        unsigned char *in;
        for(i=1; i<items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            crc32_update(self, in, (unsigned long)inlen); /* returns void */
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 2141 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Checksum__CRC32_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_digest)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Checksum__CRC32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::CRC32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__CRC32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Checksum::CRC32",
			refstr, ST(0)
		);
	}
;
#line 60 "./inc/CryptX_Checksum_CRC32.xs.inc"
    {
        int rv;
        unsigned char hash[4];
        char out[9];
        unsigned long outlen = 9;
        unsigned int ui32;

        crc32_finish(self, hash, 4); /* returns void */
        if (ix == 1) {
          rv = base16_encode(hash, 4, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 2) {
          LOAD32H(ui32, hash);
          RETVAL = newSVuv(ui32);
        }
        else {
          RETVAL = newSVpvn((char *) hash, 4);
        }
    }
#line 2194 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Checksum__CRC32_crc32_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__CRC32_crc32_data)
{
    dVAR; dXSARGS;
    dXSI32;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	RETVAL;
#line 90 "./inc/CryptX_Checksum_CRC32.xs.inc"
    {
        crc32_state st;
        int rv, j;
        unsigned char hash[4], *in;
        char out[9];
        unsigned long outlen = 9;
        unsigned int ui32;
        STRLEN inlen;

        crc32_init(&st);
        for(j = 0; j < items; j++) {
          in = (unsigned char *)SvPVbyte(ST(j), inlen);
          if (inlen > 0) {
            crc32_update(&st, in, (unsigned long)inlen); /* returns void */
          }
        }
        crc32_finish(&st, hash, 4); /* returns void */
        if (ix == 1) {
          rv = base16_encode(hash, 4, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 2) {
          LOAD32H(ui32, hash);
          RETVAL = newSVuv(ui32);
        }
        else {
          RETVAL = newSVpvn((char *) hash, 4);
        }
    }
#line 2242 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Checksum_Adler32.xs.inc' from 'inc/CryptX_Checksum_CRC32.xs.inc' */


XS_EUPXS(XS_Crypt__Checksum__Adler32_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
	Crypt__Checksum__Adler32	RETVAL;
#line 8 "./inc/CryptX_Checksum_Adler32.xs.inc"
    {
        Newz(0, RETVAL, 1, adler32_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        adler32_init(RETVAL); /* returns void */
    }
#line 2267 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Checksum::Adler32", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Checksum__Adler32_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Checksum__Adler32	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__Adler32,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Checksum::Adler32::DESTROY",
			"self")
;
#line 19 "./inc/CryptX_Checksum_Adler32.xs.inc"
        Safefree(self);
#line 2299 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Checksum__Adler32_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Checksum__Adler32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::Adler32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__Adler32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Checksum::Adler32::reset",
			"self", "Crypt::Checksum::Adler32",
			refstr, ST(0)
		);
	}
;
#line 24 "./inc/CryptX_Checksum_Adler32.xs.inc"
    {
        adler32_init(self); /* returns void */
        XPUSHs(ST(0)); /* return self */
    }
#line 2334 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Checksum__Adler32_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Checksum__Adler32	RETVAL;
	Crypt__Checksum__Adler32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::Adler32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__Adler32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Checksum::Adler32::clone",
			"self", "Crypt::Checksum::Adler32",
			refstr, ST(0)
		);
	}
;
#line 32 "./inc/CryptX_Checksum_Adler32.xs.inc"
        Newz(0, RETVAL, 1, adler32_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, adler32_state);
#line 2368 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Checksum::Adler32", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Checksum__Adler32_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Checksum__Adler32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::Adler32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__Adler32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Checksum::Adler32::add",
			"self", "Crypt::Checksum::Adler32",
			refstr, ST(0)
		);
	}
;
#line 41 "./inc/CryptX_Checksum_Adler32.xs.inc"
    {
        STRLEN inlen;
        int i;
        unsigned char *in;
        for(i=1; i<items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            adler32_update(self, in, (unsigned long)inlen); /* returns void */
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 2417 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Checksum__Adler32_digest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_digest)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Checksum__Adler32	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Checksum::Adler32")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Checksum__Adler32,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Checksum::Adler32",
			refstr, ST(0)
		);
	}
;
#line 60 "./inc/CryptX_Checksum_Adler32.xs.inc"
    {
        int rv;
        unsigned char hash[4];
        char out[9];
        unsigned long outlen = 9;
        unsigned int ui32;

        adler32_finish(self, hash, 4); /* returns void */
        if (ix == 1) {
          rv = base16_encode(hash, 4, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 2) {
          LOAD32H(ui32, hash);
          RETVAL = newSVuv(ui32);
        }
        else {
          RETVAL = newSVpvn((char *) hash, 4);
        }
    }
#line 2470 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Checksum__Adler32_adler32_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Checksum__Adler32_adler32_data)
{
    dVAR; dXSARGS;
    dXSI32;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	RETVAL;
#line 90 "./inc/CryptX_Checksum_Adler32.xs.inc"
    {
        adler32_state st;
        int rv, j;
        unsigned char hash[4], *in;
        char out[9];
        unsigned long outlen = 9;
        unsigned int ui32;
        STRLEN inlen;

        adler32_init(&st);
        for(j = 0; j < items; j++) {
          in = (unsigned char *)SvPVbyte(ST(j), inlen);
          if (inlen > 0) {
            adler32_update(&st, in, (unsigned long)inlen); /* returns void */
          }
        }
        adler32_finish(&st, hash, 4); /* returns void */
        if (ix == 1) {
          rv = base16_encode(hash, 4, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 2) {
          LOAD32H(ui32, hash);
          RETVAL = newSVuv(ui32);
        }
        else {
          RETVAL = newSVpvn((char *) hash, 4);
        }
    }
#line 2518 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_Checksum_Adler32.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_AuthEnc_EAX.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_AuthEnc_GCM.xs.inc' from 'inc/CryptX_AuthEnc_EAX.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_AuthEnc_OCB.xs.inc' from 'inc/CryptX_AuthEnc_GCM.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_AuthEnc_CCM.xs.inc' from 'inc/CryptX_AuthEnc_OCB.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc' from 'inc/CryptX_AuthEnc_CCM.xs.inc' */


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "Class, key, nonce= NULL");
    {
	Crypt__AuthEnc__ChaCha20Poly1305	RETVAL;
	SV *	key = ST(1)
;
	SV *	nonce;

	if (items < 3)
	    nonce = NULL;
	else {
	    nonce = ST(2)
;
	}
#line 8 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        STRLEN iv_len=0, k_len=0;
        unsigned char *iv=NULL, *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k  = (unsigned char *) SvPVbyte(key, k_len);
        if (nonce) {
          if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
          iv = (unsigned char *) SvPVbyte(nonce, iv_len);
        }

        Newz(0, RETVAL, 1, chacha20poly1305_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = chacha20poly1305_init(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: chacha20poly1305_init failed: %s", error_to_string(rv));
        }

        if (iv && iv_len > 0) {
          rv = chacha20poly1305_setiv(RETVAL, iv, (unsigned long)iv_len);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: chacha20poly1305_setiv failed: %s", error_to_string(rv));
          }
        }
    }
#line 2592 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::ChaCha20Poly1305", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__ChaCha20Poly1305	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::AuthEnc::ChaCha20Poly1305::DESTROY",
			"self")
;
#line 43 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
        Safefree(self);
#line 2624 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__ChaCha20Poly1305	RETVAL;
	Crypt__AuthEnc__ChaCha20Poly1305	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::clone",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 48 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
        Newz(0, RETVAL, 1, chacha20poly1305_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, chacha20poly1305_state);
#line 2657 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::ChaCha20Poly1305", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_set_iv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_set_iv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, nonce");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__ChaCha20Poly1305	self;
	SV *	nonce = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::set_iv",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 57 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        STRLEN iv_len=0;
        unsigned char *iv=NULL;

        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        iv = (unsigned char *) SvPVbyte(nonce, iv_len);
        rv = chacha20poly1305_setiv(self, iv, (unsigned long)iv_len);
        if (rv != CRYPT_OK) croak("FATAL: chacha20poly1305_setiv failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */;
    }
#line 2707 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_set_iv_rfc7905); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_set_iv_rfc7905)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, nonce, seqnum");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__ChaCha20Poly1305	self;
	SV *	nonce = ST(1)
;
	UV	seqnum = (UV)SvUV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::set_iv_rfc7905",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 72 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        STRLEN iv_len=0;
        unsigned char *iv=NULL;

        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        iv = (unsigned char *) SvPVbyte(nonce, iv_len);
        rv = chacha20poly1305_setiv_rfc7905(self, iv, (unsigned long)iv_len, (ulong64)seqnum);
        if (rv != CRYPT_OK) croak("FATAL: chacha20poly1305_setiv_rfc7905 failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 2754 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_adata_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_adata_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__ChaCha20Poly1305	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::adata_add",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 87 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        rv = chacha20poly1305_add_aad(self, in_data, (unsigned long)in_data_len);
        if (rv != CRYPT_OK) croak("FATAL: chacha20poly1305_add_aad failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 2798 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_decrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_decrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__ChaCha20Poly1305	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::decrypt_add",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 101 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = chacha20poly1305_decrypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: chacha20poly1305_decrypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 2852 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_encrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_encrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__ChaCha20Poly1305	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::encrypt_add",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 128 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = chacha20poly1305_encrypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: chacha20poly1305_encrypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 2907 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_encrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_encrypt_done)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__ChaCha20Poly1305	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::encrypt_done",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 155 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);

        rv = chacha20poly1305_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: chacha20poly1305_done failed: %s", error_to_string(rv));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 2949 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_decrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_decrypt_done)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__ChaCha20Poly1305	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::ChaCha20Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__ChaCha20Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::ChaCha20Poly1305::decrypt_done",
			"self", "Crypt::AuthEnc::ChaCha20Poly1305",
			refstr, ST(0)
		);
	}
;
#line 168 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        STRLEN expected_tag_len;
        unsigned char *expected_tag;

        rv = chacha20poly1305_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: chacha20poly1305_done failed: %s", error_to_string(rv));
        if (items == 1) {
          XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
        }
        else {
          if (!SvPOK(ST(1))) croak("FATAL: expected_tag must be string/buffer scalar");
          expected_tag = (unsigned char *) SvPVbyte(ST(1), expected_tag_len);
          if (expected_tag_len!=tag_len) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else if (memNE(expected_tag, tag, tag_len)) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else {
            XPUSHs(sv_2mortal(newSViv(1))); /* true */
          }
        }
    }
#line 3007 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_chacha20poly1305_encrypt_authenticate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_chacha20poly1305_encrypt_authenticate)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "key, nonce, header, plaintext");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	key = ST(0)
;
	SV *	nonce = ST(1)
;
	SV *	header = ST(2)
;
	SV *	plaintext = ST(3)
;
#line 198 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, pt_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *pt = NULL;
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        SV *output;

        if (SvPOK(key))       k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))     n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(plaintext)) pt = (unsigned char *) SvPVbyte(plaintext, pt_len);
        if (SvPOK(header))    h  = (unsigned char *) SvPVbyte(header, h_len);

        output = NEWSV(0, pt_len > 0 ? pt_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, pt_len);

        rv = chacha20poly1305_memory(k, (unsigned long)k_len, n, (unsigned long)n_len, h, (unsigned long)h_len,
                                     pt, (unsigned long)pt_len, (unsigned char *)SvPVX(output), tag, &tag_len,
                                     CHACHA20POLY1305_ENCRYPT);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          croak("FATAL: ccm_memory failed: %s", error_to_string(rv));
        }
        XPUSHs(sv_2mortal(output));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 3060 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_chacha20poly1305_decrypt_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__ChaCha20Poly1305_chacha20poly1305_decrypt_verify)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "key, nonce, header, ciphertext, tagsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	key = ST(0)
;
	SV *	nonce = ST(1)
;
	SV *	header = ST(2)
;
	SV *	ciphertext = ST(3)
;
	SV *	tagsv = ST(4)
;
#line 230 "./inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, ct_len = 0, t_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *ct = NULL, *t = NULL;
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len;
        SV *output;

        if (SvPOK(key))        k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))      n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(ciphertext)) ct = (unsigned char *) SvPVbyte(ciphertext, ct_len);
        if (SvPOK(tagsv))      t  = (unsigned char *) SvPVbyte(tagsv, t_len);
        if (SvPOK(header))     h  = (unsigned char *) SvPVbyte(header, h_len);

        output = NEWSV(0, ct_len > 0 ? ct_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, ct_len);
        tag_len = (unsigned long)t_len;
        Copy(t, tag, t_len, unsigned char);

        rv = chacha20poly1305_memory(k, (unsigned long)k_len, n, (unsigned long)n_len, h, (unsigned long)h_len,
                                     ct, (unsigned long)ct_len, (unsigned char *)SvPVX(output), tag, &tag_len,
                                     CHACHA20POLY1305_DECRYPT);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          XPUSHs(sv_2mortal(newSVpvn(NULL,0))); /* undef */
        }
        else {
          XPUSHs(sv_2mortal(output));
        }
    }
#line 3119 "CryptX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'inc/CryptX_AuthEnc_CCM.xs.inc' from 'inc/CryptX_AuthEnc_ChaCha20Poly1305.xs.inc' */


XS_EUPXS(XS_Crypt__AuthEnc__CCM_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_new)
{
    dVAR; dXSARGS;
    if (items != 7)
       croak_xs_usage(cv,  "Class, cipher_name, key, nonce, adata, tag_len, pt_len");
    {
	Crypt__AuthEnc__CCM	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
	SV *	nonce = ST(3)
;
	SV *	adata = ST(4)
;
	int	tag_len = (int)SvIV(ST(5))
;
	int	pt_len = (int)SvIV(ST(6))
;
#line 8 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        unsigned char *k=NULL;
        STRLEN k_len=0;
        unsigned char *n=NULL;
        STRLEN n_len=0;
        unsigned char *h=NULL;
        STRLEN h_len=0;
        int rv, id;

        if (tag_len < 1 || tag_len > MAXBLOCKSIZE) croak("FATAL: invalid tag_len %d", tag_len);
        if (pt_len < 0)    croak("FATAL: invalid pt_len");
        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);
        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        n = (unsigned char *) SvPVbyte(nonce, n_len);
        if (!SvPOK(adata)) croak("FATAL: adata must be string/buffer scalar");
        h = (unsigned char *) SvPVbyte(adata, h_len);

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        Newz(0, RETVAL, 1, ccm_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = ccm_init(RETVAL, id, k, (int)k_len, (int)pt_len, (int)tag_len, (int)h_len); /* XXX-TODO why int? */
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: ccm_init failed: %s", error_to_string(rv));
        }
        rv = ccm_add_nonce(RETVAL, n, (unsigned long)n_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: ccm_add_nonce failed: %s", error_to_string(rv));
        }
        rv = ccm_add_aad(RETVAL, h, (unsigned long)h_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: ccm_add_aad failed: %s", error_to_string(rv));
        }
    }
#line 3190 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::CCM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__CCM	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__CCM,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::AuthEnc::CCM::DESTROY",
			"self")
;
#line 54 "./inc/CryptX_AuthEnc_CCM.xs.inc"
        Safefree(self);
#line 3222 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__CCM	RETVAL;
	Crypt__AuthEnc__CCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::CCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__CCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::CCM::clone",
			"self", "Crypt::AuthEnc::CCM",
			refstr, ST(0)
		);
	}
;
#line 59 "./inc/CryptX_AuthEnc_CCM.xs.inc"
        Newz(0, RETVAL, 1, ccm_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, ccm_state);
#line 3255 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::CCM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_encrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_encrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__CCM	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::CCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__CCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::CCM::encrypt_add",
			"self", "Crypt::AuthEnc::CCM",
			refstr, ST(0)
		);
	}
;
#line 68 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = ccm_process(self, in_data, (unsigned long)in_data_len, out_data, CCM_ENCRYPT);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: ccm_process failed: %s", error_to_string(rv));
          }
        }
    }
#line 3314 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_decrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_decrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__CCM	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::CCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__CCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::CCM::decrypt_add",
			"self", "Crypt::AuthEnc::CCM",
			refstr, ST(0)
		);
	}
;
#line 95 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = ccm_process(self, out_data, (unsigned long)in_data_len, in_data, CCM_DECRYPT);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: ccm_process failed: %s", error_to_string(rv));
          }
        }
    }
#line 3369 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_encrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_encrypt_done)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__CCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::CCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__CCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::CCM::encrypt_done",
			"self", "Crypt::AuthEnc::CCM",
			refstr, ST(0)
		);
	}
;
#line 122 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = MAXBLOCKSIZE;

        rv = ccm_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: ccm_done failed: %s", error_to_string(rv));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 3411 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_decrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_decrypt_done)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__CCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::CCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__CCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::CCM::decrypt_done",
			"self", "Crypt::AuthEnc::CCM",
			refstr, ST(0)
		);
	}
;
#line 135 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = MAXBLOCKSIZE;
        STRLEN expected_tag_len;
        unsigned char *expected_tag;

        rv = ccm_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: ccm_done failed: %s", error_to_string(rv));
        if (items == 1) {
          XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
        }
        else {
          if (!SvPOK(ST(1))) croak("FATAL: expected_tag must be string/buffer scalar");
          expected_tag = (unsigned char *) SvPVbyte(ST(1), expected_tag_len);
          if (expected_tag_len!=tag_len) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else if (memNE(expected_tag, tag, tag_len)) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else {
            XPUSHs(sv_2mortal(newSViv(1))); /* true */
          }
        }
    }
#line 3469 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_ccm_encrypt_authenticate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_ccm_encrypt_authenticate)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, tag_len, plaintext");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	unsigned long	tag_len = (unsigned long)SvUV(ST(4))
;
	SV *	plaintext = ST(5)
;
#line 165 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, pt_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *pt = NULL;
        int rv, id;
        unsigned char tag[MAXBLOCKSIZE];
        SV *output;

        if (SvPOK(key))       k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))     n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(plaintext)) pt = (unsigned char *) SvPVbyte(plaintext, pt_len);
        if (SvPOK(header))    h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, pt_len > 0 ? pt_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, pt_len);
        if(tag_len < 4 || tag_len > 16) tag_len = 16;

        rv = ccm_memory(id, k, (unsigned long)k_len, NULL, n, (unsigned long)n_len, h, (unsigned long)h_len,
                        pt, (unsigned long)pt_len, (unsigned char *)SvPVX(output), tag, &tag_len, CCM_ENCRYPT);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          croak("FATAL: ccm_memory failed: %s", error_to_string(rv));
        }
        XPUSHs(sv_2mortal(output));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 3527 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__CCM_ccm_decrypt_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__CCM_ccm_decrypt_verify)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, ciphertext, tagsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	SV *	ciphertext = ST(4)
;
	SV *	tagsv = ST(5)
;
#line 198 "./inc/CryptX_AuthEnc_CCM.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, ct_len = 0, t_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *ct = NULL, *t = NULL;
        int rv, id;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len;
        SV *output;

        if (SvPOK(key))        k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))      n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(ciphertext)) ct = (unsigned char *) SvPVbyte(ciphertext, ct_len);
        if (SvPOK(tagsv))      t  = (unsigned char *) SvPVbyte(tagsv, t_len);
        if (SvPOK(header))     h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, ct_len > 0 ? ct_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, ct_len);
        tag_len = (unsigned long)t_len;
        Copy(t, tag, t_len, unsigned char);

        rv = ccm_memory(id, k, (unsigned long)k_len, NULL, n, (unsigned long)n_len, h, (unsigned long)h_len,
                        (unsigned char *)SvPVX(output), (unsigned long)ct_len, ct, tag, &tag_len, CCM_DECRYPT);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          XPUSHs(sv_2mortal(newSVpvn(NULL,0))); /* undef */
        }
        else {
          XPUSHs(sv_2mortal(output));
        }
    }
#line 3589 "CryptX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'inc/CryptX_AuthEnc_OCB.xs.inc' from 'inc/CryptX_AuthEnc_CCM.xs.inc' */


XS_EUPXS(XS_Crypt__AuthEnc__OCB_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_new)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "Class, cipher_name, key, nonce, taglen");
    {
	Crypt__AuthEnc__OCB	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
	SV *	nonce = ST(3)
;
	unsigned long	taglen = (unsigned long)SvUV(ST(4))
;
#line 8 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        unsigned char *n=NULL;
        STRLEN n_len=0;
        int rv, id;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);
        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        n = (unsigned char *) SvPVbyte(nonce, n_len);

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        Newz(0, RETVAL, 1, ocb3_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = ocb3_init(RETVAL, id, k, (unsigned long)k_len, n, (unsigned long)n_len, taglen);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: ocb setup failed: %s", error_to_string(rv));
        }
    }
#line 3640 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::OCB", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__OCB	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::AuthEnc::OCB::DESTROY",
			"self")
;
#line 38 "./inc/CryptX_AuthEnc_OCB.xs.inc"
        Safefree(self);
#line 3672 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__OCB	RETVAL;
	Crypt__AuthEnc__OCB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::clone",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 43 "./inc/CryptX_AuthEnc_OCB.xs.inc"
        Newz(0, RETVAL, 1, ocb3_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, ocb3_state);
#line 3705 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::OCB", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_adata_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_adata_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__OCB	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::adata_add",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 52 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);

        if (in_data_len>0) {
          rv = ocb3_add_aad(self, in_data, (unsigned long)in_data_len);
          if (rv != CRYPT_OK) croak("FATAL: ocb3_add_aad failed: %s", error_to_string(rv));
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 3757 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_encrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_encrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__OCB	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::encrypt_add",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 69 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          if (in_data_len % 16) {
            croak ("FATAL: sizeof(data) should be multiple of 16");
          }
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = ocb3_encrypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: ocb3_encrypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 3814 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_encrypt_last); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_encrypt_last)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__OCB	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::encrypt_last",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 99 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          rv = ocb3_encrypt_last(self, in_data, 0, NULL);
          if (rv != CRYPT_OK) {
            croak("FATAL: ocb3_encrypt_last failed: %s", error_to_string(rv));
          }
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = ocb3_encrypt_last(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: ocb3_encrypt_last failed: %s", error_to_string(rv));
          }
        }
    }
#line 3873 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_decrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_decrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__OCB	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::decrypt_add",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 130 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          if (in_data_len % 16) {
            croak ("FATAL: sizeof(data) should be multiple of 16");
          }
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = ocb3_decrypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: ocb3_decrypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 3931 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_decrypt_last); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_decrypt_last)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__OCB	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::decrypt_last",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 160 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          rv = ocb3_decrypt_last(self, in_data, 0, NULL);
          if (rv != CRYPT_OK) {
            croak("FATAL: ocb3_encrypt_last failed: %s", error_to_string(rv));
          }
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = ocb3_decrypt_last(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: ocb3_encrypt_last failed: %s", error_to_string(rv));
          }
        }
    }
#line 3990 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_encrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_encrypt_done)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__OCB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::encrypt_done",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 191 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);

        rv = ocb3_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: ocb3_done_encrypt failed: %s", error_to_string(rv));

        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 4033 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_decrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_decrypt_done)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__OCB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::OCB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__OCB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::OCB::decrypt_done",
			"self", "Crypt::AuthEnc::OCB",
			refstr, ST(0)
		);
	}
;
#line 205 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        STRLEN expected_tag_len;
        unsigned char *expected_tag;

        rv = ocb3_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: ocb3_done_decrypt failed: %s", error_to_string(rv));
        if (items == 1) {
          XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
        }
        else {
          if (!SvPOK(ST(1))) croak("FATAL: expected_tag must be string/buffer scalar");
          expected_tag = (unsigned char *) SvPVbyte(ST(1), expected_tag_len);
          if (expected_tag_len!=tag_len) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else if (memNE(expected_tag, tag, tag_len)) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else {
            XPUSHs(sv_2mortal(newSViv(1))); /* true */
          }
        }
    }
#line 4091 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_ocb_encrypt_authenticate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_ocb_encrypt_authenticate)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, tag_len, plaintext");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	unsigned long	tag_len = (unsigned long)SvUV(ST(4))
;
	SV *	plaintext = ST(5)
;
#line 235 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, pt_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *pt = NULL;
        int rv, id;
        unsigned char tag[MAXBLOCKSIZE];
        SV *output;

        if (SvPOK(key))       k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))     n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(plaintext)) pt = (unsigned char *) SvPVbyte(plaintext, pt_len);
        if (SvPOK(header))    h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, pt_len > 0 ? pt_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, pt_len);
        if(tag_len < 4 || tag_len > 16) tag_len = 16;

        rv = ocb3_encrypt_authenticate_memory(id, k, (unsigned long)k_len, n, (unsigned long)n_len,
                                              h, (unsigned long)h_len, pt, (unsigned long)pt_len,
                                              (unsigned char *)SvPVX(output), tag, &tag_len);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          croak("FATAL: ccm_memory failed: %s", error_to_string(rv));
        }
        XPUSHs(sv_2mortal(output));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 4150 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__OCB_ocb_decrypt_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__OCB_ocb_decrypt_verify)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, ciphertext, tagsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	SV *	ciphertext = ST(4)
;
	SV *	tagsv = ST(5)
;
#line 269 "./inc/CryptX_AuthEnc_OCB.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, ct_len = 0, t_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *ct = NULL, *t = NULL;
        int rv, id, stat = 0;
        SV *output;

        if (SvPOK(key))        k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))      n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(ciphertext)) ct = (unsigned char *) SvPVbyte(ciphertext, ct_len);
        if (SvPOK(tagsv))      t  = (unsigned char *) SvPVbyte(tagsv, t_len);
        if (SvPOK(header))     h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, ct_len > 0 ? ct_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, ct_len);

        rv = ocb3_decrypt_verify_memory(id, k, (unsigned long)k_len, n, (unsigned long)n_len,
                                        h, (unsigned long)h_len, ct, (unsigned long)ct_len,
                                        (unsigned char *)SvPVX(output), t, (unsigned long)t_len, &stat);

        if (rv != CRYPT_OK || stat != 1) {
          SvREFCNT_dec(output);
          XPUSHs(sv_2mortal(newSVpvn(NULL,0))); /* undef */
        }
        else {
          XPUSHs(sv_2mortal(output));
        }
    }
#line 4209 "CryptX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'inc/CryptX_AuthEnc_GCM.xs.inc' from 'inc/CryptX_AuthEnc_OCB.xs.inc' */


XS_EUPXS(XS_Crypt__AuthEnc__GCM_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_new)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "Class, cipher_name, key, nonce= NULL");
    {
	Crypt__AuthEnc__GCM	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
	SV *	nonce;

	if (items < 4)
	    nonce = NULL;
	else {
	    nonce = ST(3)
;
	}
#line 8 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        STRLEN k_len = 0, iv_len = 0;
        unsigned char *k = NULL, *iv = NULL;
        int id, rv;

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);
        if (nonce) {
          if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
          iv = (unsigned char *)SvPVbyte(nonce, iv_len);
        }

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        Newz(0, RETVAL, 1, gcm_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = gcm_init(RETVAL, id, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: gcm_init failed: %s", error_to_string(rv));
        }

        if (iv && iv_len > 0) {
          rv = gcm_add_iv(RETVAL, iv, (unsigned long)iv_len);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: gcm_add_iv failed: %s", error_to_string(rv));
          }
        }
    }
#line 4272 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::GCM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__GCM	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::AuthEnc::GCM::DESTROY",
			"self")
;
#line 46 "./inc/CryptX_AuthEnc_GCM.xs.inc"
        Safefree(self);
#line 4304 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__GCM	RETVAL;
	Crypt__AuthEnc__GCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::clone",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_AuthEnc_GCM.xs.inc"
        Newz(0, RETVAL, 1, gcm_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, gcm_state);
#line 4337 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::GCM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__GCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::reset",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 60 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        rv = gcm_reset(self);
        if (rv != CRYPT_OK) croak("FATAL: gcm_reset failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 4380 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_encrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_encrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__GCM	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::encrypt_add",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 70 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else
        {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = gcm_process(self, in_data, (unsigned long)in_data_len, out_data, GCM_ENCRYPT);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: encrypt_add/gcm_process failed: %s", error_to_string(rv));
          }
        }
    }
#line 4435 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_iv_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_iv_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__GCM	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::iv_add",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 98 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        rv = gcm_add_iv(self, in_data, (unsigned long)in_data_len);
        if (rv != CRYPT_OK) croak("FATAL: gcm_add_iv failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 4480 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_adata_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_adata_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__GCM	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::adata_add",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 112 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        rv = gcm_add_aad(self, in_data, (unsigned long)in_data_len);
        if (rv != CRYPT_OK) croak("FATAL: gcm_add_aad failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 4524 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_decrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_decrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__GCM	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::decrypt_add",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 126 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = gcm_process(self, out_data, (unsigned long)in_data_len, in_data, GCM_DECRYPT);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: encrypt_add/gcm_process failed: %s", error_to_string(rv));
          }
        }
    }
#line 4578 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_encrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_encrypt_done)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__GCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::encrypt_done",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 154 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);

        rv = gcm_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: gcm_done failed: %s", error_to_string(rv));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 4620 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_decrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_decrypt_done)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__GCM	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::GCM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__GCM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::GCM::decrypt_done",
			"self", "Crypt::AuthEnc::GCM",
			refstr, ST(0)
		);
	}
;
#line 167 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        STRLEN expected_tag_len;
        unsigned char *expected_tag;

        rv = gcm_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: gcm_done failed: %s", error_to_string(rv));
        if (items == 1) {
          XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
        }
        else {
          if (!SvPOK(ST(1))) croak("FATAL: expected_tag must be string/buffer scalar");
          expected_tag = (unsigned char *) SvPVbyte(ST(1), expected_tag_len);
          if (expected_tag_len!=tag_len) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else if (memNE(expected_tag, tag, tag_len)) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else {
            XPUSHs(sv_2mortal(newSViv(1))); /* true */
          }
        }
    }
#line 4678 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_gcm_encrypt_authenticate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_gcm_encrypt_authenticate)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header= NULL, plaintext");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header;
	SV *	plaintext = ST(4)
;

	if (items < 4)
	    header = NULL;
	else {
	    header = ST(3)
;
	}
#line 197 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, pt_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *pt = NULL;
        int rv, id;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        SV *output;

        if (SvPOK(key))       k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))     n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(plaintext)) pt = (unsigned char *) SvPVbyte(plaintext, pt_len);
        if (SvPOK(header))    h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, pt_len > 0 ? pt_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, pt_len);

        rv = gcm_memory(id, k, (unsigned long)k_len, n, (unsigned long)n_len, h, (unsigned long)h_len,
                        pt, (unsigned long)pt_len, (unsigned char *)SvPVX(output), tag, &tag_len, GCM_ENCRYPT);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          croak("FATAL: ccm_memory failed: %s", error_to_string(rv));
        }
        XPUSHs(sv_2mortal(output));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 4740 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__GCM_gcm_decrypt_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__GCM_gcm_decrypt_verify)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, ciphertext, tagsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	SV *	ciphertext = ST(4)
;
	SV *	tagsv = ST(5)
;
#line 230 "./inc/CryptX_AuthEnc_GCM.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, ct_len = 0, t_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *ct = NULL, *t = NULL;
        int rv, id;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len;
        SV *output;

        if (SvPOK(key))        k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))      n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(ciphertext)) ct = (unsigned char *) SvPVbyte(ciphertext, ct_len);
        if (SvPOK(tagsv))      t  = (unsigned char *) SvPVbyte(tagsv, t_len);
        if (SvPOK(header))     h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, ct_len > 0 ? ct_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, ct_len);
        tag_len = (unsigned long)t_len;
        Copy(t, tag, t_len, unsigned char);

        rv = gcm_memory(id, k, (unsigned long)k_len, n, (unsigned long)n_len, h, (unsigned long)h_len,
                        (unsigned char *)SvPVX(output), (unsigned long)ct_len, ct, tag, &tag_len, GCM_DECRYPT);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          XPUSHs(sv_2mortal(newSVpvn(NULL,0))); /* undef */
        }
        else {
          XPUSHs(sv_2mortal(output));
        }
    }
#line 4802 "CryptX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'inc/CryptX_AuthEnc_EAX.xs.inc' from 'inc/CryptX_AuthEnc_GCM.xs.inc' */


XS_EUPXS(XS_Crypt__AuthEnc__EAX_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_new)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "Class, cipher_name, key, nonce, adata=&PL_sv_undef");
    {
	Crypt__AuthEnc__EAX	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
	SV *	nonce = ST(3)
;
	SV *	adata;

	if (items < 5)
	    adata = &PL_sv_undef;
	else {
	    adata = ST(4)
;
	}
#line 8 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        unsigned char *n=NULL;
        STRLEN n_len=0;
        unsigned char *h=NULL;
        STRLEN h_len=0;
        int rv, id;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);
        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        n = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvOK(adata)) { /* adata is optional param */
          if (!SvPOK(adata)) croak("FATAL: adata must be string/buffer scalar");
          h = (unsigned char *) SvPVbyte(adata, h_len);
        }

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        Newz(0, RETVAL, 1, eax_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = eax_init(RETVAL, id, k, (unsigned long)k_len, n, (unsigned long)n_len, h, (unsigned long)h_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: eax setup failed: %s", error_to_string(rv));
        }
    }
#line 4865 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::EAX", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__EAX	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::AuthEnc::EAX::DESTROY",
			"self")
;
#line 44 "./inc/CryptX_AuthEnc_EAX.xs.inc"
        Safefree(self);
#line 4897 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__AuthEnc__EAX	RETVAL;
	Crypt__AuthEnc__EAX	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::EAX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::EAX::clone",
			"self", "Crypt::AuthEnc::EAX",
			refstr, ST(0)
		);
	}
;
#line 49 "./inc/CryptX_AuthEnc_EAX.xs.inc"
        Newz(0, RETVAL, 1, eax_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, eax_state);
#line 4930 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::AuthEnc::EAX", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_encrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_encrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__EAX	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::EAX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::EAX::encrypt_add",
			"self", "Crypt::AuthEnc::EAX",
			refstr, ST(0)
		);
	}
;
#line 58 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = eax_encrypt(self, in_data, out_data, (unsigned long)in_data_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: eax_encrypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 4989 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_decrypt_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_decrypt_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__AuthEnc__EAX	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::EAX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::EAX::decrypt_add",
			"self", "Crypt::AuthEnc::EAX",
			refstr, ST(0)
		);
	}
;
#line 85 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = eax_decrypt(self, in_data, out_data, (unsigned long)in_data_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: eax_decrypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 5044 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_encrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_encrypt_done)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__EAX	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::EAX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::EAX::encrypt_done",
			"self", "Crypt::AuthEnc::EAX",
			refstr, ST(0)
		);
	}
;
#line 112 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);

        rv = eax_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: eax_done failed: %s", error_to_string(rv));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 5086 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_decrypt_done); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_decrypt_done)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__EAX	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::EAX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::EAX::decrypt_done",
			"self", "Crypt::AuthEnc::EAX",
			refstr, ST(0)
		);
	}
;
#line 125 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        int rv;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        STRLEN expected_tag_len;
        unsigned char *expected_tag;

        rv = eax_done(self, tag, &tag_len);
        if (rv != CRYPT_OK) croak("FATAL: eax_done failed: %s", error_to_string(rv));
        if (items == 1) {
          XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
        }
        else {
          if (!SvPOK(ST(1))) croak("FATAL: expected_tag must be string/buffer scalar");
          expected_tag = (unsigned char *) SvPVbyte(ST(1), expected_tag_len);
          if (expected_tag_len!=tag_len) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else if (memNE(expected_tag, tag, tag_len)) {
            XPUSHs(sv_2mortal(newSViv(0))); /* false */
          }
          else {
            XPUSHs(sv_2mortal(newSViv(1))); /* true */
          }
        }
    }
#line 5144 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_adata_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_adata_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, adata");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__AuthEnc__EAX	self;
	SV *	adata = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::AuthEnc::EAX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__AuthEnc__EAX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::AuthEnc::EAX::adata_add",
			"self", "Crypt::AuthEnc::EAX",
			refstr, ST(0)
		);
	}
;
#line 155 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        STRLEN h_len;
        int rv;
        unsigned char *h;
        h = (unsigned char *)SvPVbyte(adata, h_len);
        rv = eax_addheader(self, h, (unsigned long)h_len);
        if (rv != CRYPT_OK) croak("FATAL: eax_addheader failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 5187 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_eax_encrypt_authenticate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_eax_encrypt_authenticate)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, plaintext");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	SV *	plaintext = ST(4)
;
#line 168 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, pt_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *pt = NULL;
        int rv, id;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len = sizeof(tag);
        SV *output;

        if (SvPOK(key))       k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))     n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(plaintext)) pt = (unsigned char *) SvPVbyte(plaintext, pt_len);
        if (SvPOK(header))    h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, pt_len > 0 ? pt_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, pt_len);

        rv = eax_encrypt_authenticate_memory(id, k, (unsigned long)k_len, n, (unsigned long)n_len,
                                             h, (unsigned long)h_len, pt, (unsigned long)pt_len,
                                             (unsigned char *)SvPVX(output), tag, &tag_len);

        if (rv != CRYPT_OK) {
          SvREFCNT_dec(output);
          croak("FATAL: ccm_memory failed: %s", error_to_string(rv));
        }
        XPUSHs(sv_2mortal(output));
        XPUSHs(sv_2mortal(newSVpvn((char*)tag, tag_len)));
    }
#line 5244 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__AuthEnc__EAX_eax_decrypt_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__AuthEnc__EAX_eax_decrypt_verify)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cipher_name, key, nonce, header, ciphertext, tagsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	SV *	header = ST(3)
;
	SV *	ciphertext = ST(4)
;
	SV *	tagsv = ST(5)
;
#line 202 "./inc/CryptX_AuthEnc_EAX.xs.inc"
    {
        STRLEN k_len = 0, n_len = 0, h_len = 0, ct_len = 0, t_len = 0;
        unsigned char *k = NULL, *n = NULL, *h = NULL, *ct = NULL, *t = NULL;
        int rv, id, stat = 0;
        unsigned char tag[MAXBLOCKSIZE];
        unsigned long tag_len;
        SV *output;

        if (SvPOK(key))        k  = (unsigned char *) SvPVbyte(key, k_len);
        if (SvPOK(nonce))      n  = (unsigned char *) SvPVbyte(nonce, n_len);
        if (SvPOK(ciphertext)) ct = (unsigned char *) SvPVbyte(ciphertext, ct_len);
        if (SvPOK(tagsv))      t  = (unsigned char *) SvPVbyte(tagsv, t_len);
        if (SvPOK(header))     h  = (unsigned char *) SvPVbyte(header, h_len);

        id = _find_cipher(cipher_name);
        if(id==-1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        output = NEWSV(0, ct_len > 0 ? ct_len : 1); /* avoid zero! */
        SvPOK_only(output);
        SvCUR_set(output, ct_len);
        tag_len = (unsigned long)t_len;
        Copy(t, tag, t_len, unsigned char);

        rv = eax_decrypt_verify_memory(id, k, (unsigned long)k_len, n, (unsigned long)n_len, h, (unsigned long)h_len,
                                       ct, (unsigned long)ct_len, (unsigned char *)SvPVX(output), tag, tag_len, &stat);

        if (rv != CRYPT_OK || stat != 1) {
          SvREFCNT_dec(output);
          XPUSHs(sv_2mortal(newSVpvn(NULL,0))); /* undef */
        }
        else {
          XPUSHs(sv_2mortal(output));
        }
    }
#line 5306 "CryptX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_AuthEnc_EAX.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Stream_ChaCha.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_Stream_Salsa20.xs.inc' from 'inc/CryptX_Stream_ChaCha.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Stream_RC4.xs.inc' from 'inc/CryptX_Stream_Salsa20.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Stream_Sober128.xs.inc' from 'inc/CryptX_Stream_RC4.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Stream_Sosemanuk.xs.inc' from 'inc/CryptX_Stream_Sober128.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Stream_Rabbit.xs.inc' from 'inc/CryptX_Stream_Sosemanuk.xs.inc' */


XS_EUPXS(XS_Crypt__Stream__Rabbit_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Rabbit_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "Class, key, nonce=&PL_sv_undef");
    {
	Crypt__Stream__Rabbit	RETVAL;
	SV *	key = ST(1)
;
	SV *	nonce;

	if (items < 3)
	    nonce = &PL_sv_undef;
	else {
	    nonce = ST(2)
;
	}
#line 8 "./inc/CryptX_Stream_Rabbit.xs.inc"
    {
        int rv;
        STRLEN iv_len=0, k_len=0;
        unsigned char *iv=NULL, *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k  = (unsigned char *)SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, rabbit_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = rabbit_setup(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: rabbit_setup failed: %s", error_to_string(rv));
        }

        if (SvOK(nonce)) {
          if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
          iv = (unsigned char *)SvPVbyte(nonce, iv_len);
          rv = rabbit_setiv(RETVAL, iv, (unsigned long)iv_len);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: rabbit_setiv failed: %s", error_to_string(rv));
          }
        }

    }
#line 5381 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Rabbit", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Rabbit_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Rabbit_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Rabbit	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Rabbit,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Stream::Rabbit::DESTROY",
			"self")
;
#line 42 "./inc/CryptX_Stream_Rabbit.xs.inc"
        rabbit_done(self);
        Safefree(self);
#line 5414 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Stream__Rabbit_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Rabbit_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Rabbit	RETVAL;
	Crypt__Stream__Rabbit	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Rabbit")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Rabbit,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Rabbit::clone",
			"self", "Crypt::Stream::Rabbit",
			refstr, ST(0)
		);
	}
;
#line 48 "./inc/CryptX_Stream_Rabbit.xs.inc"
        Newz(0, RETVAL, 1, rabbit_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, rabbit_state);
#line 5447 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Rabbit", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Rabbit_keystream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Rabbit_keystream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Stream__Rabbit	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Rabbit")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Rabbit,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Rabbit::keystream",
			"self", "Crypt::Stream::Rabbit",
			refstr, ST(0)
		);
	}
;
#line 57 "./inc/CryptX_Stream_Rabbit.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = rabbit_keystream(self, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: rabbit_keystream failed: %s", error_to_string(rv));
          }
        }
    }
#line 5504 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Rabbit_crypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Rabbit_crypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Stream__Rabbit	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Rabbit")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Rabbit,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Rabbit::crypt",
			"self", "Crypt::Stream::Rabbit",
			refstr, ST(0)
		);
	}
;
#line 82 "./inc/CryptX_Stream_Rabbit.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = rabbit_crypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: rabbit_crypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 5559 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Stream_Sosemanuk.xs.inc' from 'inc/CryptX_Stream_Rabbit.xs.inc' */


XS_EUPXS(XS_Crypt__Stream__Sosemanuk_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sosemanuk_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "Class, key, nonce=&PL_sv_undef");
    {
	Crypt__Stream__Sosemanuk	RETVAL;
	SV *	key = ST(1)
;
	SV *	nonce;

	if (items < 3)
	    nonce = &PL_sv_undef;
	else {
	    nonce = ST(2)
;
	}
#line 8 "./inc/CryptX_Stream_Sosemanuk.xs.inc"
    {
        int rv;
        STRLEN iv_len=0, k_len=0;
        unsigned char *iv=NULL, *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k  = (unsigned char *)SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, sosemanuk_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = sosemanuk_setup(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: sosemanuk_setup failed: %s", error_to_string(rv));
        }

        if (SvOK(nonce)) {
          if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
          iv = (unsigned char *)SvPVbyte(nonce, iv_len);
          rv = sosemanuk_setiv(RETVAL, iv, (unsigned long)iv_len);
        }
        else {
          rv = sosemanuk_setiv(RETVAL, NULL, 0);
        }
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: sosemanuk_setiv failed: %s", error_to_string(rv));
        }

    }
#line 5620 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Sosemanuk", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Sosemanuk_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sosemanuk_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Sosemanuk	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sosemanuk,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Stream::Sosemanuk::DESTROY",
			"self")
;
#line 45 "./inc/CryptX_Stream_Sosemanuk.xs.inc"
        sosemanuk_done(self);
        Safefree(self);
#line 5653 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Stream__Sosemanuk_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sosemanuk_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Sosemanuk	RETVAL;
	Crypt__Stream__Sosemanuk	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Sosemanuk")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sosemanuk,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Sosemanuk::clone",
			"self", "Crypt::Stream::Sosemanuk",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Stream_Sosemanuk.xs.inc"
        Newz(0, RETVAL, 1, sosemanuk_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, sosemanuk_state);
#line 5686 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Sosemanuk", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Sosemanuk_keystream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sosemanuk_keystream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Stream__Sosemanuk	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Sosemanuk")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sosemanuk,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Sosemanuk::keystream",
			"self", "Crypt::Stream::Sosemanuk",
			refstr, ST(0)
		);
	}
;
#line 60 "./inc/CryptX_Stream_Sosemanuk.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = sosemanuk_keystream(self, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: sosemanuk_keystream failed: %s", error_to_string(rv));
          }
        }
    }
#line 5743 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Sosemanuk_crypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sosemanuk_crypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Stream__Sosemanuk	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Sosemanuk")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sosemanuk,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Sosemanuk::crypt",
			"self", "Crypt::Stream::Sosemanuk",
			refstr, ST(0)
		);
	}
;
#line 85 "./inc/CryptX_Stream_Sosemanuk.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = sosemanuk_crypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: sosemanuk_crypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 5798 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Stream_Sober128.xs.inc' from 'inc/CryptX_Stream_Sosemanuk.xs.inc' */


XS_EUPXS(XS_Crypt__Stream__Sober128_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sober128_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, key, nonce");
    {
	Crypt__Stream__Sober128	RETVAL;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
#line 8 "./inc/CryptX_Stream_Sober128.xs.inc"
    {
        int rv;
        STRLEN iv_len=0, k_len=0;
        unsigned char *iv=NULL, *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        k  = (unsigned char *) SvPVbyte(key, k_len);
        iv = (unsigned char *) SvPVbyte(nonce, iv_len);

        Newz(0, RETVAL, 1, sober128_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = sober128_stream_setup(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: sober128_stream_setup failed: %s", error_to_string(rv));
        }

        rv = sober128_stream_setiv(RETVAL, iv, (unsigned long)iv_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: sober128_stream_setiv failed: %s", error_to_string(rv));
        }
    }
#line 5847 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Sober128", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Sober128_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sober128_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Sober128	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sober128,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Stream::Sober128::DESTROY",
			"self")
;
#line 39 "./inc/CryptX_Stream_Sober128.xs.inc"
        sober128_stream_done(self);
        Safefree(self);
#line 5880 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Stream__Sober128_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sober128_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Sober128	RETVAL;
	Crypt__Stream__Sober128	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Sober128")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sober128,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Sober128::clone",
			"self", "Crypt::Stream::Sober128",
			refstr, ST(0)
		);
	}
;
#line 45 "./inc/CryptX_Stream_Sober128.xs.inc"
        Newz(0, RETVAL, 1, sober128_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, sober128_state);
#line 5913 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Sober128", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Sober128_keystream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sober128_keystream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Stream__Sober128	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Sober128")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sober128,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Sober128::keystream",
			"self", "Crypt::Stream::Sober128",
			refstr, ST(0)
		);
	}
;
#line 54 "./inc/CryptX_Stream_Sober128.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = sober128_stream_keystream(self, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: sober128_stream_keystream failed: %s", error_to_string(rv));
          }
        }
    }
#line 5970 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Sober128_crypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Sober128_crypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Stream__Sober128	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Sober128")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Sober128,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Sober128::crypt",
			"self", "Crypt::Stream::Sober128",
			refstr, ST(0)
		);
	}
;
#line 79 "./inc/CryptX_Stream_Sober128.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = sober128_stream_crypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: sober128_stream_crypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 6025 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Stream_RC4.xs.inc' from 'inc/CryptX_Stream_Sober128.xs.inc' */


XS_EUPXS(XS_Crypt__Stream__RC4_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__RC4_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, key");
    {
	Crypt__Stream__RC4	RETVAL;
	SV *	key = ST(1)
;
#line 8 "./inc/CryptX_Stream_RC4.xs.inc"
    {
        int rv;
        STRLEN k_len=0;
        unsigned char *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k  = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, rc4_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = rc4_stream_setup(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: rc4_stream_setup failed: %s", error_to_string(rv));
        }
    }
#line 6064 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::RC4", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__RC4_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__RC4_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__RC4	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__RC4,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Stream::RC4::DESTROY",
			"self")
;
#line 31 "./inc/CryptX_Stream_RC4.xs.inc"
        rc4_stream_done(self);
        Safefree(self);
#line 6097 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Stream__RC4_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__RC4_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__RC4	RETVAL;
	Crypt__Stream__RC4	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::RC4")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__RC4,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::RC4::clone",
			"self", "Crypt::Stream::RC4",
			refstr, ST(0)
		);
	}
;
#line 37 "./inc/CryptX_Stream_RC4.xs.inc"
        Newz(0, RETVAL, 1, rc4_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, rc4_state);
#line 6130 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::RC4", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__RC4_keystream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__RC4_keystream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Stream__RC4	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::RC4")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__RC4,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::RC4::keystream",
			"self", "Crypt::Stream::RC4",
			refstr, ST(0)
		);
	}
;
#line 46 "./inc/CryptX_Stream_RC4.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = rc4_stream_keystream(self, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: rc4_stream_keystream failed: %s", error_to_string(rv));
          }
        }
    }
#line 6187 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__RC4_crypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__RC4_crypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Stream__RC4	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::RC4")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__RC4,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::RC4::crypt",
			"self", "Crypt::Stream::RC4",
			refstr, ST(0)
		);
	}
;
#line 71 "./inc/CryptX_Stream_RC4.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = rc4_stream_crypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: rc4_stream_crypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 6242 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Stream_Salsa20.xs.inc' from 'inc/CryptX_Stream_RC4.xs.inc' */


XS_EUPXS(XS_Crypt__Stream__Salsa20_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Salsa20_new)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "Class, key, nonce, counter= 0, rounds= 20");
    {
	Crypt__Stream__Salsa20	RETVAL;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	UV	counter;
	int	rounds;

	if (items < 4)
	    counter = 0;
	else {
	    counter = (UV)SvUV(ST(3))
;
	}

	if (items < 5)
	    rounds = 20;
	else {
	    rounds = (int)SvIV(ST(4))
;
	}
#line 8 "./inc/CryptX_Stream_Salsa20.xs.inc"
    {
        int rv;
        STRLEN iv_len=0, k_len=0;
        unsigned char *iv=NULL, *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        k  = (unsigned char *)SvPVbyte(key, k_len);
        iv = (unsigned char *)SvPVbyte(nonce, iv_len);

        Newz(0, RETVAL, 1, salsa20_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = salsa20_setup(RETVAL, k, (unsigned long)k_len, rounds);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: salsa20_setup failed: %s", error_to_string(rv));
        }

        rv = salsa20_ivctr64(RETVAL, iv, (unsigned long)iv_len, (ulong64)counter);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: salsa20_ivctr64 failed: %s", error_to_string(rv));
        }
    }
#line 6307 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Salsa20", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Salsa20_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Salsa20_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Salsa20	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Salsa20,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Stream::Salsa20::DESTROY",
			"self")
;
#line 39 "./inc/CryptX_Stream_Salsa20.xs.inc"
        salsa20_done(self);
        Safefree(self);
#line 6340 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Stream__Salsa20_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Salsa20_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__Salsa20	RETVAL;
	Crypt__Stream__Salsa20	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Salsa20")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Salsa20,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Salsa20::clone",
			"self", "Crypt::Stream::Salsa20",
			refstr, ST(0)
		);
	}
;
#line 45 "./inc/CryptX_Stream_Salsa20.xs.inc"
        Newz(0, RETVAL, 1, salsa20_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, salsa20_state);
#line 6373 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::Salsa20", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Salsa20_keystream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Salsa20_keystream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Stream__Salsa20	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Salsa20")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Salsa20,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Salsa20::keystream",
			"self", "Crypt::Stream::Salsa20",
			refstr, ST(0)
		);
	}
;
#line 54 "./inc/CryptX_Stream_Salsa20.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = salsa20_keystream(self, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: salsa20_keystream failed: %s", error_to_string(rv));
          }
        }
    }
#line 6430 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__Salsa20_crypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__Salsa20_crypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Stream__Salsa20	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::Salsa20")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__Salsa20,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::Salsa20::crypt",
			"self", "Crypt::Stream::Salsa20",
			refstr, ST(0)
		);
	}
;
#line 79 "./inc/CryptX_Stream_Salsa20.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = salsa20_crypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: salsa20_crypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 6485 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Stream_ChaCha.xs.inc' from 'inc/CryptX_Stream_Salsa20.xs.inc' */


XS_EUPXS(XS_Crypt__Stream__ChaCha_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__ChaCha_new)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "Class, key, nonce, counter= 0, rounds= 20");
    {
	Crypt__Stream__ChaCha	RETVAL;
	SV *	key = ST(1)
;
	SV *	nonce = ST(2)
;
	UV	counter;
	int	rounds;

	if (items < 4)
	    counter = 0;
	else {
	    counter = (UV)SvUV(ST(3))
;
	}

	if (items < 5)
	    rounds = 20;
	else {
	    rounds = (int)SvIV(ST(4))
;
	}
#line 8 "./inc/CryptX_Stream_ChaCha.xs.inc"
    {
        int rv;
        STRLEN iv_len=0, k_len=0;
        unsigned char *iv=NULL, *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        if (!SvPOK(nonce)) croak("FATAL: nonce must be string/buffer scalar");
        k  = (unsigned char *) SvPVbyte(key, k_len);
        iv = (unsigned char *) SvPVbyte(nonce, iv_len);

        Newz(0, RETVAL, 1, chacha_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = chacha_setup(RETVAL, k, (unsigned long)k_len, rounds);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: chacha_setup failed: %s", error_to_string(rv));
        }

        if (iv_len == 12) {
          rv = chacha_ivctr32(RETVAL, iv, (unsigned long)iv_len, (ulong32)counter);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: chacha_ivctr32 failed: %s", error_to_string(rv));
          }
        }
        else if (iv_len == 8) {
          rv = chacha_ivctr64(RETVAL, iv, (unsigned long)iv_len, (ulong64)counter);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: chacha_ivctr64 failed: %s", error_to_string(rv));
          }
        }
        else {
          Safefree(RETVAL);
          croak("FATAL: chacha IV length must be 8 or 12 bytes");
        }
    }
#line 6563 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::ChaCha", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__ChaCha_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__ChaCha_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__ChaCha	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__ChaCha,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Stream::ChaCha::DESTROY",
			"self")
;
#line 52 "./inc/CryptX_Stream_ChaCha.xs.inc"
        chacha_done(self);
        Safefree(self);
#line 6596 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Stream__ChaCha_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__ChaCha_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Stream__ChaCha	RETVAL;
	Crypt__Stream__ChaCha	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::ChaCha")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__ChaCha,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::ChaCha::clone",
			"self", "Crypt::Stream::ChaCha",
			refstr, ST(0)
		);
	}
;
#line 58 "./inc/CryptX_Stream_ChaCha.xs.inc"
        Newz(0, RETVAL, 1, chacha_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, chacha_state);
#line 6629 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Stream::ChaCha", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__ChaCha_keystream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__ChaCha_keystream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, out_len");
    {
	SV *	RETVAL;
	Crypt__Stream__ChaCha	self;
	STRLEN	out_len = (STRLEN)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::ChaCha")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__ChaCha,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::ChaCha::keystream",
			"self", "Crypt::Stream::ChaCha",
			refstr, ST(0)
		);
	}
;
#line 67 "./inc/CryptX_Stream_ChaCha.xs.inc"
    {
        int rv;
        unsigned char *out_data;

        if (out_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, out_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, out_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = chacha_keystream(self, out_data, (unsigned long)out_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: chacha_keystream failed: %s", error_to_string(rv));
          }
        }
    }
#line 6686 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Stream__ChaCha_crypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Stream__ChaCha_crypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__Stream__ChaCha	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Stream::ChaCha")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Stream__ChaCha,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Stream::ChaCha::crypt",
			"self", "Crypt::Stream::ChaCha",
			refstr, ST(0)
		);
	}
;
#line 92 "./inc/CryptX_Stream_ChaCha.xs.inc"
    {
        int rv;
        STRLEN in_data_len;
        unsigned char *in_data, *out_data;

        in_data = (unsigned char *)SvPVbyte(data, in_data_len);
        if (in_data_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          RETVAL = NEWSV(0, in_data_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, in_data_len);
          out_data = (unsigned char *)SvPVX(RETVAL);
          rv = chacha_crypt(self, in_data, (unsigned long)in_data_len, out_data);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: chacha_crypt failed: %s", error_to_string(rv));
          }
        }
    }
#line 6741 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_Stream_ChaCha.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_F9.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_Mac_HMAC.xs.inc' from 'inc/CryptX_Mac_F9.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_OMAC.xs.inc' from 'inc/CryptX_Mac_HMAC.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_Pelican.xs.inc' from 'inc/CryptX_Mac_OMAC.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_PMAC.xs.inc' from 'inc/CryptX_Mac_Pelican.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_XCBC.xs.inc' from 'inc/CryptX_Mac_PMAC.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_Poly1305.xs.inc' from 'inc/CryptX_Mac_XCBC.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_BLAKE2s.xs.inc' from 'inc/CryptX_Mac_Poly1305.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mac_BLAKE2b.xs.inc' from 'inc/CryptX_Mac_BLAKE2s.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__BLAKE2b_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2b_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, size, key");
    {
	Crypt__Mac__BLAKE2b	RETVAL;
	unsigned long	size = (unsigned long)SvUV(ST(1))
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_BLAKE2b.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, blake2bmac_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = blake2bmac_init(RETVAL, size, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: blake2b_init failed: %s", error_to_string(rv));
        }
    }
#line 6809 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::BLAKE2b", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2b_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2b_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__BLAKE2b	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2b,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::BLAKE2b::DESTROY",
			"self")
;
#line 33 "./inc/CryptX_Mac_BLAKE2b.xs.inc"
        Safefree(self);
#line 6841 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2b_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2b_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__BLAKE2b	RETVAL;
	Crypt__Mac__BLAKE2b	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::BLAKE2b")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2b,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::BLAKE2b::clone",
			"self", "Crypt::Mac::BLAKE2b",
			refstr, ST(0)
		);
	}
;
#line 38 "./inc/CryptX_Mac_BLAKE2b.xs.inc"
        Newz(0, RETVAL, 1, blake2bmac_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, blake2bmac_state);
#line 6874 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::BLAKE2b", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2b_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2b_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__BLAKE2b	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::BLAKE2b")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2b,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::BLAKE2b::add",
			"self", "Crypt::Mac::BLAKE2b",
			refstr, ST(0)
		);
	}
;
#line 47 "./inc/CryptX_Mac_BLAKE2b.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = blake2bmac_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: blake2b_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 6925 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2b_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2b_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__BLAKE2b	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::BLAKE2b")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2b,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::BLAKE2b",
			refstr, ST(0)
		);
	}
;
#line 69 "./inc/CryptX_Mac_BLAKE2b.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = blake2bmac_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: blake2bmac_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 6986 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2b_blake2b); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2b_blake2b)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "size, key, ...");
    {
	SV *	RETVAL;
	unsigned long	size = (unsigned long)SvUV(ST(0))
;
	SV *	key = ST(1)
;
#line 108 "./inc/CryptX_Mac_BLAKE2b.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        blake2bmac_state st;

        if (size < len) len = size;
        rv = blake2bmac_init(&st, len, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: blake2bmac_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = blake2bmac_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: blake2bmac_process failed: %s", error_to_string(rv));
          }
        }
        rv = blake2bmac_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: blake2bmac_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 7051 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_BLAKE2s.xs.inc' from 'inc/CryptX_Mac_BLAKE2b.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__BLAKE2s_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2s_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, size, key");
    {
	Crypt__Mac__BLAKE2s	RETVAL;
	unsigned long	size = (unsigned long)SvUV(ST(1))
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_BLAKE2s.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, blake2smac_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = blake2smac_init(RETVAL, size, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: blake2s_init failed: %s", error_to_string(rv));
        }
    }
#line 7092 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::BLAKE2s", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2s_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2s_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__BLAKE2s	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2s,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::BLAKE2s::DESTROY",
			"self")
;
#line 33 "./inc/CryptX_Mac_BLAKE2s.xs.inc"
        Safefree(self);
#line 7124 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2s_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2s_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__BLAKE2s	RETVAL;
	Crypt__Mac__BLAKE2s	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::BLAKE2s")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2s,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::BLAKE2s::clone",
			"self", "Crypt::Mac::BLAKE2s",
			refstr, ST(0)
		);
	}
;
#line 38 "./inc/CryptX_Mac_BLAKE2s.xs.inc"
        Newz(0, RETVAL, 1, blake2smac_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, blake2smac_state);
#line 7157 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::BLAKE2s", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2s_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2s_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__BLAKE2s	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::BLAKE2s")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2s,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::BLAKE2s::add",
			"self", "Crypt::Mac::BLAKE2s",
			refstr, ST(0)
		);
	}
;
#line 47 "./inc/CryptX_Mac_BLAKE2s.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = blake2smac_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: blake2s_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 7208 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2s_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2s_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__BLAKE2s	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::BLAKE2s")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__BLAKE2s,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::BLAKE2s",
			refstr, ST(0)
		);
	}
;
#line 69 "./inc/CryptX_Mac_BLAKE2s.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = blake2smac_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: blake2smac_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 7269 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__BLAKE2s_blake2s); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__BLAKE2s_blake2s)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "size, key, ...");
    {
	SV *	RETVAL;
	unsigned long	size = (unsigned long)SvUV(ST(0))
;
	SV *	key = ST(1)
;
#line 108 "./inc/CryptX_Mac_BLAKE2s.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        blake2smac_state st;

        if (size < len) len = size;
        rv = blake2smac_init(&st, len, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: blake2smac_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = blake2smac_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: blake2smac_process failed: %s", error_to_string(rv));
          }
        }
        rv = blake2smac_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: blake2smac_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 7334 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_Poly1305.xs.inc' from 'inc/CryptX_Mac_BLAKE2s.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__Poly1305_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Poly1305_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, key");
    {
	Crypt__Mac__Poly1305	RETVAL;
	SV *	key = ST(1)
;
#line 10 "./inc/CryptX_Mac_Poly1305.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, poly1305_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = poly1305_init(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: poly1305_init failed: %s", error_to_string(rv));
        }
    }
#line 7373 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::Poly1305", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__Poly1305_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Poly1305_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__Poly1305	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Poly1305,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::Poly1305::DESTROY",
			"self")
;
#line 33 "./inc/CryptX_Mac_Poly1305.xs.inc"
        Safefree(self);
#line 7405 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__Poly1305_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Poly1305_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__Poly1305	RETVAL;
	Crypt__Mac__Poly1305	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::Poly1305::clone",
			"self", "Crypt::Mac::Poly1305",
			refstr, ST(0)
		);
	}
;
#line 38 "./inc/CryptX_Mac_Poly1305.xs.inc"
        Newz(0, RETVAL, 1, poly1305_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, poly1305_state);
#line 7438 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::Poly1305", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__Poly1305_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Poly1305_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__Poly1305	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::Poly1305::add",
			"self", "Crypt::Mac::Poly1305",
			refstr, ST(0)
		);
	}
;
#line 47 "./inc/CryptX_Mac_Poly1305.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = poly1305_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: poly1305_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 7489 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__Poly1305_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Poly1305_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__Poly1305	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::Poly1305")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Poly1305,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::Poly1305",
			refstr, ST(0)
		);
	}
;
#line 69 "./inc/CryptX_Mac_Poly1305.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = poly1305_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: poly1305_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 7550 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__Poly1305_poly1305); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Poly1305_poly1305)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "key, ...");
    {
	SV *	RETVAL;
	SV *	key = ST(0)
;
#line 108 "./inc/CryptX_Mac_Poly1305.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        poly1305_state st;

        rv = poly1305_init(&st, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: poly1305_init failed: %s", error_to_string(rv));
        for (i = 1; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = poly1305_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: poly1305_process failed: %s", error_to_string(rv));
          }
        }
        rv = poly1305_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: poly1305_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 7612 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_XCBC.xs.inc' from 'inc/CryptX_Mac_Poly1305.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__XCBC_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__XCBC_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, cipher_name, key");
    {
	Crypt__Mac__XCBC	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_XCBC.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;
        int id;

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, xcbc_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = xcbc_init(RETVAL, id, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: xcbc_init failed: %s", error_to_string(rv));
        }
    }
#line 7657 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::XCBC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__XCBC_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__XCBC_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__XCBC	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__XCBC,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::XCBC::DESTROY",
			"self")
;
#line 37 "./inc/CryptX_Mac_XCBC.xs.inc"
        Safefree(self);
#line 7689 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__XCBC_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__XCBC_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__XCBC	RETVAL;
	Crypt__Mac__XCBC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::XCBC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__XCBC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::XCBC::clone",
			"self", "Crypt::Mac::XCBC",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_Mac_XCBC.xs.inc"
        Newz(0, RETVAL, 1, xcbc_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, xcbc_state);
#line 7722 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::XCBC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__XCBC_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__XCBC_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__XCBC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::XCBC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__XCBC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::XCBC::add",
			"self", "Crypt::Mac::XCBC",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Mac_XCBC.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = xcbc_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: xcbc_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 7773 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__XCBC_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__XCBC_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__XCBC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::XCBC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__XCBC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::XCBC",
			refstr, ST(0)
		);
	}
;
#line 73 "./inc/CryptX_Mac_XCBC.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = xcbc_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: xcbc_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 7834 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__XCBC_xcbc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__XCBC_xcbc)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "cipher_name, key, ...");
    {
	SV *	RETVAL;
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
#line 112 "./inc/CryptX_Mac_XCBC.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        xcbc_state st;

        int id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipher failed for '%s'", cipher_name);
        rv = xcbc_init(&st, id, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: xcbc_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = xcbc_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: xcbc_process failed: %s", error_to_string(rv));
          }
        }
        rv = xcbc_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: xcbc_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 7900 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_PMAC.xs.inc' from 'inc/CryptX_Mac_XCBC.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__PMAC_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__PMAC_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, cipher_name, key");
    {
	Crypt__Mac__PMAC	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_PMAC.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;
        int id;

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, pmac_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = pmac_init(RETVAL, id, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: pmac_init failed: %s", error_to_string(rv));
        }
    }
#line 7945 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::PMAC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__PMAC_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__PMAC_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__PMAC	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__PMAC,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::PMAC::DESTROY",
			"self")
;
#line 37 "./inc/CryptX_Mac_PMAC.xs.inc"
        Safefree(self);
#line 7977 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__PMAC_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__PMAC_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__PMAC	RETVAL;
	Crypt__Mac__PMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::PMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__PMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::PMAC::clone",
			"self", "Crypt::Mac::PMAC",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_Mac_PMAC.xs.inc"
        Newz(0, RETVAL, 1, pmac_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, pmac_state);
#line 8010 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::PMAC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__PMAC_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__PMAC_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__PMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::PMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__PMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::PMAC::add",
			"self", "Crypt::Mac::PMAC",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Mac_PMAC.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = pmac_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: pmac_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 8061 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__PMAC_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__PMAC_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__PMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::PMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__PMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::PMAC",
			refstr, ST(0)
		);
	}
;
#line 73 "./inc/CryptX_Mac_PMAC.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = pmac_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: pmac_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 8122 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__PMAC_pmac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__PMAC_pmac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "cipher_name, key, ...");
    {
	SV *	RETVAL;
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
#line 112 "./inc/CryptX_Mac_PMAC.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        pmac_state st;

        int id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipher failed for '%s'", cipher_name);
        rv = pmac_init(&st, id, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: pmac_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = pmac_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: pmac_process failed: %s", error_to_string(rv));
          }
        }
        rv = pmac_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: pmac_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 8188 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_Pelican.xs.inc' from 'inc/CryptX_Mac_PMAC.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__Pelican_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Pelican_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, key");
    {
	Crypt__Mac__Pelican	RETVAL;
	SV *	key = ST(1)
;
#line 10 "./inc/CryptX_Mac_Pelican.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, pelican_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = pelican_init(RETVAL, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: pelican_init failed: %s", error_to_string(rv));
        }
    }
#line 8227 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::Pelican", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__Pelican_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Pelican_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__Pelican	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Pelican,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::Pelican::DESTROY",
			"self")
;
#line 33 "./inc/CryptX_Mac_Pelican.xs.inc"
        Safefree(self);
#line 8259 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__Pelican_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Pelican_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__Pelican	RETVAL;
	Crypt__Mac__Pelican	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::Pelican")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Pelican,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::Pelican::clone",
			"self", "Crypt::Mac::Pelican",
			refstr, ST(0)
		);
	}
;
#line 38 "./inc/CryptX_Mac_Pelican.xs.inc"
        Newz(0, RETVAL, 1, pelican_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, pelican_state);
#line 8292 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::Pelican", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__Pelican_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Pelican_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__Pelican	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::Pelican")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Pelican,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::Pelican::add",
			"self", "Crypt::Mac::Pelican",
			refstr, ST(0)
		);
	}
;
#line 47 "./inc/CryptX_Mac_Pelican.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = pelican_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: pelican_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 8343 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__Pelican_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Pelican_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__Pelican	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::Pelican")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__Pelican,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::Pelican",
			refstr, ST(0)
		);
	}
;
#line 69 "./inc/CryptX_Mac_Pelican.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = 16;
        rv = pelican_done(self, mac);
        if (rv != CRYPT_OK) croak("FATAL: pelican_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 8404 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__Pelican_pelican); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__Pelican_pelican)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "key, ...");
    {
	SV *	RETVAL;
	SV *	key = ST(0)
;
#line 108 "./inc/CryptX_Mac_Pelican.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        pelican_state st;

        len = 16;
        rv = pelican_init(&st, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: pelican_init failed: %s", error_to_string(rv));
        for (i = 1; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = pelican_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: pelican_process failed: %s", error_to_string(rv));
          }
        }
        rv = pelican_done(&st, mac);
        if (rv != CRYPT_OK) croak("FATAL: pelican_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 8467 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_OMAC.xs.inc' from 'inc/CryptX_Mac_Pelican.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__OMAC_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__OMAC_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, cipher_name, key");
    {
	Crypt__Mac__OMAC	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_OMAC.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;
        int id;

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, omac_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = omac_init(RETVAL, id, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: omac_init failed: %s", error_to_string(rv));
        }
    }
#line 8512 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::OMAC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__OMAC_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__OMAC_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__OMAC	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__OMAC,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::OMAC::DESTROY",
			"self")
;
#line 37 "./inc/CryptX_Mac_OMAC.xs.inc"
        Safefree(self);
#line 8544 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__OMAC_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__OMAC_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__OMAC	RETVAL;
	Crypt__Mac__OMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::OMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__OMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::OMAC::clone",
			"self", "Crypt::Mac::OMAC",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_Mac_OMAC.xs.inc"
        Newz(0, RETVAL, 1, omac_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, omac_state);
#line 8577 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::OMAC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__OMAC_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__OMAC_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__OMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::OMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__OMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::OMAC::add",
			"self", "Crypt::Mac::OMAC",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Mac_OMAC.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = omac_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: omac_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 8628 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__OMAC_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__OMAC_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__OMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::OMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__OMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::OMAC",
			refstr, ST(0)
		);
	}
;
#line 73 "./inc/CryptX_Mac_OMAC.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = omac_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: omac_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 8689 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__OMAC_omac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__OMAC_omac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "cipher_name, key, ...");
    {
	SV *	RETVAL;
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
#line 112 "./inc/CryptX_Mac_OMAC.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        omac_state st;

        int id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipher failed for '%s'", cipher_name);
        rv = omac_init(&st, id, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: omac_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = omac_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: omac_process failed: %s", error_to_string(rv));
          }
        }
        rv = omac_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: omac_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 8755 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_HMAC.xs.inc' from 'inc/CryptX_Mac_OMAC.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__HMAC_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__HMAC_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, hash_name, key");
    {
	Crypt__Mac__HMAC	RETVAL;
	char *        hash_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_HMAC.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;
        int id;

        id = _find_hash(hash_name);
        if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, hmac_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = hmac_init(RETVAL, id, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: hmac_init failed: %s", error_to_string(rv));
        }
    }
#line 8800 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::HMAC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__HMAC_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__HMAC_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__HMAC	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__HMAC,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::HMAC::DESTROY",
			"self")
;
#line 37 "./inc/CryptX_Mac_HMAC.xs.inc"
        Safefree(self);
#line 8832 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__HMAC_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__HMAC_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__HMAC	RETVAL;
	Crypt__Mac__HMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::HMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__HMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::HMAC::clone",
			"self", "Crypt::Mac::HMAC",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_Mac_HMAC.xs.inc"
        Newz(0, RETVAL, 1, hmac_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, hmac_state);
#line 8865 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::HMAC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__HMAC_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__HMAC_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__HMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::HMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__HMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::HMAC::add",
			"self", "Crypt::Mac::HMAC",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Mac_HMAC.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = hmac_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: hmac_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 8916 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__HMAC_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__HMAC_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__HMAC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::HMAC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__HMAC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::HMAC",
			refstr, ST(0)
		);
	}
;
#line 73 "./inc/CryptX_Mac_HMAC.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = hmac_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: hmac_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 8977 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__HMAC_hmac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__HMAC_hmac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "hash_name, key, ...");
    {
	SV *	RETVAL;
	char *        hash_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
#line 112 "./inc/CryptX_Mac_HMAC.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        hmac_state st;

        int id = _find_hash(hash_name);
        if (id == -1) croak("FATAL: find_digest failed for '%s'", hash_name);
        rv = hmac_init(&st, id, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: hmac_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = hmac_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: hmac_process failed: %s", error_to_string(rv));
          }
        }
        rv = hmac_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: hmac_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 9043 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mac_F9.xs.inc' from 'inc/CryptX_Mac_HMAC.xs.inc' */


XS_EUPXS(XS_Crypt__Mac__F9_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__F9_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, cipher_name, key");
    {
	Crypt__Mac__F9	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	SV *	key = ST(2)
;
#line 10 "./inc/CryptX_Mac_F9.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        int rv;
        int id;

        id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipfer failed for '%s'", cipher_name);

        if (!SvPOK(key)) croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        Newz(0, RETVAL, 1, f9_state);
        if (!RETVAL) croak("FATAL: Newz failed");

        rv = f9_init(RETVAL, id, k, (unsigned long)k_len);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: f9_init failed: %s", error_to_string(rv));
        }
    }
#line 9088 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::F9", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__F9_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__F9_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__F9	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__F9,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mac::F9::DESTROY",
			"self")
;
#line 37 "./inc/CryptX_Mac_F9.xs.inc"
        Safefree(self);
#line 9120 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mac__F9_clone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__F9_clone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mac__F9	RETVAL;
	Crypt__Mac__F9	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::F9")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__F9,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::F9::clone",
			"self", "Crypt::Mac::F9",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_Mac_F9.xs.inc"
        Newz(0, RETVAL, 1, f9_state);
        if (!RETVAL) croak("FATAL: Newz failed");
        Copy(self, RETVAL, 1, f9_state);
#line 9153 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mac::F9", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__F9_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__F9_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mac__F9	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::F9")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__F9,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mac::F9::add",
			"self", "Crypt::Mac::F9",
			refstr, ST(0)
		);
	}
;
#line 51 "./inc/CryptX_Mac_F9.xs.inc"
    {
        int rv, i;
        STRLEN in_data_len;
        unsigned char *in_data;

        for(i = 1; i < items; i++) {
          in_data = (unsigned char *)SvPVbyte(ST(i), in_data_len);
          if (in_data_len > 0) {
            rv = f9_process(self, in_data, (unsigned long)in_data_len);
            if (rv != CRYPT_OK) croak("FATAL: f9_process failed: %s", error_to_string(rv));
          }
        }
        XPUSHs(ST(0)); /* return self */
    }
#line 9204 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mac__F9_mac); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__F9_mac)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mac__F9	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mac::F9")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mac__F9,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mac::F9",
			refstr, ST(0)
		);
	}
;
#line 73 "./inc/CryptX_Mac_F9.xs.inc"
    {
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long maclen, outlen;
        int rv;
        char out[MAXBLOCKSIZE*2+1];

        maclen = sizeof(mac);
        rv = f9_done(self, mac, &maclen);
        if (rv != CRYPT_OK) croak("FATAL: f9_done failed: %s", error_to_string(rv));
        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 2) {
          rv = base64_encode(mac, maclen, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        if (ix == 1) {
          rv = base16_encode(mac, maclen, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char * )mac, maclen);
        }
    }
#line 9265 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mac__F9_f9); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mac__F9_f9)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "cipher_name, key, ...");
    {
	SV *	RETVAL;
	char *        cipher_name = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
	SV *	key = ST(1)
;
#line 112 "./inc/CryptX_Mac_F9.xs.inc"
    {
        STRLEN inlen, klen;
        unsigned char *in;
        unsigned char *k = (unsigned char *)SvPVbyte(key, klen);
        int rv, i;
        unsigned char mac[MAXBLOCKSIZE];
        unsigned long len = sizeof(mac), outlen;
        char out[MAXBLOCKSIZE*2];
        f9_state st;

        int id = _find_cipher(cipher_name);
        if (id == -1) croak("FATAL: find_cipher failed for '%s'", cipher_name);
        rv = f9_init(&st, id, k, (unsigned long)klen);
        if (rv != CRYPT_OK) croak("FATAL: f9_init failed: %s", error_to_string(rv));
        for (i = 2; i < items; i++) {
          in = (unsigned char *)SvPVbyte(ST(i), inlen);
          if (inlen > 0) {
            rv = f9_process(&st, in, (unsigned long)inlen);
            if (rv != CRYPT_OK) croak("FATAL: f9_process failed: %s", error_to_string(rv));
          }
        }
        rv = f9_done(&st, mac, &len);
        if (rv != CRYPT_OK) croak("FATAL: f9_done failed: %s", error_to_string(rv));

        outlen = sizeof(out);
        if (ix == 3) {
          rv = base64url_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64url_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char *) out, outlen);
        }
        else if (ix == 2) {
          rv = base64_encode(mac, len, out, &outlen);
          if (rv != CRYPT_OK) croak("FATAL: base64_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else if (ix == 1) {
          rv = base16_encode(mac, len, out, &outlen, 0);
          if (rv != CRYPT_OK) croak("FATAL: base16_encode failed: %s", error_to_string(rv));
          RETVAL = newSVpvn(out, outlen);
        }
        else {
          RETVAL = newSVpvn((char *) mac, len);
        }
    }
#line 9331 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_Mac_F9.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mode_CBC.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_Mode_ECB.xs.inc' from 'inc/CryptX_Mode_CBC.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mode_CFB.xs.inc' from 'inc/CryptX_Mode_ECB.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mode_OFB.xs.inc' from 'inc/CryptX_Mode_CFB.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_Mode_CTR.xs.inc' from 'inc/CryptX_Mode_OFB.xs.inc' */


XS_EUPXS(XS_Crypt__Mode__CTR_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CTR_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "Class, cipher_name, ctr_mode=0, ctr_width=0, rounds=0");
    {
	Crypt__Mode__CTR	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	int	ctr_mode;
	int	ctr_width;
	int	rounds;

	if (items < 3)
	    ctr_mode = 0;
	else {
	    ctr_mode = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    ctr_width = 0;
	else {
	    ctr_width = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    rounds = 0;
	else {
	    rounds = (int)SvIV(ST(4))
;
	}
#line 10 "./inc/CryptX_Mode_CTR.xs.inc"
    {
        Newz(0, RETVAL, 1, struct ctr_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->direction = 0;
        RETVAL->cipher_rounds = rounds;
        RETVAL->cipher_id = _find_cipher(cipher_name);
        if (RETVAL->cipher_id == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        }
        if (ctr_mode == 0) RETVAL->ctr_mode_param = CTR_COUNTER_LITTLE_ENDIAN;
        if (ctr_mode == 1) RETVAL->ctr_mode_param = CTR_COUNTER_BIG_ENDIAN;
        if (ctr_mode == 2) RETVAL->ctr_mode_param = CTR_COUNTER_LITTLE_ENDIAN|LTC_CTR_RFC3686;
        if (ctr_mode == 3) RETVAL->ctr_mode_param = CTR_COUNTER_BIG_ENDIAN|LTC_CTR_RFC3686;
        if (ctr_width > 0 && ctr_width <= cipher_descriptor[RETVAL->cipher_id].block_length) RETVAL->ctr_mode_param |= ctr_width;
    }
#line 9408 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mode::CTR", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__CTR_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CTR_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mode__CTR	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CTR,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mode::CTR::DESTROY",
			"self")
;
#line 32 "./inc/CryptX_Mode_CTR.xs.inc"
        Safefree(self);
#line 9440 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mode__CTR_start_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CTR_start_decrypt)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "self, key, iv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mode__CTR	self;
	SV *	key = ST(1)
;
	SV *	iv = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CTR")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CTR,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mode::CTR",
			refstr, ST(0)
		);
	}
;
#line 39 "./inc/CryptX_Mode_CTR.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        STRLEN i_len=0;
        unsigned char *i=NULL;
        int rv;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        if (!SvPOK(iv))    croak("FATAL: iv must be string/buffer scalar");
        i = (unsigned char *) SvPVbyte(iv, i_len);
        if (i_len != (STRLEN)cipher_descriptor[self->cipher_id].block_length) {
          croak ("FATAL: sizeof(iv) should be equal to blocksize (%d)", cipher_descriptor[self->cipher_id].block_length);
        }

        rv = ctr_start(self->cipher_id, i, k, (int)k_len, self->cipher_rounds, self->ctr_mode_param, &self->state);
        if (rv != CRYPT_OK) {
          croak("FATAL: ctr_start failed: %s", error_to_string(rv));
        }

        self->direction = ix == 1 ? 1 : -1;
        XPUSHs(ST(0)); /* return self */
    }
#line 9500 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mode__CTR_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CTR_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	SV *	RETVAL;
	Crypt__Mode__CTR	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CTR")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CTR,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::CTR::add",
			"self", "Crypt::Mode::CTR",
			refstr, ST(0)
		);
	}
;
#line 67 "./inc/CryptX_Mode_CTR.xs.inc"
    {
        int rv, j;
        STRLEN in_data_len, out_len = 0;
        unsigned char *in_data, *out_data;

        RETVAL = newSVpvn("", 0);
        for (j = 1; j < items; j++) {
          in_data = (unsigned char *)SvPVbyte(ST(j), in_data_len);
          if (in_data_len > 0) {
            out_data = (unsigned char*)SvGROW(RETVAL, out_len + in_data_len + 1) + out_len;
            out_len += in_data_len;
            if (self->direction == 1) {
              rv = ctr_encrypt(in_data, out_data, (unsigned long)in_data_len, &self->state);
              if (rv != CRYPT_OK) {
                SvREFCNT_dec(RETVAL);
                croak("FATAL: ctr_encrypt failed: %s", error_to_string(rv));
              }
            }
            else if (self->direction == -1) {
              rv = ctr_decrypt(in_data, out_data, (unsigned long)in_data_len, &self->state);
              if (rv != CRYPT_OK) {
                SvREFCNT_dec(RETVAL);
                croak("FATAL: ctr_decrypt failed: %s", error_to_string(rv));
              }
            }
            else {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: ctr_crypt failed: call start_encrypt or start_decrypt first");
            }
          }
        }
        if (out_len > 0) SvCUR_set(RETVAL, out_len);
    }
#line 9564 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__CTR_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CTR_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mode__CTR	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CTR")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CTR,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::CTR::finish",
			"self", "Crypt::Mode::CTR",
			refstr, ST(0)
		);
	}
;
#line 106 "./inc/CryptX_Mode_CTR.xs.inc"
          self->direction = 0;
          RETVAL = newSVpvn("", 0);
#line 9598 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mode_OFB.xs.inc' from 'inc/CryptX_Mode_CTR.xs.inc' */


XS_EUPXS(XS_Crypt__Mode__OFB_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__OFB_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "Class, cipher_name, rounds=0");
    {
	Crypt__Mode__OFB	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	int	rounds;

	if (items < 3)
	    rounds = 0;
	else {
	    rounds = (int)SvIV(ST(2))
;
	}
#line 10 "./inc/CryptX_Mode_OFB.xs.inc"
    {
        Newz(0, RETVAL, 1, struct ofb_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->direction = 0;
        RETVAL->cipher_rounds = rounds;
        RETVAL->cipher_id = _find_cipher(cipher_name);
        if (RETVAL->cipher_id == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        }
    }
#line 9639 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mode::OFB", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__OFB_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__OFB_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mode__OFB	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__OFB,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mode::OFB::DESTROY",
			"self")
;
#line 27 "./inc/CryptX_Mode_OFB.xs.inc"
        Safefree(self);
#line 9671 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mode__OFB_start_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__OFB_start_decrypt)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "self, key, iv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mode__OFB	self;
	SV *	key = ST(1)
;
	SV *	iv = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::OFB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__OFB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mode::OFB",
			refstr, ST(0)
		);
	}
;
#line 34 "./inc/CryptX_Mode_OFB.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        STRLEN i_len=0;
        unsigned char *i=NULL;
        int rv;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        if (!SvPOK(iv))    croak("FATAL: iv must be string/buffer scalar");
        i = (unsigned char *) SvPVbyte(iv, i_len);
        if (i_len != (STRLEN)cipher_descriptor[self->cipher_id].block_length) {
          croak ("FATAL: sizeof(iv) should be equal to blocksize (%d)", cipher_descriptor[self->cipher_id].block_length);
        }

        rv = ofb_start(self->cipher_id, i, k, (int)k_len, self->cipher_rounds, &self->state);
        if (rv != CRYPT_OK) {
          croak("FATAL: ofb_start failed: %s", error_to_string(rv));
        }

        self->direction = ix == 1 ? 1 : -1;
        XPUSHs(ST(0)); /* return self */
    }
#line 9731 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mode__OFB_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__OFB_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	SV *	RETVAL;
	Crypt__Mode__OFB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::OFB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__OFB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::OFB::add",
			"self", "Crypt::Mode::OFB",
			refstr, ST(0)
		);
	}
;
#line 62 "./inc/CryptX_Mode_OFB.xs.inc"
    {
        int rv, j;
        STRLEN in_data_len, out_len = 0;
        unsigned char *in_data, *out_data;

        RETVAL = newSVpvn("", 0);
        for (j = 1; j < items; j++) {
          in_data = (unsigned char *)SvPVbyte(ST(j), in_data_len);
          if (in_data_len > 0) {
            out_data = (unsigned char*)SvGROW(RETVAL, out_len + in_data_len + 1) + out_len;
            out_len += in_data_len;
            if (self->direction == 1) {
              rv = ofb_encrypt(in_data, out_data, (unsigned long)in_data_len, &self->state);
              if (rv != CRYPT_OK) {
                SvREFCNT_dec(RETVAL);
                croak("FATAL: ofb_encrypt failed: %s", error_to_string(rv));
              }
            }
            else if (self->direction == -1) {
              rv = ofb_decrypt(in_data, out_data, (unsigned long)in_data_len, &self->state);
              if (rv != CRYPT_OK) {
                SvREFCNT_dec(RETVAL);
                croak("FATAL: ofb_decrypt failed: %s", error_to_string(rv));
              }
            }
            else {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: ofb_crypt failed: call start_encrypt or start_decrypt first");
            }
          }
        }
        if (out_len > 0) SvCUR_set(RETVAL, out_len);
    }
#line 9795 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__OFB_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__OFB_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mode__OFB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::OFB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__OFB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::OFB::finish",
			"self", "Crypt::Mode::OFB",
			refstr, ST(0)
		);
	}
;
#line 101 "./inc/CryptX_Mode_OFB.xs.inc"
          self->direction = 0;
          RETVAL = newSVpvn("", 0);
#line 9829 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mode_CFB.xs.inc' from 'inc/CryptX_Mode_OFB.xs.inc' */


XS_EUPXS(XS_Crypt__Mode__CFB_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CFB_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "Class, cipher_name, rounds=0");
    {
	Crypt__Mode__CFB	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	int	rounds;

	if (items < 3)
	    rounds = 0;
	else {
	    rounds = (int)SvIV(ST(2))
;
	}
#line 10 "./inc/CryptX_Mode_CFB.xs.inc"
    {
        Newz(0, RETVAL, 1, struct cfb_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->direction = 0;
        RETVAL->cipher_rounds = rounds;
        RETVAL->cipher_id = _find_cipher(cipher_name);
        if (RETVAL->cipher_id == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        }
    }
#line 9870 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mode::CFB", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__CFB_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CFB_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mode__CFB	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CFB,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mode::CFB::DESTROY",
			"self")
;
#line 27 "./inc/CryptX_Mode_CFB.xs.inc"
        Safefree(self);
#line 9902 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mode__CFB_start_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CFB_start_decrypt)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "self, key, iv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mode__CFB	self;
	SV *	key = ST(1)
;
	SV *	iv = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CFB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CFB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mode::CFB",
			refstr, ST(0)
		);
	}
;
#line 34 "./inc/CryptX_Mode_CFB.xs.inc"
    {
        STRLEN k_len=0;
        unsigned char *k=NULL;
        STRLEN i_len=0;
        unsigned char *i=NULL;
        int rv;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        if (!SvPOK(iv))    croak("FATAL: iv must be string/buffer scalar");
        i = (unsigned char *) SvPVbyte(iv, i_len);
        if (i_len != (STRLEN)cipher_descriptor[self->cipher_id].block_length) {
          croak ("FATAL: sizeof(iv) should be equal to blocksize (%d)", cipher_descriptor[self->cipher_id].block_length);
        }

        rv = cfb_start(self->cipher_id, i, k, (int)k_len, self->cipher_rounds, &self->state);
        if (rv != CRYPT_OK) {
          croak("FATAL: cfb_start failed: %s", error_to_string(rv));
        }

        self->direction = ix == 1 ? 1 : -1;
        XPUSHs(ST(0)); /* return self */
    }
#line 9962 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mode__CFB_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CFB_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	SV *	RETVAL;
	Crypt__Mode__CFB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CFB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CFB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::CFB::add",
			"self", "Crypt::Mode::CFB",
			refstr, ST(0)
		);
	}
;
#line 62 "./inc/CryptX_Mode_CFB.xs.inc"
    {
        int rv, j;
        STRLEN in_data_len, out_len = 0;
        unsigned char *in_data, *out_data;

        RETVAL = newSVpvn("", 0);
        for (j = 1; j < items; j++) {
          in_data = (unsigned char *)SvPVbyte(ST(j), in_data_len);
          if (in_data_len > 0) {
            out_data = (unsigned char*)SvGROW(RETVAL, out_len + in_data_len + 1) + out_len;
            out_len += in_data_len;
            if (self->direction == 1) {
              rv = cfb_encrypt(in_data, out_data, (unsigned long)in_data_len, &self->state);
              if (rv != CRYPT_OK) {
                SvREFCNT_dec(RETVAL);
                croak("FATAL: cfb_encrypt failed: %s", error_to_string(rv));
              }
            }
            else if (self->direction == -1) {
              rv = cfb_decrypt(in_data, out_data, (unsigned long)in_data_len, &self->state);
              if (rv != CRYPT_OK) {
                SvREFCNT_dec(RETVAL);
                croak("FATAL: cfb_decrypt failed: %s", error_to_string(rv));
              }
            }
            else {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: cfb_crypt failed: call start_encrypt or start_decrypt first");
            }
          }
        }
        if (out_len > 0) SvCUR_set(RETVAL, out_len);
    }
#line 10026 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__CFB_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CFB_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mode__CFB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CFB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CFB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::CFB::finish",
			"self", "Crypt::Mode::CFB",
			refstr, ST(0)
		);
	}
;
#line 101 "./inc/CryptX_Mode_CFB.xs.inc"
          self->direction = 0;
          RETVAL = newSVpvn("", 0);
#line 10060 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mode_ECB.xs.inc' from 'inc/CryptX_Mode_CFB.xs.inc' */


XS_EUPXS(XS_Crypt__Mode__ECB_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__ECB_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "Class, cipher_name, padding=1, rounds=0");
    {
	Crypt__Mode__ECB	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	int	padding;
	int	rounds;

	if (items < 3)
	    padding = 1;
	else {
	    padding = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    rounds = 0;
	else {
	    rounds = (int)SvIV(ST(3))
;
	}
#line 10 "./inc/CryptX_Mode_ECB.xs.inc"
    {
        Newz(0, RETVAL, 1, struct ecb_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->padding_mode = padding;
        RETVAL->padlen = 0;
        RETVAL->direction = 0;
        RETVAL->cipher_rounds = rounds;
        RETVAL->cipher_id = _find_cipher(cipher_name);
        if (RETVAL->cipher_id == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        }
    }
#line 10111 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mode::ECB", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__ECB_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__ECB_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mode__ECB	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__ECB,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mode::ECB::DESTROY",
			"self")
;
#line 29 "./inc/CryptX_Mode_ECB.xs.inc"
        Safefree(self);
#line 10143 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mode__ECB_start_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__ECB_start_decrypt)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, key");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mode__ECB	self;
	SV *	key = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::ECB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__ECB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mode::ECB",
			refstr, ST(0)
		);
	}
;
#line 36 "./inc/CryptX_Mode_ECB.xs.inc"
    {
        int rv;
        STRLEN k_len=0;
        unsigned char *k=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        rv = ecb_start(self->cipher_id, k, (unsigned long)k_len, self->cipher_rounds, &self->state);
        if (rv != CRYPT_OK) {
          croak("FATAL: ecb_start failed: %s", error_to_string(rv));
        }

        self->direction = ix == 1 ? 1 : -1;
        self->padlen = 0;
        XPUSHs(ST(0)); /* return self */
    }
#line 10194 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mode__ECB_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__ECB_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	SV *	RETVAL;
	Crypt__Mode__ECB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::ECB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__ECB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::ECB::add",
			"self", "Crypt::Mode::ECB",
			refstr, ST(0)
		);
	}
;
#line 57 "./inc/CryptX_Mode_ECB.xs.inc"
    {
        int rv, has_tmp_block, blen, j;
        unsigned long i;
        STRLEN in_data_len, in_data_start, out_len = 0;
        unsigned char *in_data, *out_data, tmp_block[MAXBLOCKSIZE];

        RETVAL = newSVpvn("", 0);
        for (j = 1; j < items; j++) {
          in_data = (unsigned char *)SvPVbyte(ST(j), in_data_len);
          blen = (&self->state)->blocklen;
          in_data_start = 0;
          has_tmp_block = 0;
          if (in_data_len > 0) {
            if (self->direction == 1) {
              /* handle non-empty self->pad buffer */
              if (self->padlen > 0) {
                i = (blen - self->padlen);
                if (in_data_len >= i) { /* enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, i, unsigned char);
                  in_data_len -= i;
                  in_data_start = i;
                  rv = ecb_encrypt(self->pad, tmp_block, blen, &self->state);
                  if (rv != CRYPT_OK) {
                    SvREFCNT_dec(RETVAL);
                    croak("FATAL: ecb_encrypt failed: %s", error_to_string(rv));
                  }
                  self->padlen = 0;
                  has_tmp_block = 1;
                }
                else { /* not enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, in_data_len, unsigned char);
                  self->padlen += (int)in_data_len;
                  in_data_len = 0;
                }
              }

              i = (unsigned long)(in_data_len % blen);
              if (in_data_len > 0 && i > 0) { /* save tail of data into pad */
                Copy(in_data + in_data_start + in_data_len - i, self->pad, i, unsigned char);
                self->padlen = i;
                in_data_len -= i;
              }

              if (in_data_len > 0) {
                i = (unsigned long)(has_tmp_block ? in_data_len + blen : in_data_len);
                out_data = (unsigned char*)SvGROW(RETVAL, out_len + i + 1) + out_len;
                out_len += i;
                if (has_tmp_block) {
                  Copy(tmp_block, out_data, blen, unsigned char);
                  out_data += blen;
                }
                rv = ecb_encrypt(in_data+in_data_start, out_data, (unsigned long)in_data_len, &self->state);
                if (rv != CRYPT_OK) {
                  SvREFCNT_dec(RETVAL);
                  croak("FATAL: ecb_encrypt failed: %s", error_to_string(rv));
                }
              } /* in_data_len > 0 */
              else if (has_tmp_block) {
                out_data = (unsigned char*)SvGROW(RETVAL, out_len + blen + 1) + out_len;
                out_len += blen;
                Copy(tmp_block, out_data, blen, unsigned char);
              }
            }
            else if (self->direction == -1) {
              if (self->padlen == blen) {
                rv = ecb_decrypt(self->pad, tmp_block, blen, &self->state);
                if (rv != CRYPT_OK) {
                  SvREFCNT_dec(RETVAL);
                  croak("FATAL: ecb_decrypt failed: %s", error_to_string(rv));
                }
                self->padlen = 0;
                has_tmp_block = 1;
              } /* padlen == blen */
              else if (self->padlen > 0) {
                i = (blen - self->padlen); /* remaining bytes in padding buffer */
                if (in_data_len >= i) { /* enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, i, unsigned char);
                  self->padlen += i;
                  in_data_len -= i;
                  in_data_start = i;
                  if (in_data_len>0 || self->padding_mode == 0) {
                    rv = ecb_decrypt(self->pad, tmp_block, blen, &self->state);
                    if (rv != CRYPT_OK) {
                      SvREFCNT_dec(RETVAL);
                      croak("FATAL: ecb_decrypt failed: %s", error_to_string(rv));
                    }
                    self->padlen = 0;
                    has_tmp_block = 1;
                  }
                }
                else { /* not enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, in_data_len, unsigned char);
                  self->padlen += (int)in_data_len;
                  in_data_len = 0;
                }
              } /* padlen > 0 */

              /* here: a/ padlen == 1..16 && in_data_len == 0; b/ padlen == 0 && in_data_len > 0 */
              if (in_data_len>0) {
                i = (unsigned long)(in_data_len % blen);
                if (i>0) { /* save tail of data into pad */
                  Copy(in_data+in_data_start+in_data_len-i, self->pad, i, unsigned char);
                  self->padlen = i;
                  in_data_len -= i;
                }
              }

              if (in_data_len>0) {
                if (self->padlen == 0 && self->padding_mode !=0) {
                  /* in case of padding keep full pad if no more data */
                  Copy(in_data+in_data_start+in_data_len-blen, self->pad, blen, unsigned char);
                  self->padlen = blen;
                  in_data_len -= blen;
                }
                i = (unsigned long)(has_tmp_block ? in_data_len + blen : in_data_len);
                if (i > 0) {
                  out_data = (unsigned char*)SvGROW(RETVAL, out_len + i + 1) + out_len;
                  out_len += i;
                  if (has_tmp_block) {
                    Copy(tmp_block, out_data, blen, unsigned char);
                    out_data += blen;
                  }
                  rv = ecb_decrypt(in_data+in_data_start, out_data, (unsigned long)in_data_len, &self->state);
                  if (rv != CRYPT_OK) {
                    SvREFCNT_dec(RETVAL);
                    croak("FATAL: ecb_decrypt failed: %s", error_to_string(rv));
                  }
                }
              } /* in_data_len>0 */
              else if (has_tmp_block) {
                out_data = (unsigned char*)SvGROW(RETVAL, out_len + blen + 1) + out_len;
                out_len += blen;
                Copy(tmp_block, out_data, blen, unsigned char);
              }
            }
            else {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: call start_decryt or start_encrpyt first (%d)", self->direction);
            }
          }
        }
        if (out_len > 0) SvCUR_set(RETVAL, out_len);
    }
#line 10368 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__ECB_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__ECB_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mode__ECB	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::ECB")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__ECB,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::ECB::finish",
			"self", "Crypt::Mode::ECB",
			refstr, ST(0)
		);
	}
;
#line 206 "./inc/CryptX_Mode_ECB.xs.inc"
    {
        unsigned char tmp_block[MAXBLOCKSIZE];
        int rv;
        unsigned long blen = (&self->state)->blocklen;
        unsigned long padmode;

        if (self->direction == 1) {
          if (self->padlen < 0 || self->padlen >= (int)blen) croak("FATAL: invalid padlen");
          if (self->padding_mode != 0) {
            if      (self->padding_mode == 1) { padmode = LTC_PAD_PKCS7        | (&self->state)->blocklen; }
            else if (self->padding_mode == 2) { padmode = LTC_PAD_ONE_AND_ZERO | (&self->state)->blocklen; }
            else if (self->padding_mode == 3) { padmode = LTC_PAD_ANSI_X923    | (&self->state)->blocklen; }
            else if (self->padding_mode == 4) { padmode = LTC_PAD_ZERO         | (&self->state)->blocklen; }
            else if (self->padding_mode == 5) { padmode = LTC_PAD_ZERO_ALWAYS  | (&self->state)->blocklen; }
            else { croak("FATAL: unknown padding"); }
            blen = sizeof(self->pad);
            rv = padding_pad(self->pad, self->padlen, &blen, padmode);
            if (rv != CRYPT_OK) croak("FATAL: padding_pad failed: %s", error_to_string(rv));
            rv = ecb_encrypt(self->pad, tmp_block, blen, &self->state);
            if (rv != CRYPT_OK) croak("FATAL: ecb_encrypt failed: %s", error_to_string(rv));
          }
          else {
            if (self->padlen > 0) croak("FATAL: ecb_encrypt, input data length not multiple of %d", (int)blen);
            blen = 0;
          }
        }
        else if (self->direction == -1) {
          if (self->padlen > 0) {
            if (self->padlen != (int)blen) croak("FATAL: cipher text length has to be multiple of %d (%d)", (int)blen, self->padlen);
            rv = ecb_decrypt(self->pad, tmp_block, blen, &self->state);
            if (rv != CRYPT_OK) croak("FATAL: ecb_decrypt failed: %s", error_to_string(rv));
            if (self->padding_mode != 0) {
              if      (self->padding_mode == 1) { padmode = LTC_PAD_PKCS7        | (&self->state)->blocklen; }
              else if (self->padding_mode == 2) { padmode = LTC_PAD_ONE_AND_ZERO | (&self->state)->blocklen; }
              else if (self->padding_mode == 3) { padmode = LTC_PAD_ANSI_X923    | (&self->state)->blocklen; }
              else if (self->padding_mode == 4) { padmode = LTC_PAD_ZERO         | (&self->state)->blocklen; }
              else if (self->padding_mode == 5) { padmode = LTC_PAD_ZERO_ALWAYS  | (&self->state)->blocklen; }
              else { croak("FATAL: unknown padding"); }
              rv = padding_depad(tmp_block, &blen, padmode);
              if (rv != CRYPT_OK) croak("FATAL: padding_depad failed: %s", error_to_string(rv));
            }
            else {
              /* "no padding" == there is no need to do anything */
            }
          }
          else {
            blen = 0;
          }
        }
        else {
           croak("FATAL: invalid direction");
        }

        self->direction = 0;
        RETVAL = newSVpvn((char*)tmp_block, blen);
    }
#line 10456 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'inc/CryptX_Mode_CBC.xs.inc' from 'inc/CryptX_Mode_ECB.xs.inc' */


XS_EUPXS(XS_Crypt__Mode__CBC_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CBC_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "Class, cipher_name, padding=1, rounds=0");
    {
	Crypt__Mode__CBC	RETVAL;
	char *        cipher_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	int	padding;
	int	rounds;

	if (items < 3)
	    padding = 1;
	else {
	    padding = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    rounds = 0;
	else {
	    rounds = (int)SvIV(ST(3))
;
	}
#line 10 "./inc/CryptX_Mode_CBC.xs.inc"
    {
        Newz(0, RETVAL, 1, struct cbc_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->padding_mode = padding;
        RETVAL->padlen = 0;
        RETVAL->direction = 0;
        RETVAL->cipher_rounds = rounds;
        RETVAL->cipher_id = _find_cipher(cipher_name);
        if (RETVAL->cipher_id == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_cipfer failed for '%s'", cipher_name);
        }
    }
#line 10507 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::Mode::CBC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__CBC_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CBC_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__Mode__CBC	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CBC,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::Mode::CBC::DESTROY",
			"self")
;
#line 29 "./inc/CryptX_Mode_CBC.xs.inc"
        Safefree(self);
#line 10539 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__Mode__CBC_start_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CBC_start_decrypt)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "self, key, iv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__Mode__CBC	self;
	SV *	key = ST(1)
;
	SV *	iv = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CBC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CBC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::Mode::CBC",
			refstr, ST(0)
		);
	}
;
#line 36 "./inc/CryptX_Mode_CBC.xs.inc"
    {
        int rv;
        STRLEN k_len=0;
        unsigned char *k=NULL;
        STRLEN i_len=0;
        unsigned char *i=NULL;

        if (!SvPOK(key))   croak("FATAL: key must be string/buffer scalar");
        k = (unsigned char *) SvPVbyte(key, k_len);

        if (!SvPOK(iv))    croak("FATAL: iv must be string/buffer scalar");
        i = (unsigned char *) SvPVbyte(iv, i_len);
        if (i_len != (STRLEN)cipher_descriptor[self->cipher_id].block_length) {
          croak ("FATAL: sizeof(iv) should be equal to blocksize (%d)", cipher_descriptor[self->cipher_id].block_length);
        }
        rv = cbc_start(self->cipher_id, i, k, (unsigned long)k_len, self->cipher_rounds, &self->state);
        if (rv != CRYPT_OK) {
          croak("FATAL: cbc_start failed: %s", error_to_string(rv));
        }

        self->direction = ix == 1 ? 1 : -1;
        self->padlen = 0;
        XPUSHs(ST(0)); /* return self */
    }
#line 10599 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__Mode__CBC_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CBC_add)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	SV *	RETVAL;
	Crypt__Mode__CBC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CBC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CBC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::CBC::add",
			"self", "Crypt::Mode::CBC",
			refstr, ST(0)
		);
	}
;
#line 64 "./inc/CryptX_Mode_CBC.xs.inc"
    {
        int rv, has_tmp_block, blen, j;
        unsigned long i;
        STRLEN in_data_len, in_data_start, out_len = 0;
        unsigned char *in_data, *out_data, tmp_block[MAXBLOCKSIZE];

        RETVAL = newSVpvn("", 0);
        for (j = 1; j < items; j++) {
          in_data = (unsigned char *)SvPVbyte(ST(j), in_data_len);
          blen = (&self->state)->blocklen;
          in_data_start = 0;
          has_tmp_block = 0;
          if (in_data_len > 0) {
            if (self->direction == 1) {
              /* handle non-empty self->pad buffer */
              if (self->padlen > 0) {
                i = (blen - self->padlen);
                if (in_data_len >= i) { /* enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, i, unsigned char);
                  in_data_len -= i;
                  in_data_start = i;
                  rv = cbc_encrypt(self->pad, tmp_block, blen, &self->state);
                  if (rv != CRYPT_OK) {
                    SvREFCNT_dec(RETVAL);
                    croak("FATAL: cbc_encrypt failed: %s", error_to_string(rv));
                  }
                  self->padlen = 0;
                  has_tmp_block = 1;
                }
                else { /* not enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, in_data_len, unsigned char);
                  self->padlen += (int)in_data_len;
                  in_data_len = 0;
                }
              }

              i = (unsigned long)(in_data_len % blen);
              if (in_data_len > 0 && i > 0) { /* save tail of data into pad */
                Copy(in_data + in_data_start + in_data_len - i, self->pad, i, unsigned char);
                self->padlen = i;
                in_data_len -= i;
              }

              if (in_data_len > 0) {
                i = (unsigned long)(has_tmp_block ? in_data_len + blen : in_data_len);
                out_data = (unsigned char*)SvGROW(RETVAL, out_len + i + 1) + out_len;
                out_len += i;
                if (has_tmp_block) {
                  Copy(tmp_block, out_data, blen, unsigned char);
                  out_data += blen;
                }
                rv = cbc_encrypt(in_data+in_data_start, out_data, (unsigned long)in_data_len, &self->state);
                if (rv != CRYPT_OK) {
                  SvREFCNT_dec(RETVAL);
                  croak("FATAL: cbc_encrypt failed: %s", error_to_string(rv));
                }
              } /* in_data_len > 0 */
              else if (has_tmp_block) {
                out_data = (unsigned char*)SvGROW(RETVAL, out_len + blen + 1) + out_len;
                out_len += blen;
                Copy(tmp_block, out_data, blen, unsigned char);
              }
            }
            else if (self->direction == -1) {
              if (self->padlen == blen) {
                rv = cbc_decrypt(self->pad, tmp_block, blen, &self->state);
                if (rv != CRYPT_OK) {
                  SvREFCNT_dec(RETVAL);
                  croak("FATAL: cbc_decrypt failed: %s", error_to_string(rv));
                }
                self->padlen = 0;
                has_tmp_block = 1;
              } /* padlen == blen */
              else if (self->padlen > 0) {
                i = (blen - self->padlen); /* remaining bytes in padding buffer */
                if (in_data_len >= i) { /* enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, i, unsigned char);
                  self->padlen += i;
                  in_data_len -= i;
                  in_data_start = i;
                  if (in_data_len>0 || self->padding_mode == 0) {
                    rv = cbc_decrypt(self->pad, tmp_block, blen, &self->state);
                    if (rv != CRYPT_OK) {
                      SvREFCNT_dec(RETVAL);
                      croak("FATAL: cbc_decrypt failed: %s", error_to_string(rv));
                    }
                    self->padlen = 0;
                    has_tmp_block = 1;
                  }
                }
                else { /* not enough data to fill pad */
                  Copy(in_data, self->pad+self->padlen, in_data_len, unsigned char);
                  self->padlen += (int)in_data_len;
                  in_data_len = 0;
                }
              } /* padlen > 0 */

              /* here: a/ padlen == 1..16 && in_data_len == 0; b/ padlen == 0 && in_data_len > 0 */
              if (in_data_len>0) {
                i = (unsigned long)(in_data_len % blen);
                if (i>0) { /* save tail of data into pad */
                  Copy(in_data+in_data_start+in_data_len-i, self->pad, i, unsigned char);
                  self->padlen = i;
                  in_data_len -= i;
                }
              }

              if (in_data_len>0) {
                if (self->padlen == 0 && self->padding_mode !=0) {
                  /* in case of padding keep full pad if no more data */
                  Copy(in_data+in_data_start+in_data_len-blen, self->pad, blen, unsigned char);
                  self->padlen = blen;
                  in_data_len -= blen;
                }
                i = (unsigned long)(has_tmp_block ? in_data_len + blen : in_data_len);
                if (i > 0) {
                  out_data = (unsigned char*)SvGROW(RETVAL, out_len + i + 1) + out_len;
                  out_len += i;
                  if (has_tmp_block) {
                    Copy(tmp_block, out_data, blen, unsigned char);
                    out_data += blen;
                  }
                  rv = cbc_decrypt(in_data+in_data_start, out_data, (unsigned long)in_data_len, &self->state);
                  if (rv != CRYPT_OK) {
                    SvREFCNT_dec(RETVAL);
                    croak("FATAL: cbc_decrypt failed: %s", error_to_string(rv));
                  }
                }
              } /* in_data_len>0 */
              else if (has_tmp_block) {
                out_data = (unsigned char*)SvGROW(RETVAL, out_len + blen + 1) + out_len;
                out_len += blen;
                Copy(tmp_block, out_data, blen, unsigned char);
              }
            }
            else {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: call start_decryt or start_encrpyt first (%d)", self->direction);
            }
          }
        }
        if (out_len > 0) SvCUR_set(RETVAL, out_len);
    }
#line 10773 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__Mode__CBC_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__Mode__CBC_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
	Crypt__Mode__CBC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::Mode::CBC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__Mode__CBC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::Mode::CBC::finish",
			"self", "Crypt::Mode::CBC",
			refstr, ST(0)
		);
	}
;
#line 213 "./inc/CryptX_Mode_CBC.xs.inc"
    {
        unsigned char tmp_block[MAXBLOCKSIZE];
        int rv;
        unsigned long blen = (&self->state)->blocklen;
        unsigned long padmode;

        if (self->direction == 1) {
          if (self->padlen < 0 || self->padlen >= (int)blen) croak("FATAL: invalid padlen");
          if (self->padding_mode != 0) {
            if      (self->padding_mode == 1) { padmode = LTC_PAD_PKCS7        | (&self->state)->blocklen; }
            else if (self->padding_mode == 2) { padmode = LTC_PAD_ONE_AND_ZERO | (&self->state)->blocklen; }
            else if (self->padding_mode == 3) { padmode = LTC_PAD_ANSI_X923    | (&self->state)->blocklen; }
            else if (self->padding_mode == 4) { padmode = LTC_PAD_ZERO         | (&self->state)->blocklen; }
            else if (self->padding_mode == 5) { padmode = LTC_PAD_ZERO_ALWAYS  | (&self->state)->blocklen; }
            else { croak("FATAL: unknown padding"); }
            blen = sizeof(self->pad);
            rv = padding_pad(self->pad, self->padlen, &blen, padmode);
            if (rv != CRYPT_OK) croak("FATAL: padding_pad failed: %s", error_to_string(rv));
            rv = cbc_encrypt(self->pad, tmp_block, blen, &self->state);
            if (rv != CRYPT_OK) croak("FATAL: cbc_encrypt failed: %s", error_to_string(rv));
          }
          else {
            if (self->padlen > 0) croak("FATAL: cbc_encrypt, input data length not multiple of %d", (int)blen);
            blen = 0;
          }
        }
        else if (self->direction == -1) {
          if (self->padlen > 0) {
            if (self->padlen != (int)blen) croak("FATAL: cipher text length has to be multiple of %d (%d)", (int)blen, self->padlen);
            rv = cbc_decrypt(self->pad, tmp_block, blen, &self->state);
            if (rv != CRYPT_OK) croak("FATAL: cbc_decrypt failed: %s", error_to_string(rv));
            if (self->padding_mode != 0) {
              if      (self->padding_mode == 1) { padmode = LTC_PAD_PKCS7        | (&self->state)->blocklen; }
              else if (self->padding_mode == 2) { padmode = LTC_PAD_ONE_AND_ZERO | (&self->state)->blocklen; }
              else if (self->padding_mode == 3) { padmode = LTC_PAD_ANSI_X923    | (&self->state)->blocklen; }
              else if (self->padding_mode == 4) { padmode = LTC_PAD_ZERO         | (&self->state)->blocklen; }
              else if (self->padding_mode == 5) { padmode = LTC_PAD_ZERO_ALWAYS  | (&self->state)->blocklen; }
              else { croak("FATAL: unknown padding"); }
              rv = padding_depad(tmp_block, &blen, padmode);
              if (rv != CRYPT_OK) croak("FATAL: padding_depad failed: %s", error_to_string(rv));
            }
            else {
              /* "no padding" == there is no need to do anything */
            }
          }
          else {
            blen = 0;
          }
        }
        else {
           croak("FATAL: invalid direction");
        }

        self->direction = 0;
        RETVAL = newSVpvn((char*)tmp_block, blen);
    }
#line 10861 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_Mode_CBC.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_PRNG.xs.inc' from 'CryptX.xs' */


XS_EUPXS(XS_Crypt__PRNG_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PRNG_new)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "class, ...");
    {
	Crypt__PRNG	RETVAL;
	char *        class = (SvOK(ST(0))) ? SvPV_nolen(ST(0)) : NULL
;
#line 8 "./inc/CryptX_PRNG.xs.inc"
    {
        IV curpid = (IV)PerlProc_getpid();
        int rv, id, idx;
        unsigned char *ent=NULL;
        STRLEN ent_len=0;
        unsigned char entropy_buf[40];
        char *prng_name = (char *)"ChaCha20";
        SV *entropy = &PL_sv_undef;

        /* we need to handle:
           Crypt::PRNG->new('RC4');
           Crypt::Cipher::RC4->new();
         */
        idx = strcmp("Crypt::PRNG", class) == 0 ? 1 : 0;
        if (idx + 1 <= items) prng_name = SvPVX(ST(idx));
        if (idx + 2 <= items) entropy = ST(idx + 1);

        Newz(0, RETVAL, 1, struct prng_struct);
        if (!RETVAL) croak("FATAL: Newz failed");

        id = _find_prng(prng_name);
        if (id == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_prng failed for '%s'", prng_name);
        }
        RETVAL->last_pid = curpid;
        RETVAL->desc = &prng_descriptor[id];

        rv = RETVAL->desc->start(&RETVAL->state);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: PRNG_start failed: %s", error_to_string(rv));
        }

        if (SvOK(entropy)) {
          ent = (unsigned char *) SvPVbyte(entropy, ent_len);
          rv = RETVAL->desc->add_entropy(ent, (unsigned long)ent_len, &RETVAL->state);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: PRNG_add_entropy failed: %s", error_to_string(rv));
          }
        }
        else {
          if (rng_get_bytes(entropy_buf, 40, NULL) != 40) {
            Safefree(RETVAL);
            croak("FATAL: rng_get_bytes failed: %s", error_to_string(rv));
          }
          rv = RETVAL->desc->add_entropy(entropy_buf, 40, &RETVAL->state);
          if (rv != CRYPT_OK) {
            Safefree(RETVAL);
            croak("FATAL: PRNG_add_entropy failed: %s", error_to_string(rv));
          }
        }
        rv = RETVAL->desc->ready(&RETVAL->state);
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: PRNG_ready failed: %s", error_to_string(rv));
        }
    }
#line 10945 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::PRNG", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PRNG_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PRNG_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__PRNG	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PRNG,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::PRNG::DESTROY",
			"self")
;
#line 73 "./inc/CryptX_PRNG.xs.inc"
        Safefree(self);
#line 10977 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__PRNG_add_entropy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PRNG_add_entropy)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, entropy=&PL_sv_undef");
    {
	Crypt__PRNG	self;
	SV *	entropy;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PRNG")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PRNG,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PRNG::add_entropy",
			"self", "Crypt::PRNG",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    entropy = &PL_sv_undef;
	else {
	    entropy = ST(1)
;
	}
#line 78 "./inc/CryptX_PRNG.xs.inc"
    {
        STRLEN in_len=0;
        unsigned char *in_buffer=NULL;
        unsigned char entropy_buf[40];
        int rv;
        if (SvOK(entropy)) {
          in_buffer = (unsigned char *) SvPVbyte(entropy, in_len);
          rv = self->desc->add_entropy(in_buffer, (unsigned long)in_len, &self->state);
          if (rv != CRYPT_OK) croak("FATAL: PRNG_add_entropy failed: %s", error_to_string(rv));
        }
        else {
          if (rng_get_bytes(entropy_buf, 40, NULL) != 40) croak("FATAL: rng_get_bytes failed");
          rv = self->desc->add_entropy(entropy_buf, 40, &self->state);
          if (rv != CRYPT_OK) croak("FATAL: PRNG_add_entropy failed: %s", error_to_string(rv));
        }
        rv = self->desc->ready(&self->state);
        if (rv != CRYPT_OK) croak("FATAL: PRNG_ready failed: %s", error_to_string(rv));
    }
#line 11032 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__PRNG_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PRNG_bytes)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, output_len");
    {
	SV *	RETVAL;
	Crypt__PRNG	self;
	unsigned long	output_len = (unsigned long)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PRNG")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PRNG,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PRNG",
			refstr, ST(0)
		);
	}
;
#line 104 "./inc/CryptX_PRNG.xs.inc"
    {
        IV curpid = (IV)PerlProc_getpid();
        int rv_len, rv;
        unsigned long len;
        unsigned char *tmp;
        char *rdata;
        unsigned char entropy_buf[40];

        if (output_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          if (self->last_pid != curpid) {
            if (rng_get_bytes(entropy_buf, 40, NULL) != 40) croak("FATAL: rng_get_bytes failed");
            self->desc->add_entropy(entropy_buf, 40, &self->state);
            self->desc->ready(&self->state);
            self->last_pid = curpid;
          }
          if (ix == 1) {
            /* HEX */
            Newz(0, tmp, output_len, unsigned char);
            if (tmp == NULL) croak("FATAL: Newz failed");
            rv_len = (self->desc->read)(tmp, (unsigned long)output_len, &self->state);
            if ((UV)rv_len != output_len) croak("FATAL: PRNG_read failed");
            RETVAL = NEWSV(0, output_len * 2 + 1); /* avoid zero! */
            SvPOK_only(RETVAL);
            SvCUR_set(RETVAL, output_len * 2 + 1);
            rdata = SvPVX(RETVAL);
            len = output_len * 2 + 1;
            rv = base16_encode(tmp, output_len, rdata, &len, 0);
            SvCUR_set(RETVAL, len);
            Safefree(tmp);
            if (rv != CRYPT_OK) {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: base16_encode failed");
            }
          }
          else if (ix == 2 || ix == 3) {
            /* BASE64 or BASE64URL */
            Newz(0, tmp, output_len, unsigned char);
            if (tmp == NULL) croak("FATAL: Newz failed");
            rv_len = (self->desc->read)(tmp, (unsigned long)output_len, &self->state);
            if ((UV)rv_len != output_len) croak("FATAL: PRNG_read failed");
            RETVAL = NEWSV(0, output_len * 2); /* avoid zero! */
            SvPOK_only(RETVAL);
            SvCUR_set(RETVAL, output_len * 2);
            rdata = SvPVX(RETVAL);
            len = output_len * 2;
            rv = ix == 3 ? base64url_encode(tmp, output_len, rdata, &len) :
                           base64_encode(tmp, output_len, rdata, &len);
            SvCUR_set(RETVAL, len);
            Safefree(tmp);
            if (rv != CRYPT_OK) {
              SvREFCNT_dec(RETVAL);
              croak(ix == 3 ? "FATAL: base64url_encode failed" : "FATAL: base64_encode failed");
            }
          }
          else {
            /* RAW BYTES */
            RETVAL = NEWSV(0, output_len); /* avoid zero! */
            SvPOK_only(RETVAL);
            SvCUR_set(RETVAL, output_len);
            rdata = SvPVX(RETVAL);
            rv_len = (self->desc->read)((unsigned char*)rdata, (unsigned long)output_len, &self->state);
            if ((UV)rv_len != output_len) {
              SvREFCNT_dec(RETVAL);
              croak("FATAL: PRNG_read failed");
            }
          }
        }
    }
#line 11136 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PRNG_int32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PRNG_int32)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	UV	RETVAL;
	dXSTARG;
	Crypt__PRNG	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PRNG")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PRNG,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PRNG::int32",
			"self", "Crypt::PRNG",
			refstr, ST(0)
		);
	}
;
#line 181 "./inc/CryptX_PRNG.xs.inc"
    {
        IV curpid = (IV)PerlProc_getpid();
        int i;
        unsigned char rdata[4];
        unsigned char entropy_buf[40];

        if (self->last_pid != curpid) {
          if (rng_get_bytes(entropy_buf, 40, NULL) != 40) croak("FATAL: rng_get_bytes failed");
          self->desc->add_entropy(entropy_buf, 40, &self->state);
          self->desc->ready(&self->state);
          self->last_pid = curpid;
        }

        i = (self->desc->read)(rdata, 4, &self->state);
        if (i != 4) croak("FATAL: PRNG_read failed");
        RETVAL = ((UV)(rdata[0])<<24) + ((UV)(rdata[1])<<16) + ((UV)(rdata[2])<<8) + ((UV)(rdata[3]));
    }
#line 11186 "CryptX.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PRNG_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PRNG_double)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, limit_sv= NULL");
    {
	NV	RETVAL;
	dXSTARG;
	Crypt__PRNG	self;
	SV *	limit_sv;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PRNG")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PRNG,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PRNG::double",
			"self", "Crypt::PRNG",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    limit_sv = NULL;
	else {
	    limit_sv = ST(1)
;
	}
#line 204 "./inc/CryptX_PRNG.xs.inc"
    {
        IV curpid = (IV)PerlProc_getpid();
        int i;
        unsigned long a, b;     /* 32bit is enough */
        unsigned char rdata[7]; /* for double we need 53 bits */
        unsigned char entropy_buf[40];

        if (self->last_pid != curpid) {
          if (rng_get_bytes(entropy_buf, 40, NULL) != 40) croak("FATAL: rng_get_bytes failed");
          self->desc->add_entropy(entropy_buf, 40, &self->state);
          self->desc->ready(&self->state);
          self->last_pid = curpid;
        }

        i = (self->desc->read)(rdata, 7, &self->state);
        if (i != 7) croak("FATAL: PRNG_read failed");
        a = (((unsigned long)(rdata[0])<<16) + ((unsigned long)(rdata[1])<<8) + ((unsigned long)(rdata[2]))) & 0x1FFFFF;                      /* 21 bits */
        b = ((unsigned long)(rdata[3])<<24) + ((unsigned long)(rdata[4])<<16) + ((unsigned long)(rdata[5])<<8) + ((unsigned long)(rdata[6])); /* 32 bits */
        RETVAL = ( (NV)a * 4294967296.0 + (NV)b ) / 9007199254740992.0;                           /* (a * 2^32 + b) / 2^53 */
        if (limit_sv && SvOK(limit_sv)) {
          NV limit = SvNV(limit_sv);
          if (limit > 0 || limit < 0) RETVAL = RETVAL * limit;
        }
    }
#line 11251 "CryptX.c"
	XSprePUSH;
	PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_PRNG.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_PK_RSA.xs.inc' from 'CryptX.xs' */


/* INCLUDE:  Including 'inc/CryptX_PK_DSA.xs.inc' from 'inc/CryptX_PK_RSA.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_PK_DH.xs.inc' from 'inc/CryptX_PK_DSA.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_PK_ECC.xs.inc' from 'inc/CryptX_PK_DH.xs.inc' */


XS_EUPXS(XS_Crypt__PK__ECC__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC__new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
	Crypt__PK__ECC	RETVAL;
#line 8 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        Newz(0, RETVAL, 1, struct ecc_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->pindex = find_prng("chacha20");
        RETVAL->key.type = -1;
        if (RETVAL->pindex == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_prng('chacha20') failed");
        }
        rv = rng_make_prng(320, RETVAL->pindex, &RETVAL->pstate, NULL); /* 320bits = 40bytes */
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: rng_make_prng failed: %s", error_to_string(rv));
        }
    }
#line 11299 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::PK::ECC", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_generate_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_generate_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, curve");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__ECC	self;
	SV *	curve = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::generate_key",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 30 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        /* setup dp structure */
        rv = _ecc_set_curve_from_SV(&self->key, curve); /* croaks on error */
        if (rv != CRYPT_OK) croak("FATAL: ecc_set_curve failed: %s", error_to_string(rv));
        /* gen the key */
        rv = ecc_generate_key(&self->pstate, self->pindex, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_generate_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 11348 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__ECC__import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC__import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__ECC	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::_import",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 44 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { ecc_free(&self->key); self->key.type = -1; }
        rv = ecc_import_openssl(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_import_openssl failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 11393 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__ECC__import_old); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC__import_old)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__ECC	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::_import_old",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 59 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { ecc_free(&self->key); self->key.type = -1; }
        rv = ecc_import(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_import failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 11438 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__ECC__import_pkcs8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC__import_pkcs8)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, key_data, passwd");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__ECC	self;
	SV *	key_data = ST(1)
;
	SV *	passwd = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::_import_pkcs8",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 74 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char *data=NULL, *pwd=NULL;
        STRLEN data_len=0, pwd_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (SvOK(passwd)) {
          pwd = (unsigned char *)SvPVbyte(passwd, pwd_len);
        }
        if (self->key.type != -1) { ecc_free(&self->key); self->key.type = -1; }
        rv = ecc_import_pkcs8(data, (unsigned long)data_len, pwd, (unsigned long)pwd_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_import_pkcs8 failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 11488 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__ECC__import_x509); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC__import_x509)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__ECC	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::_import_x509",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 92 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { ecc_free(&self->key); self->key.type = -1; }
        rv = ecc_import_x509(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_import_x509 failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 11533 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__ECC_import_key_raw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_import_key_raw)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, key_data, curve");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__ECC	self;
	SV *	key_data = ST(1)
;
	SV *	curve = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::import_key_raw",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 107 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv, type;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { ecc_free(&self->key); self->key.type = -1; }
        /* setup dp structure */
        rv = _ecc_set_curve_from_SV(&self->key, curve); /* croaks on error */
        if (rv != CRYPT_OK) croak("FATAL: ecc_set_curve failed: %s", error_to_string(rv));
        /* import key */
        type = (data_len == (STRLEN)ecc_get_size(&self->key)) ? PK_PRIVATE : PK_PUBLIC;
        rv = ecc_set_key(data, (unsigned long)data_len, type, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_set_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 11585 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__ECC_is_private); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_is_private)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__ECC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::is_private",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 127 "./inc/CryptX_PK_ECC.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        RETVAL = (self->key.type == PK_PRIVATE) ? 1 : 0;
#line 11619 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__ECC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::size",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 135 "./inc/CryptX_PK_ECC.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        RETVAL = ecc_get_size(&self->key);
#line 11654 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_key2hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_key2hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 143 "./inc/CryptX_PK_ECC.xs.inc"
        HV *rv_hash;
        long siz, esize;
        char buf[20001];
        SV **not_used;
#line 11674 "CryptX.c"
	SV *	RETVAL;
	Crypt__PK__ECC	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::key2hash",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 148 "./inc/CryptX_PK_ECC.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        esize = ecc_get_size(&self->key);
        rv_hash = newHV();
        /* k */
        siz = (self->key.k) ? mp_unsigned_bin_size(self->key.k) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'k' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.k, buf, 20000, esize*2);
          not_used = hv_store(rv_hash, "k", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "k", 1, newSVpv("", 0), 0);
        }
        /* pub_x */
        siz = (self->key.pubkey.x) ? mp_unsigned_bin_size(self->key.pubkey.x) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'pub_x' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.pubkey.x, buf, 20000, esize*2);
          not_used = hv_store(rv_hash, "pub_x", 5, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "pub_x", 5, newSVpv("", 0), 0);
        }
        /* pub_y */
        siz = (self->key.pubkey.y) ? mp_unsigned_bin_size(self->key.pubkey.y) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'pub_y' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.pubkey.y, buf, 20000, esize*2);
          not_used = hv_store(rv_hash, "pub_y", 5, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "pub_y", 5, newSVpv("", 0), 0);
        }
        /* curve_... */
        {
          not_used = hv_store(rv_hash, "curve_cofactor",                14, newSViv(self->key.dp.cofactor), 0);
          mp_tohex_with_leading_zero(self->key.dp.prime, buf, 20000, 0);
          not_used = hv_store(rv_hash, "curve_prime",                   11, newSVpv(buf, strlen(buf)), 0);
          mp_tohex_with_leading_zero(self->key.dp.A, buf, 20000, 0);
          not_used = hv_store(rv_hash, "curve_A",                        7, newSVpv(buf, strlen(buf)), 0);
          mp_tohex_with_leading_zero(self->key.dp.B, buf, 20000, 0);
          not_used = hv_store(rv_hash, "curve_B",                        7, newSVpv(buf, strlen(buf)), 0);
          mp_tohex_with_leading_zero(self->key.dp.order, buf, 20000, 0);
          not_used = hv_store(rv_hash, "curve_order",                   11, newSVpv(buf, strlen(buf)), 0);
          mp_tohex_with_leading_zero(self->key.dp.base.x, buf, 20000, 0);
          not_used = hv_store(rv_hash, "curve_Gx",                       8, newSVpv(buf, strlen(buf)), 0);
          mp_tohex_with_leading_zero(self->key.dp.base.y, buf, 20000, 0);
          not_used = hv_store(rv_hash, "curve_Gy",                       8, newSVpv(buf, strlen(buf)), 0);
          not_used = hv_store(rv_hash, "curve_bytes",                   11, newSViv(mp_unsigned_bin_size(self->key.dp.prime)), 0);
          not_used = hv_store(rv_hash, "curve_bits",                    10, newSViv(mp_count_bits(self->key.dp.prime)), 0);

          if (self->key.dp.oidlen > 0) {
            unsigned long i;
            HV *h;
            SV **pref, *cname;
            char *cname_ptr, *oid_ptr;
            STRLEN cname_len;

            /* OID -> "curve_oid" */
            SV *oid = newSVpv("", 0);
            for(i = 0; i < self->key.dp.oidlen - 1; i++) sv_catpvf(oid, "%lu.", self->key.dp.oid[i]);
            sv_catpvf(oid, "%lu", self->key.dp.oid[i]);
            oid_ptr = SvPVX(oid);
            not_used = hv_store(rv_hash, "curve_oid", 9, oid, 0);

            /* curve name -> "curve_name" */
            if ((h = get_hv("Crypt::PK::ECC::curve_oid2name", 0)) != NULL) {
              pref = hv_fetch(h, oid_ptr, (U32)strlen(oid_ptr), 0);
              if (pref) {
                cname_ptr = SvPV(*pref, cname_len);
                cname = newSVpv(cname_ptr, cname_len);
                cname_ptr = SvPVX(cname);
                not_used = hv_store(rv_hash, "curve_name", 10, cname, 0);
              }
            }
          }
        }
        /* size */
        not_used = hv_store(rv_hash, "size", 4, newSViv(esize), 0);
        /* type */
        not_used = hv_store(rv_hash, "type", 4, newSViv(self->key.type), 0);
        LTC_UNUSED_PARAM(not_used);
        RETVAL = newRV_noinc((SV*)rv_hash);
#line 11781 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_export_key_der); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_export_key_der)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, type");
    {
	SV *	RETVAL;
	Crypt__PK__ECC	self;
	char *        type = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::export_key_der",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 243 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char out[4096];
        unsigned long int out_len = 4096;

        if (self->key.type == -1) croak("FATAL: export_key_der no key");
        if (strnEQ(type, "private_short", 16)) {
          rv = ecc_export_openssl(out, &out_len, PK_PRIVATE|PK_CURVEOID, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_export_openssl(PK_PRIVATE|PK_CURVEOID) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "private_compressed", 16)) {
          rv = ecc_export_openssl(out, &out_len, PK_PRIVATE|PK_CURVEOID|PK_COMPRESSED, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_export_openssl(PK_PRIVATE|PK_CURVEOID|PK_COMPRESSED) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "private", 7)) {
          rv = ecc_export_openssl(out, &out_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_export_openssl(PK_PRIVATE) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public_compressed", 15)) {
          rv = ecc_export_openssl(out, &out_len, PK_PUBLIC|PK_CURVEOID|PK_COMPRESSED, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_export_openssl(PK_PUBLIC|PK_CURVEOID|PK_COMPRESSED) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public_short", 15)) {
          rv = ecc_export_openssl(out, &out_len, PK_PUBLIC|PK_CURVEOID, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_export_openssl(PK_PUBLIC|PK_CURVEOID) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public", 6)) {
          rv = ecc_export_openssl(out, &out_len, PK_PUBLIC, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_export_openssl(PK_PUBLIC) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else {
          croak("FATAL: export_key_der invalid type '%s'", type);
        }
    }
#line 11855 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_export_key_raw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_export_key_raw)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, type");
    {
	SV *	RETVAL;
	Crypt__PK__ECC	self;
	char *        type = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::export_key_raw",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 289 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char out[4096];
        unsigned long int out_len = sizeof(out);

        if (self->key.type == -1) croak("FATAL: export_key_der no key");
        if (strnEQ(type, "private", 7)) {
          rv = ecc_get_key(out, &out_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_get_key(private) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public_compressed", 17)) {
          rv = ecc_get_key(out, &out_len, PK_PUBLIC|PK_COMPRESSED, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_get_key(public_compressed) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public", 6)) {
          rv = ecc_get_key(out, &out_len, PK_PUBLIC, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: ecc_get_key(public) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else {
          croak("FATAL: export_key_raw invalid type '%s'", type);
        }
    }
#line 11914 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_encrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_encrypt)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, data, hash_name= \"SHA1\"");
    {
	SV *	RETVAL;
	Crypt__PK__ECC	self;
	SV *	data = ST(1)
;
	const char *	hash_name;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::encrypt",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}
#line 320 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv, hash_id;
        unsigned char *data_ptr=NULL;
        STRLEN data_len=0;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);

        hash_id = _find_hash(hash_name);
        if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
        rv = ecc_encrypt_key(data_ptr, (unsigned long)data_len, buffer, &buffer_len,
                             &self->pstate, self->pindex,
                             hash_id, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_encrypt_key failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 11973 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_decrypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__PK__ECC	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::decrypt",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;
#line 343 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char *data_ptr=NULL;
        STRLEN data_len=0;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);

        rv = ecc_decrypt_key(data_ptr, (unsigned long)data_len, buffer, &buffer_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: ecc_decrypt_key_ex failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 12020 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_sign_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_sign_hash)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, data, hash_name= \"SHA1\"");
    {
	SV *	RETVAL;
	Crypt__PK__ECC	self;
	SV *	data = ST(1)
;
	const char *	hash_name;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}
#line 366 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv, id;
        unsigned char buffer[1024], tmp[MAXBLOCKSIZE], *data_ptr = NULL;
        unsigned long tmp_len = MAXBLOCKSIZE, buffer_len = 1024;
        STRLEN data_len = 0;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);
        if (ix == 1 || ix == 2) {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = hash_memory(id, data_ptr, (unsigned long)data_len, tmp, &tmp_len);
          if (rv != CRYPT_OK) croak("FATAL: hash_memory failed: %s", error_to_string(rv));
          data_ptr = tmp;
          data_len = tmp_len;
        }
        if (ix == 2 || ix == 3) {
          rv = ecc_sign_hash_rfc7518(data_ptr, (unsigned long)data_len, buffer, &buffer_len,
                             &self->pstate, self->pindex,
                             &self->key);
        }
        else {
          rv = ecc_sign_hash(data_ptr, (unsigned long)data_len, buffer, &buffer_len,
                             &self->pstate, self->pindex,
                             &self->key);
        }
        if (rv != CRYPT_OK) croak("FATAL: ecc_sign_hash_ex failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 12091 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_verify_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_verify_hash)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "self, sig, data, hash_name= \"SHA1\"");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__ECC	self;
	SV *	sig = ST(1)
;
	SV *	data = ST(2)
;
	const char *	hash_name;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}
#line 404 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv, stat, id;
        unsigned char tmp[MAXBLOCKSIZE], *data_ptr = NULL, *sig_ptr = NULL;
        unsigned long tmp_len = MAXBLOCKSIZE;
        STRLEN data_len = 0, sig_len = 0;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);
        sig_ptr = (unsigned char *)SvPVbyte(sig, sig_len);
        if (ix == 1 || ix == 2) {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = hash_memory(id, data_ptr, (unsigned long)data_len, tmp, &tmp_len);
          if (rv != CRYPT_OK) croak("FATAL: hash_memory failed: %s", error_to_string(rv));
          data_ptr = tmp;
          data_len = tmp_len;
        }
        RETVAL = 1;
        stat = 0;
        if (ix == 2 || ix == 3) {
          rv = ecc_verify_hash_rfc7518(sig_ptr, (unsigned long)sig_len, data_ptr, (unsigned long)data_len, &stat, &self->key);
        }
        else {
          rv = ecc_verify_hash(sig_ptr, (unsigned long)sig_len, data_ptr, (unsigned long)data_len, &stat, &self->key);
        }
        if (rv != CRYPT_OK || stat != 1) RETVAL = 0;
    }
#line 12163 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_shared_secret); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_shared_secret)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pubkey");
    {
	SV *	RETVAL;
	Crypt__PK__ECC	self;
	Crypt__PK__ECC	pubkey;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::shared_secret",
			"self", "Crypt::PK::ECC",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::PK::ECC")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    pubkey = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::ECC::shared_secret",
			"pubkey", "Crypt::PK::ECC",
			refstr, ST(1)
		);
	}
;
#line 436 "./inc/CryptX_PK_ECC.xs.inc"
    {
        int rv;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        rv = ecc_shared_secret(&self->key, &pubkey->key, buffer, &buffer_len);
        if (rv != CRYPT_OK) croak("FATAL: ecc_shared_secret failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 12219 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__ECC_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__ECC_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__PK__ECC	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__ECC,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::PK::ECC::DESTROY",
			"self")
;
#line 451 "./inc/CryptX_PK_ECC.xs.inc"
        if (self->key.type != -1) { ecc_free(&self->key); self->key.type = -1; }
        Safefree(self);
#line 12248 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'inc/CryptX_PK_DH.xs.inc' from 'inc/CryptX_PK_ECC.xs.inc' */


XS_EUPXS(XS_Crypt__PK__DH__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH__new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
	Crypt__PK__DH	RETVAL;
#line 8 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        Newz(0, RETVAL, 1, struct dh_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->key.type = -1;
        RETVAL->pindex = find_prng("chacha20");
        if (RETVAL->pindex == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_prng('chacha20') failed");
        }
        rv = rng_make_prng(320, RETVAL->pindex, &RETVAL->pstate, NULL); /* 320bits = 40bytes */
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: rng_make_prng failed: %s", error_to_string(rv));
        }
    }
#line 12282 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::PK::DH", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH__generate_key_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH__generate_key_size)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, groupsize=256");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DH	self;
	int	groupsize;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::_generate_key_size",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    groupsize = 256;
	else {
	    groupsize = (int)SvIV(ST(1))
;
	}
#line 30 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        rv = dh_set_pg_groupsize(groupsize, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dh_set_pg_groupsize failed: %s", error_to_string(rv));
        rv = dh_generate_key(&self->pstate, self->pindex, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dh_generate_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 12335 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DH__generate_key_gp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH__generate_key_gp)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, g, p");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DH	self;
	char *        g = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	char *        p = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::_generate_key_gp",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned char pbin[1024], gbin[512];
        unsigned long plen=sizeof(pbin), glen=sizeof(gbin);

        if (p && strlen(p) > 0 && g && strlen(g) > 0) {
          rv = radix_to_bin(p, 16, pbin, &plen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(p) failed: %s", error_to_string(rv));
          rv = radix_to_bin(g, 16, gbin, &glen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(g) failed: %s", error_to_string(rv));

          rv = dh_set_pg(pbin, plen, gbin, glen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_set_pg failed: %s", error_to_string(rv));
          rv = dh_generate_key(&self->pstate, self->pindex, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_generate_key failed: %s", error_to_string(rv));
        }

        XPUSHs(ST(0)); /* return self */
    }
#line 12390 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DH__generate_key_dhparam); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH__generate_key_dhparam)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, dhparam");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DH	self;
	SV *	dhparam = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::_generate_key_dhparam",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 65 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;
        data = (unsigned char *)SvPVbyte(dhparam, data_len);
        /* load d p q */
        rv = dh_set_pg_dhparam(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dh_set_pg_dhparam failed: %s", error_to_string(rv));
        /* gen the key */
        rv = dh_generate_key(&self->pstate, self->pindex, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dh_generate_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 12437 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DH__import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH__import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DH	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::_import",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 82 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { dh_free(&self->key); self->key.type = -1; }
        rv = dh_import(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dh_import failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 12482 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DH__import_raw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH__import_raw)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "self, raw_key, type, g, p");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DH	self;
	SV *	raw_key = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	char *        g = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	char *        p = (SvOK(ST(4))) ? SvPV_nolen(ST(4)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::_import_raw",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 97 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;
        unsigned char pbin[1024], gbin[512];
        unsigned long plen=sizeof(pbin), glen=sizeof(gbin);

        data = (unsigned char *)SvPVbyte(raw_key, data_len);
        if (self->key.type != -1) { dh_free(&self->key); self->key.type = -1; }

        if (p && strlen(p) > 0 && g && strlen(g) > 0) {
          rv = radix_to_bin(p, 16, pbin, &plen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(p) failed: %s", error_to_string(rv));
          rv = radix_to_bin(g, 16, gbin, &glen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(g) failed: %s", error_to_string(rv));

          rv = dh_set_pg(pbin, plen, gbin, glen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_set_pg failed: %s", error_to_string(rv));

          if (type == 0) {
            /* public */
            rv = dh_set_key(data, (unsigned long)data_len, PK_PUBLIC, &self->key);
            if (rv != CRYPT_OK) croak("FATAL: dh_set_key failed: %s", error_to_string(rv));
          }
          else if (type == 1) {
            /* private */
            rv = dh_set_key(data, (unsigned long)data_len, PK_PRIVATE, &self->key);
            if (rv != CRYPT_OK) croak("FATAL: dh_set_key failed: %s", error_to_string(rv));
          }
          else {
            croak("FATAL: import_raw invalid type '%d'", type);
          }
        }

        XPUSHs(ST(0)); /* return self */
    }
#line 12558 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DH_is_private); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_is_private)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__DH	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::is_private",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 137 "./inc/CryptX_PK_DH.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        RETVAL = (self->key.type == PK_PRIVATE) ? 1 : 0;
#line 12592 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__DH	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::size",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 145 "./inc/CryptX_PK_DH.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        RETVAL = dh_get_groupsize(&self->key);
#line 12627 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_key2hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_key2hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 153 "./inc/CryptX_PK_DH.xs.inc"
        HV *rv_hash;
        long siz;
        char buf[20001];
        SV **not_used;
#line 12647 "CryptX.c"
	SV *	RETVAL;
	Crypt__PK__DH	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::key2hash",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 158 "./inc/CryptX_PK_DH.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        rv_hash = newHV();
        /* x */
        siz = (self->key.x) ? mp_unsigned_bin_size(self->key.x) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'x' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.x, buf, 20000, 0);
          not_used = hv_store(rv_hash, "x", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "x", 1, newSVpv("", 0), 0);
        }
        /* y */
        siz = (self->key.y) ? mp_unsigned_bin_size(self->key.y) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'y' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.y, buf, 20000, 0);
          not_used = hv_store(rv_hash, "y", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "y", 1, newSVpv("", 0), 0);
        }
        /* p */
        siz = (self->key.prime) ? mp_unsigned_bin_size(self->key.prime) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'p' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.prime, buf, 20000, 0);
          not_used = hv_store(rv_hash, "p", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else {
          not_used = hv_store(rv_hash, "p", 1, newSVpv("", 0), 0);
        }

        /* g */
        siz = (self->key.base) ? mp_unsigned_bin_size(self->key.base) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'g' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.base, buf, 20000, 0);
          not_used = hv_store(rv_hash, "g", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else {
          not_used = hv_store(rv_hash, "g", 1, newSVpv("", 0), 0);
        }
        /* size */
        not_used = hv_store(rv_hash, "size", 4, newSViv(dh_get_groupsize(&self->key)), 0);
        /* type */
        not_used = hv_store(rv_hash, "type", 4, newSViv(self->key.type), 0);
        LTC_UNUSED_PARAM(not_used);
        RETVAL = newRV_noinc((SV*)rv_hash);
#line 12722 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_params2hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_params2hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 221 "./inc/CryptX_PK_DH.xs.inc"
        HV *rv_hash;
        long siz;
        char buf[20001];
        SV **not_used;
#line 12742 "CryptX.c"
	SV *	RETVAL;
	Crypt__PK__DH	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::params2hash",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 226 "./inc/CryptX_PK_DH.xs.inc"
        if (self->key.type == -1) XSRETURN_UNDEF;
        rv_hash = newHV();
        /* p */
        siz = (self->key.prime) ? mp_unsigned_bin_size(self->key.prime) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'p' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.prime, buf, 20000, 0);
          not_used = hv_store(rv_hash, "p", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else {
          not_used = hv_store(rv_hash, "p", 1, newSVpv("", 0), 0);
        }

        /* g */
        siz = (self->key.base) ? mp_unsigned_bin_size(self->key.base) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'g' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.base, buf, 20000, 0);
          not_used = hv_store(rv_hash, "g", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else {
          not_used = hv_store(rv_hash, "g", 1, newSVpv("", 0), 0);
        }
        if (not_used) not_used = NULL; /* just silence the warning: variable 'not_used' set but not used */
        RETVAL = newRV_noinc((SV*)rv_hash);
#line 12789 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_export_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_export_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, type");
    {
	SV *	RETVAL;
	Crypt__PK__DH	self;
	char *        type = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::export_key",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 261 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned long int out_len = 4096;
        unsigned char out[4096];

        RETVAL = newSVpvn(NULL, 0); /* undef */
        if (strnEQ(type, "private", 7)) {
          rv = dh_export(out, &out_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_export(PK_PRIVATE) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public", 6)) {
          rv = dh_export(out, &out_len, PK_PUBLIC, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_export(PK_PUBLIC) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else {
          croak("FATAL: export_key_der invalid type '%s'", type);
        }
    }
#line 12843 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_shared_secret); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_shared_secret)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pubkey");
    {
	SV *	RETVAL;
	Crypt__PK__DH	self;
	Crypt__PK__DH	pubkey;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::shared_secret",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    pubkey = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::shared_secret",
			"pubkey", "Crypt::PK::DH",
			refstr, ST(1)
		);
	}
;
#line 287 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned long buffer_len = 1024;
        unsigned char buffer[1024];

        rv = dh_shared_secret(&self->key, &pubkey->key, buffer, &buffer_len);
        if (rv != CRYPT_OK) croak("FATAL: dh_shared_secret failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 12899 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_export_key_raw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_export_key_raw)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, type");
    {
	SV *	RETVAL;
	Crypt__PK__DH	self;
	char *        type = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DH")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DH::export_key_raw",
			"self", "Crypt::PK::DH",
			refstr, ST(0)
		);
	}
;
#line 302 "./inc/CryptX_PK_DH.xs.inc"
    {
        int rv;
        unsigned char out[1024];
        unsigned long out_len = 1024;

        RETVAL = newSVpvn(NULL, 0); /* undef */
        if (strnEQ(type, "private", 7)) {
          rv = dh_export_key(out, &out_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_export_key(PK_PRIVATE) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public", 6)) {
          rv = dh_export_key(out, &out_len, PK_PUBLIC, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dh_export_key(PK_PUBLIC) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else {
          croak("FATAL: export_key_raw: invalid type '%s'", type);
        }
    }
#line 12953 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DH_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DH_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__PK__DH	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DH,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::PK::DH::DESTROY",
			"self")
;
#line 328 "./inc/CryptX_PK_DH.xs.inc"
        if (self->key.type != -1) { dh_free(&self->key); self->key.type = -1; }
        Safefree(self);
#line 12982 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'inc/CryptX_PK_DSA.xs.inc' from 'inc/CryptX_PK_DH.xs.inc' */


XS_EUPXS(XS_Crypt__PK__DSA__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA__new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
	Crypt__PK__DSA	RETVAL;
#line 8 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        Newz(0, RETVAL, 1, struct dsa_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->key.type = -1;
        RETVAL->pindex = find_prng("chacha20");
        if (RETVAL->pindex == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_prng('chacha20') failed");
        }
        rv = rng_make_prng(320, RETVAL->pindex, &RETVAL->pstate, NULL); /* 320bits = 40bytes */
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: rng_make_prng failed: %s", error_to_string(rv));
        }
    }
#line 13016 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::PK::DSA", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA__generate_key_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA__generate_key_size)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, group_size=30, modulus_size=256");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DSA	self;
	int	group_size;
	int	modulus_size;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::_generate_key_size",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    group_size = 30;
	else {
	    group_size = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    modulus_size = 256;
	else {
	    modulus_size = (int)SvIV(ST(2))
;
	}
#line 30 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        /* gen the key */
        rv = dsa_make_key(&self->pstate, self->pindex, group_size, modulus_size, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_make_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 13076 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DSA__generate_key_dsaparam); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA__generate_key_dsaparam)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, dsaparam");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DSA	self;
	SV *	dsaparam = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::_generate_key_dsaparam",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 41 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;
        data = (unsigned char *)SvPVbyte(dsaparam, data_len);
        /* load d p q */
        rv = dsa_set_pqg_dsaparam(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_set_pqg_dsaparam failed: %s", error_to_string(rv));
        /* gen the key */
        rv = dsa_generate_key(&self->pstate, self->pindex, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_generate_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 13123 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DSA__generate_key_pqg_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA__generate_key_pqg_hex)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, p, q, g");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DSA	self;
	char *        p = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	char *        q = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	char *        g = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::_generate_key_pqg_hex",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 58 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        unsigned char pbin[512], qbin[512], gbin[512];
        unsigned long plen=sizeof(pbin), qlen=sizeof(qbin), glen=sizeof(gbin);
        if (!p || !strlen(p) || !q || !strlen(q) || !g || !strlen(g)) {
          croak("FATAL: generate_key_pqg_hex incomplete args");
        }
        /* set p q g */
        rv = radix_to_bin(p, 16, pbin, &plen);
        if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(p) failed: %s", error_to_string(rv));
        rv = radix_to_bin(q, 16, qbin, &qlen);
        if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(q) failed: %s", error_to_string(rv));
        rv = radix_to_bin(g, 16, gbin, &glen);
        if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(g) failed: %s", error_to_string(rv));
        rv = dsa_set_pqg(pbin, plen, qbin, qlen, gbin, glen, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_set_pqg failed: %s", error_to_string(rv));
        /* gen the key */
        rv = dsa_generate_key(&self->pstate, self->pindex, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_generate_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 13182 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DSA__import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA__import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DSA	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::_import",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 83 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { dsa_free(&self->key); self->key.type = -1; }
        rv = dsa_import(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_import failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 13227 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DSA__import_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA__import_hex)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "self, p, q, g, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__DSA	self;
	char *        p = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	char *        q = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	char *        g = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	char *        x = (SvOK(ST(4))) ? SvPV_nolen(ST(4)) : NULL
;
	char *        y = (SvOK(ST(5))) ? SvPV_nolen(ST(5)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::_import_hex",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 98 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        unsigned char pbin[512], qbin[512], gbin[512], xbin[512], ybin[512];
        unsigned long plen=sizeof(pbin), qlen=sizeof(qbin), glen=sizeof(gbin), xlen=sizeof(xbin), ylen=sizeof(ybin);

        if (self->key.type != -1) { dsa_free(&self->key); self->key.type = -1; }

        if (p && strlen(p) > 0 && q && strlen(q) > 0 && g && strlen(g) > 0 && y && strlen(y) > 0) {
          rv = radix_to_bin(p, 16, pbin, &plen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(p) failed: %s", error_to_string(rv));
          rv = radix_to_bin(q, 16, qbin, &qlen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(q) failed: %s", error_to_string(rv));
          rv = radix_to_bin(g, 16, gbin, &glen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(g) failed: %s", error_to_string(rv));
          rv = dsa_set_pqg(pbin, plen, qbin, qlen, gbin, glen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dsa_set_pqg failed: %s", error_to_string(rv));

          rv = radix_to_bin(y, 16, ybin, &ylen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(y) failed: %s", error_to_string(rv));
          if (x && strlen(x) > 0) {
            /* private */
            rv = radix_to_bin(x, 16, xbin, &xlen);
            if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(x) failed: %s", error_to_string(rv));
            rv = dsa_set_key(xbin, xlen, PK_PRIVATE, &self->key);
            if (rv != CRYPT_OK) croak("FATAL: dsa_set_key failed: %s", error_to_string(rv));
          }
          else {
            /* public */
            rv = dsa_set_key(ybin, ylen, PK_PUBLIC, &self->key);
            if (rv != CRYPT_OK) croak("FATAL: dsa_set_key failed: %s", error_to_string(rv));
          }
        }

        XPUSHs(ST(0)); /* return self */
    }
#line 13304 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__DSA_is_private); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_is_private)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__DSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::is_private",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 137 "./inc/CryptX_PK_DSA.xs.inc"
        if (self->key.type == -1 || self->key.qord <= 0) XSRETURN_UNDEF;
        RETVAL = (self->key.type == PK_PRIVATE) ? 1 : 0;
#line 13338 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__DSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::size",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 145 "./inc/CryptX_PK_DSA.xs.inc"
        if (self->key.type == -1 || self->key.qord <= 0) XSRETURN_UNDEF;
        RETVAL = mp_unsigned_bin_size(self->key.p);
#line 13373 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_size_q); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_size_q)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__DSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::size_q",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 153 "./inc/CryptX_PK_DSA.xs.inc"
        if (self->key.type == -1 || self->key.qord <= 0) XSRETURN_UNDEF;
        RETVAL = mp_unsigned_bin_size(self->key.q);
#line 13408 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_key2hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_key2hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 161 "./inc/CryptX_PK_DSA.xs.inc"
        HV *rv_hash;
        long siz, qsize, psize;
        char buf[20001];
        SV **not_used;
#line 13428 "CryptX.c"
	SV *	RETVAL;
	Crypt__PK__DSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::key2hash",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 166 "./inc/CryptX_PK_DSA.xs.inc"
        if (self->key.type == -1 || self->key.qord <= 0) XSRETURN_UNDEF;
        qsize = mp_unsigned_bin_size(self->key.q);
        psize = mp_unsigned_bin_size(self->key.p);
        rv_hash = newHV();
        /* g */
        siz = (self->key.g) ? mp_unsigned_bin_size(self->key.g) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'g' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.g, buf, 20000, 0);
          not_used = hv_store(rv_hash, "g", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "g", 1, newSVpv("", 0), 0);
        }
        /* q */
        siz = (self->key.q) ? mp_unsigned_bin_size(self->key.q) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'q' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.q, buf, 20000, 0);
          not_used = hv_store(rv_hash, "q", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "q", 1, newSVpv("", 0), 0);
        }
        /* p */
        siz = (self->key.p) ? mp_unsigned_bin_size(self->key.p) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'p' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.p, buf, 20000, 0);
          not_used = hv_store(rv_hash, "p", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "p", 1, newSVpv("", 0), 0);
        }
        /* x */
        siz = (self->key.x) ? mp_unsigned_bin_size(self->key.x) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'x' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.x, buf, 20000, qsize*2);
          not_used = hv_store(rv_hash, "x", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "x", 1, newSVpv("", 0), 0);
        }
        /* y */
        siz = (self->key.y) ? mp_unsigned_bin_size(self->key.y) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'y' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.y, buf, 20000, psize*2);
          not_used = hv_store(rv_hash, "y", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "y", 1, newSVpv("", 0), 0);
        }
        /* size */
        not_used = hv_store(rv_hash, "size", 4, newSViv(qsize), 0);
        /* type */
        not_used = hv_store(rv_hash, "type", 4, newSViv(self->key.type), 0);
        LTC_UNUSED_PARAM(not_used);
        RETVAL = newRV_noinc((SV*)rv_hash);
#line 13516 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_export_key_der); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_export_key_der)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, type");
    {
	SV *	RETVAL;
	Crypt__PK__DSA	self;
	char *        type = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::export_key_der",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 242 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        unsigned char out[4096];
        unsigned long int out_len = 4096;

        RETVAL = newSVpvn(NULL, 0); /* undef */
        if (strnEQ(type, "private", 7)) {
          rv = dsa_export(out, &out_len, PK_PRIVATE|PK_STD, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dsa_export(PK_PRIVATE|PK_STD) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public", 6)) {
          rv = dsa_export(out, &out_len, PK_PUBLIC|PK_STD, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: dsa_export(PK_PUBLIC|PK_STD) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else {
          croak("FATAL: export_key_der invalid type '%s'", type);
        }
    }
#line 13570 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_encrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_encrypt)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, data, hash_name= \"SHA1\"");
    {
	SV *	RETVAL;
	Crypt__PK__DSA	self;
	SV *	data = ST(1)
;
	const char *	hash_name;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::encrypt",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}
#line 268 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv, hash_id;
        unsigned char *data_ptr=NULL;
        STRLEN data_len=0;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);

        hash_id = _find_hash(hash_name);
        if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
        rv = dsa_encrypt_key(data_ptr, (unsigned long)data_len, buffer, &buffer_len,
                             &self->pstate, self->pindex,
                             hash_id, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_encrypt_key failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 13629 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_decrypt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, data");
    {
	SV *	RETVAL;
	Crypt__PK__DSA	self;
	SV *	data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::DSA::decrypt",
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;
#line 291 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv;
        unsigned char *data_ptr=NULL;
        STRLEN data_len=0;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);

        rv = dsa_decrypt_key(data_ptr, (unsigned long)data_len, buffer, &buffer_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_decrypt_key_ex failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 13676 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_sign_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_sign_hash)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, data, hash_name= \"SHA1\"");
    {
	SV *	RETVAL;
	Crypt__PK__DSA	self;
	SV *	data = ST(1)
;
	const char *	hash_name;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}
#line 312 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv, id;
        unsigned char buffer[1024], tmp[MAXBLOCKSIZE], *data_ptr = NULL;
        unsigned long tmp_len = MAXBLOCKSIZE, buffer_len = 1024;
        STRLEN data_len = 0;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);
        if (ix == 1) {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = hash_memory(id, data_ptr, (unsigned long)data_len, tmp, &tmp_len);
          if (rv != CRYPT_OK) croak("FATAL: hash_memory failed: %s", error_to_string(rv));
          data_ptr = tmp;
          data_len = tmp_len;
        }
        rv = dsa_sign_hash(data_ptr, (unsigned long)data_len, buffer, &buffer_len,
                           &self->pstate, self->pindex,
                           &self->key);
        if (rv != CRYPT_OK) croak("FATAL: dsa_sign_hash_ex failed: %s", error_to_string(rv));
        RETVAL = newSVpvn((char*)buffer, buffer_len);
    }
#line 13740 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_verify_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_verify_hash)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "self, sig, data, hash_name= \"SHA1\"");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__DSA	self;
	SV *	sig = ST(1)
;
	SV *	data = ST(2)
;
	const char *	hash_name;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::DSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PK::DSA",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}
#line 341 "./inc/CryptX_PK_DSA.xs.inc"
    {
        int rv, stat, id;
        unsigned char tmp[MAXBLOCKSIZE], *data_ptr = NULL, *sig_ptr = NULL;
        unsigned long tmp_len = MAXBLOCKSIZE;
        STRLEN data_len = 0, sig_len = 0;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);
        sig_ptr = (unsigned char *)SvPVbyte(sig, sig_len);
        if (ix == 1) {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = hash_memory(id, data_ptr, (unsigned long)data_len, tmp, &tmp_len);
          if (rv != CRYPT_OK) croak("FATAL: hash_memory failed: %s", error_to_string(rv));
          data_ptr = tmp;
          data_len = tmp_len;
        }
        RETVAL = 1;
        stat = 0;
        rv = dsa_verify_hash(sig_ptr, (unsigned long)sig_len, data_ptr, (unsigned long)data_len, &stat, &self->key);
        if (rv != CRYPT_OK || stat != 1) RETVAL = 0;
    }
#line 13807 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__DSA_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__DSA_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__PK__DSA	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__DSA,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::PK::DSA::DESTROY",
			"self")
;
#line 368 "./inc/CryptX_PK_DSA.xs.inc"
        if (self->key.type != -1) { dsa_free(&self->key); self->key.type = -1; }
        Safefree(self);
#line 13836 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'inc/CryptX_PK_RSA.xs.inc' from 'inc/CryptX_PK_DSA.xs.inc' */


XS_EUPXS(XS_Crypt__PK__RSA__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA__new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
	Crypt__PK__RSA	RETVAL;
#line 8 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv;
        Newz(0, RETVAL, 1, struct rsa_struct);
        if (!RETVAL) croak("FATAL: Newz failed");
        RETVAL->key.type = -1;
        RETVAL->pindex = find_prng("chacha20");
        if (RETVAL->pindex == -1) {
          Safefree(RETVAL);
          croak("FATAL: find_prng('chacha20') failed");
        }
        rv = rng_make_prng(320, RETVAL->pindex, &RETVAL->pstate, NULL); /* 320bits = 40bytes */
        if (rv != CRYPT_OK) {
          Safefree(RETVAL);
          croak("FATAL: rng_make_prng failed: %s", error_to_string(rv));
        }
    }
#line 13870 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::PK::RSA", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_generate_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_generate_key)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, key_size=256, key_e=65537");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__RSA	self;
	int	key_size;
	long	key_e;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::generate_key",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    key_size = 256;
	else {
	    key_size = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    key_e = 65537;
	else {
	    key_e = (long)SvIV(ST(2))
;
	}
#line 30 "./inc/CryptX_PK_RSA.xs.inc"
    {
        /* key_size is in octets */
        int rv;
        /* gen the key */
        rv = rsa_make_key(&self->pstate, self->pindex, key_size, key_e, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: rsa_make_key failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 13931 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__RSA__import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA__import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__RSA	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::_import",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 42 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { rsa_free(&self->key); self->key.type = -1; }
        rv = rsa_import(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: rsa_import failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 13976 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__RSA__import_pkcs8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA__import_pkcs8)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, key_data, passwd");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__RSA	self;
	SV *	key_data = ST(1)
;
	SV *	passwd = ST(2)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::_import_pkcs8",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 57 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv;
        unsigned char *data=NULL, *pwd=NULL;
        STRLEN data_len=0, pwd_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (SvOK(passwd)) {
          pwd = (unsigned char *)SvPVbyte(passwd, pwd_len);
        }
        if (self->key.type != -1) { rsa_free(&self->key); self->key.type = -1; }
        rv = rsa_import_pkcs8(data, (unsigned long)data_len, pwd, (unsigned long)pwd_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: rsa_import_pkcs8 failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 14026 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__RSA__import_x509); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA__import_x509)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, key_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__RSA	self;
	SV *	key_data = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::_import_x509",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 75 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv;
        unsigned char *data=NULL;
        STRLEN data_len=0;

        data = (unsigned char *)SvPVbyte(key_data, data_len);
        if (self->key.type != -1) { rsa_free(&self->key); self->key.type = -1; }
        rv = rsa_import_x509(data, (unsigned long)data_len, &self->key);
        if (rv != CRYPT_OK) croak("FATAL: rsa_import_x509 failed: %s", error_to_string(rv));
        XPUSHs(ST(0)); /* return self */
    }
#line 14071 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__RSA__import_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA__import_hex)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 9)
       croak_xs_usage(cv,  "self, N, e, d=NULL, p=NULL, q=NULL, dP=NULL, dQ=NULL, qP=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__PK__RSA	self;
	char *        N = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	char *        e = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	char *	d;
	char *	p;
	char *	q;
	char *	dP;
	char *	dQ;
	char *	qP;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::_import_hex",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    d = NULL;
	else {
	d = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    p = NULL;
	else {
	p = (SvOK(ST(4))) ? SvPV_nolen(ST(4)) : NULL
;
	}

	if (items < 6)
	    q = NULL;
	else {
	q = (SvOK(ST(5))) ? SvPV_nolen(ST(5)) : NULL
;
	}

	if (items < 7)
	    dP = NULL;
	else {
	dP = (SvOK(ST(6))) ? SvPV_nolen(ST(6)) : NULL
;
	}

	if (items < 8)
	    dQ = NULL;
	else {
	dQ = (SvOK(ST(7))) ? SvPV_nolen(ST(7)) : NULL
;
	}

	if (items < 9)
	    qP = NULL;
	else {
	qP = (SvOK(ST(8))) ? SvPV_nolen(ST(8)) : NULL
;
	}
#line 90 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv;
        unsigned char Nbin[1024], ebin[128], dbin[1024], pbin[512], qbin[512], dPbin[512], dQbin[512], qPbin[512];
        unsigned long Nlen=sizeof(Nbin), elen=sizeof(ebin), dlen=sizeof(dbin), plen=sizeof(pbin),
                      qlen=sizeof(qbin), dPlen=sizeof(dPbin), dQlen=sizeof(dQbin), qPlen=sizeof(qPbin);

        rv = radix_to_bin(N,  16,  Nbin,  &Nlen);
        if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(N) failed: %s", error_to_string(rv));
        rv = radix_to_bin(e,  16,  ebin,  &elen);
        if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(e) failed: %s", error_to_string(rv));

        if (d && strlen(d) > 0) {
          /* private */
          rv = radix_to_bin(d,  16,  dbin,  &dlen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(d) failed: %s", error_to_string(rv));
          rv = rsa_set_key(Nbin, Nlen, ebin, elen, dbin, dlen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_set_key failed: %s", error_to_string(rv));
        }
        else {
          /* public */
          rv = rsa_set_key(Nbin, Nlen, ebin, elen, NULL, 0, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_set_key failed: %s", error_to_string(rv));
        }

        if (p && strlen(p) > 0 && q && strlen(q) > 0) {
          /* private only */
          rv = radix_to_bin(p,  16,  pbin,  &plen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(p) failed: %s", error_to_string(rv));
          rv = radix_to_bin(q,  16,  qbin,  &qlen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(q) failed: %s", error_to_string(rv));
          rv = rsa_set_factors(pbin, plen, qbin, qlen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_set_factors failed: %s", error_to_string(rv));
        }

        if (dP && strlen(dP) > 0 && dQ && strlen(dQ) > 0 && qP && strlen(qP) > 0) {
          /* private only */
          rv = radix_to_bin(dP, 16, dPbin, &dPlen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(dP) failed: %s", error_to_string(rv));
          rv = radix_to_bin(dQ, 16, dQbin, &dQlen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(dQ) failed: %s", error_to_string(rv));
          rv = radix_to_bin(qP, 16, qPbin, &qPlen);
          if (rv != CRYPT_OK) croak("FATAL: radix_to_bin(qP) failed: %s", error_to_string(rv));
          rv = rsa_set_crt_params(dPbin, dPlen, dQbin, dQlen, qPbin, qPlen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_set_crt_params failed: %s", error_to_string(rv));
        }

        XPUSHs(ST(0)); /* return self */
    }
#line 14203 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__PK__RSA_is_private); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_is_private)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__RSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::is_private",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 142 "./inc/CryptX_PK_RSA.xs.inc"
        if (self->key.type == -1 || self->key.N == NULL) XSRETURN_UNDEF;
        RETVAL = (self->key.type == PK_PRIVATE) ? 1 : 0;
#line 14237 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__RSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::size",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 150 "./inc/CryptX_PK_RSA.xs.inc"
        if (self->key.type == -1 || self->key.N == NULL) XSRETURN_UNDEF;
        RETVAL = mp_unsigned_bin_size(self->key.N);
#line 14272 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_key2hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_key2hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 158 "./inc/CryptX_PK_RSA.xs.inc"
        HV *rv_hash;
        long siz, nsize;
        char buf[20001];
        SV **not_used;
#line 14292 "CryptX.c"
	SV *	RETVAL;
	Crypt__PK__RSA	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::key2hash",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 163 "./inc/CryptX_PK_RSA.xs.inc"
        if (self->key.type == -1 || self->key.N == NULL) XSRETURN_UNDEF;
        nsize = mp_unsigned_bin_size(self->key.N);
        rv_hash = newHV();
        /* e */
        siz = (self->key.e) ? mp_unsigned_bin_size(self->key.e) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'e' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.e, buf, 20000, 0);
          not_used = hv_store(rv_hash, "e", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "e", 1, newSVpv("", 0), 0);
        }
        /* d */
        siz = (self->key.d) ? mp_unsigned_bin_size(self->key.d) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'd' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.d, buf, 20000, 0);
          not_used = hv_store(rv_hash, "d", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "d", 1, newSVpv("", 0), 0);
        }
        /* N */
        siz = (self->key.N) ? nsize : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'N' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.N, buf, 20000, 0);
          not_used = hv_store(rv_hash, "N", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "N", 1, newSVpv("", 0), 0);
        }
        /* q */
        siz = (self->key.q) ? mp_unsigned_bin_size(self->key.q) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'q' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.q, buf, 20000, 0);
          not_used = hv_store(rv_hash, "q", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "q", 1, newSVpv("", 0), 0);
        }
        /* p */
        siz = (self->key.p) ? mp_unsigned_bin_size(self->key.p) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'p' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.p, buf, 20000, 0);
          not_used = hv_store(rv_hash, "p", 1, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "p", 1, newSVpv("", 0), 0);
        }
        /* qP */
        siz = (self->key.qP) ? mp_unsigned_bin_size(self->key.qP) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'qP' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.qP, buf, 20000, 0);
          not_used = hv_store(rv_hash, "qP", 2, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "qP", 2, newSVpv("", 0), 0);
        }
        /* dP */
        siz = (self->key.dP) ? mp_unsigned_bin_size(self->key.dP) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'dP' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.dP, buf, 20000, 0);
          not_used = hv_store(rv_hash, "dP", 2, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "dP", 2, newSVpv("", 0), 0);
        }
        /* dQ */
        siz = (self->key.dQ) ? mp_unsigned_bin_size(self->key.dQ) : 0;
        if (siz>10000) {
          croak("FATAL: key2hash failed - 'dQ' too big number");
        }
        if (siz>0) {
          mp_tohex_with_leading_zero(self->key.dQ, buf, 20000, 0);
          not_used = hv_store(rv_hash, "dQ", 2, newSVpv(buf, strlen(buf)), 0);
        }
        else{
          not_used = hv_store(rv_hash, "dQ", 2, newSVpv("", 0), 0);
        }
        /* size */
        not_used = hv_store(rv_hash, "size", 4, newSViv(nsize), 0);
        /* type */
        not_used = hv_store(rv_hash, "type", 4, newSViv(self->key.type), 0);
        LTC_UNUSED_PARAM(not_used);
        RETVAL = newRV_noinc((SV*)rv_hash);
#line 14415 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_export_key_der); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_export_key_der)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, type");
    {
	SV *	RETVAL;
	Crypt__PK__RSA	self;
	char *        type = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::export_key_der",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;
#line 274 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv;
        unsigned char out[4096];
        unsigned long out_len = 4096;

        RETVAL = newSVpvn(NULL, 0); /* undef */
        if (strnEQ(type, "private", 7)) {
          rv = rsa_export(out, &out_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_export(PK_PRIVATE) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else if (strnEQ(type, "public", 6)) {
          rv = rsa_export(out, &out_len, PK_PUBLIC|PK_STD, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_export(PK_PUBLIC|PK_STD) failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)out, out_len);
        }
        else {
          croak("FATAL: export_key_der invalid type '%s'", type);
        }
    }
#line 14469 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_encrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_encrypt)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "self, data, padding= \"oaep\", oaep_hash= \"SHA1\", oaep_lparam= NULL");
    {
	SV *	RETVAL;
	Crypt__PK__RSA	self;
	SV *	data = ST(1)
;
	const char *	padding;
	const char *	oaep_hash;
	SV *	oaep_lparam;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::encrypt",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    padding = "oaep";
	else {
	padding = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}

	if (items < 4)
	    oaep_hash = "SHA1";
	else {
	oaep_hash = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    oaep_lparam = NULL;
	else {
	    oaep_lparam = ST(4)
;
	}
#line 300 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv, hash_id;
        unsigned char *lparam_ptr=NULL;
        STRLEN lparam_len=0;
        unsigned char *data_ptr=NULL;
        STRLEN data_len=0;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);

        RETVAL = newSVpvn(NULL, 0); /* undef */
        if (strnEQ(padding, "oaep", 4)) {
          hash_id = _find_hash(oaep_hash);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", oaep_hash);
          if (oaep_lparam) lparam_ptr = (unsigned char *)SvPVbyte(oaep_lparam, lparam_len);
          rv = rsa_encrypt_key_ex(data_ptr, (unsigned long)data_len, buffer, &buffer_len, lparam_ptr, (unsigned long)lparam_len,
                                  &self->pstate, self->pindex,
                                  hash_id, LTC_PKCS_1_OAEP, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_encrypt_key_ex failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else if (strnEQ(padding, "v1.5", 4)) {
          rv = rsa_encrypt_key_ex(data_ptr, (unsigned long)data_len, buffer, &buffer_len, NULL, 0,
                                  &self->pstate, self->pindex,
                                  0, LTC_PKCS_1_V1_5, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_encrypt_key_ex failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else if (strnEQ(padding, "none", 4)) {
          /* raw RSA */
          rv = ltc_mp.rsa_me(data_ptr, (unsigned long)data_len, buffer, &buffer_len, PK_PUBLIC, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_me failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else {
          croak("FATAL: rsa_encrypt invalid padding '%s'", padding);
        }
    }
#line 14566 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_decrypt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_decrypt)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "self, data, padding= \"oaep\", oaep_hash= \"SHA1\", oaep_lparam= NULL");
    {
	SV *	RETVAL;
	Crypt__PK__RSA	self;
	SV *	data = ST(1)
;
	const char *	padding;
	const char *	oaep_hash;
	SV *	oaep_lparam;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::PK::RSA::decrypt",
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    padding = "oaep";
	else {
	padding = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}

	if (items < 4)
	    oaep_hash = "SHA1";
	else {
	oaep_hash = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    oaep_lparam = NULL;
	else {
	    oaep_lparam = ST(4)
;
	}
#line 345 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv, hash_id, stat;
        unsigned char *lparam_ptr=NULL;
        STRLEN lparam_len=0;
        unsigned char *data_ptr=NULL;
        STRLEN data_len=0;
        unsigned char buffer[1024];
        unsigned long buffer_len = 1024;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);

        RETVAL = newSVpvn(NULL, 0); /* undef */
        if (strnEQ(padding, "oaep", 4)) {
          hash_id = _find_hash(oaep_hash);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", oaep_hash);
          if (oaep_lparam) lparam_ptr = (unsigned char *)SvPVbyte(oaep_lparam, lparam_len);
          rv = rsa_decrypt_key_ex(data_ptr, (unsigned long)data_len, buffer, &buffer_len, lparam_ptr, (unsigned long)lparam_len,
                                  hash_id, LTC_PKCS_1_OAEP, &stat, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_decrypt_key_ex failed: %s", error_to_string(rv));
          if (stat != 1) croak("FATAL: rsa_decrypt - not valid OAEP packet");
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else if (strnEQ(padding, "v1.5", 4)) {
          rv = rsa_decrypt_key_ex(data_ptr, (unsigned long)data_len, buffer, &buffer_len, NULL, 0,
                                  0, LTC_PKCS_1_V1_5, &stat, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_decrypt_key_ex failed: %s", error_to_string(rv));
          if (stat != 1) croak("FATAL: rsa_decrypt - invalid");
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else if (strnEQ(padding, "none", 4)) {
          /* raw RSA */
          rv = ltc_mp.rsa_me(data_ptr, (unsigned long)data_len, buffer, &buffer_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_me failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else {
          croak("FATAL: rsa_encrypt invalid padding '%s'", padding);
        }
    }
#line 14663 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_sign_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_sign_hash)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "self, data, hash_name= \"SHA1\", padding= \"pss\", saltlen=12");
    {
	SV *	RETVAL;
	Crypt__PK__RSA	self;
	SV *	data = ST(1)
;
	const char *	hash_name;
	const char *	padding;
	unsigned long	saltlen;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}

	if (items < 4)
	    padding = "pss";
	else {
	padding = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    saltlen = 12;
	else {
	    saltlen = (unsigned long)SvUV(ST(4))
;
	}
#line 392 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv, hash_id;
        unsigned char buffer[1024], tmp[MAXBLOCKSIZE], *data_ptr = NULL;
        unsigned long tmp_len = MAXBLOCKSIZE, buffer_len = 1024;
        STRLEN data_len = 0;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);
        if (ix == 1) {
          hash_id = _find_hash(hash_name);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = hash_memory(hash_id, data_ptr, (unsigned long)data_len, tmp, &tmp_len);
          if (rv != CRYPT_OK) croak("FATAL: hash_memory failed: %s", error_to_string(rv));
          data_ptr = tmp;
          data_len = tmp_len;
        }
        if (strnEQ(padding, "pss", 3)) {
          hash_id = _find_hash(hash_name);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = rsa_sign_hash_ex(data_ptr, (unsigned long)data_len, buffer, &buffer_len, LTC_PKCS_1_PSS,
                                &self->pstate, self->pindex,
                                hash_id, saltlen, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_sign_hash_ex failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else if (strnEQ(padding, "v1.5", 4)) {
          hash_id = _find_hash(hash_name);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = rsa_sign_hash_ex(data_ptr, (unsigned long)data_len, buffer, &buffer_len, LTC_PKCS_1_V1_5,
                                &self->pstate, self->pindex,
                                hash_id, 0, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_sign_hash_ex failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else if (strnEQ(padding, "none", 4)) {
          /* raw RSA */
          rv = ltc_mp.rsa_me(data_ptr, (unsigned long)data_len, buffer, &buffer_len, PK_PRIVATE, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_me failed: %s", error_to_string(rv));
          RETVAL = newSVpvn((char*)buffer, buffer_len);
        }
        else {
          croak("FATAL: rsa_sign invalid padding '%s'", padding);
        }
    }
#line 14765 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_verify_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_verify_hash)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 3 || items > 6)
       croak_xs_usage(cv,  "self, sig, data, hash_name= \"SHA1\", padding= \"pss\", saltlen= 12");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__PK__RSA	self;
	SV *	sig = ST(1)
;
	SV *	data = ST(2)
;
	const char *	hash_name;
	const char *	padding;
	unsigned long	saltlen;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::PK::RSA")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Crypt::PK::RSA",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    hash_name = "SHA1";
	else {
	hash_name = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    padding = "pss";
	else {
	padding = (SvOK(ST(4))) ? SvPV_nolen(ST(4)) : NULL
;
	}

	if (items < 6)
	    saltlen = 12;
	else {
	    saltlen = (unsigned long)SvUV(ST(5))
;
	}
#line 443 "./inc/CryptX_PK_RSA.xs.inc"
    {
        int rv, hash_id, stat;
        unsigned char tmp[MAXBLOCKSIZE], buffer[1024], *data_ptr = NULL, *sig_ptr = NULL;
        unsigned long i, tmp_len = MAXBLOCKSIZE, buffer_len = 1024;
        STRLEN data_len = 0, sig_len = 0;

        data_ptr = (unsigned char *)SvPVbyte(data, data_len);
        sig_ptr = (unsigned char *)SvPVbyte(sig, sig_len);
        if (ix == 1) {
          hash_id = _find_hash(hash_name);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = hash_memory(hash_id, data_ptr, (unsigned long)data_len, tmp, &tmp_len);
          if (rv != CRYPT_OK) croak("FATAL: hash_memory failed: %s", error_to_string(rv));
          data_ptr = tmp;
          data_len = tmp_len;
        }
        RETVAL = 1;
        stat = 0;
        if (strnEQ(padding, "pss", 3)) {
          hash_id = _find_hash(hash_name);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = rsa_verify_hash_ex(sig_ptr, (unsigned long)sig_len, data_ptr, (unsigned long)data_len, LTC_PKCS_1_PSS,
                                hash_id, saltlen, &stat, &self->key);
          if (rv != CRYPT_OK || stat != 1) RETVAL = 0;
        }
        else if (strnEQ(padding, "v1.5", 4)) {
          hash_id = _find_hash(hash_name);
          if (hash_id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);
          rv = rsa_verify_hash_ex(sig_ptr, (unsigned long)sig_len, data_ptr, (unsigned long)data_len, LTC_PKCS_1_V1_5,
                                hash_id, 0, &stat, &self->key);
          if (rv != CRYPT_OK || stat != 1) RETVAL = 0;
        }
        else if (strnEQ(padding, "none", 4)) {
          /* raw RSA */
          Zero(buffer, buffer_len, unsigned char);
          rv = ltc_mp.rsa_me(sig_ptr, (unsigned long)sig_len, buffer, &buffer_len, PK_PUBLIC, &self->key);
          if (rv != CRYPT_OK) croak("FATAL: rsa_me failed: %s", error_to_string(rv));
          if (data_len <= buffer_len && buffer_len > 0 && data_len > 0) {
            for (i = 0; i < buffer_len - data_len; i++) if (buffer[i] != 0) RETVAL = 0;
            if (memNE(data_ptr, buffer + buffer_len - data_len, data_len)) RETVAL = 0;
          }
          else {
            RETVAL = 0;
          }
        }
        else {
          croak("FATAL: rsa_verify invalid padding '%s'", padding);
        }
    }
#line 14876 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__PK__RSA_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__PK__RSA_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__PK__RSA	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__PK__RSA,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::PK::RSA::DESTROY",
			"self")
;
#line 498 "./inc/CryptX_PK_RSA.xs.inc"
        if (self->key.type != -1) { rsa_free(&self->key); self->key.type = -1; }
        Safefree(self);
#line 14905 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_PK_RSA.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_KeyDerivation.xs.inc' from 'CryptX.xs' */


XS_EUPXS(XS_Crypt__KeyDerivation_pbkdf1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__KeyDerivation_pbkdf1)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "password, salt, iteration_count= 5000, hash_name= \"SHA256\", output_len= 32");
    {
	SV *	RETVAL;
	SV *	password = ST(0)
;
	SV *	salt = ST(1)
;
	int	iteration_count;
	const char *	hash_name;
	unsigned long	output_len;

	if (items < 3)
	    iteration_count = 5000;
	else {
	    iteration_count = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    hash_name = "SHA256";
	else {
	hash_name = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    output_len = 32;
	else {
	    output_len = (unsigned long)SvUV(ST(4))
;
	}
#line 8 "./inc/CryptX_KeyDerivation.xs.inc"
    {
        int rv, id;
        unsigned char *output;
        unsigned char *password_ptr=NULL;
        STRLEN password_len=0;
        unsigned char *salt_ptr=NULL;
        STRLEN salt_len=0;

        if (output_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);

          password_ptr = (unsigned char *)SvPVbyte(password, password_len);
          salt_ptr = (unsigned char *)SvPVbyte(salt, salt_len);
          if (salt_len < 8) croak("FATAL: salt_len has to be 8");

          RETVAL = NEWSV(0, output_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, output_len);
          output = (unsigned char *)SvPVX(RETVAL);

          rv = pkcs_5_alg1(password_ptr, (unsigned long)password_len, salt_ptr, iteration_count, id, output, &output_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: pkcs_5_alg1 process failed: %s", error_to_string(rv));
          }
          SvCUR_set(RETVAL, output_len);
        }
    }
#line 14986 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__KeyDerivation_pbkdf2); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__KeyDerivation_pbkdf2)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "password, salt, iteration_count= 5000, hash_name= \"SHA256\", output_len= 32");
    {
	SV *	RETVAL;
	SV *	password = ST(0)
;
	SV *	salt = ST(1)
;
	int	iteration_count;
	const char *	hash_name;
	unsigned long	output_len;

	if (items < 3)
	    iteration_count = 5000;
	else {
	    iteration_count = (int)SvIV(ST(2))
;
	}

	if (items < 4)
	    hash_name = "SHA256";
	else {
	hash_name = (SvOK(ST(3))) ? SvPV_nolen(ST(3)) : NULL
;
	}

	if (items < 5)
	    output_len = 32;
	else {
	    output_len = (unsigned long)SvUV(ST(4))
;
	}
#line 46 "./inc/CryptX_KeyDerivation.xs.inc"
    {
        int rv, id;
        unsigned char *output;
        unsigned char *password_ptr=NULL;
        STRLEN password_len=0;
        unsigned char *salt_ptr=NULL;
        STRLEN salt_len=0;

        if (output_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);

          password_ptr = (unsigned char *)SvPVbyte(password, password_len);
          salt_ptr = (unsigned char *)SvPVbyte(salt, salt_len);

          RETVAL = NEWSV(0, output_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, output_len);
          output = (unsigned char *)SvPVX(RETVAL);

          rv = pkcs_5_alg2(password_ptr, (unsigned long)password_len, salt_ptr, (unsigned long)salt_len, iteration_count, id, output, &output_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: pkcs_5_alg2 process failed: %s", error_to_string(rv));
          }
          SvCUR_set(RETVAL, output_len);
        }
    }
#line 15062 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__KeyDerivation_hkdf_extract); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__KeyDerivation_hkdf_extract)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "in, salt= &PL_sv_undef, hash_name= \"SHA256\"");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
	SV *	salt;
	const char *	hash_name;

	if (items < 2)
	    salt = &PL_sv_undef;
	else {
	    salt = ST(1)
;
	}

	if (items < 3)
	    hash_name = "SHA256";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}
#line 83 "./inc/CryptX_KeyDerivation.xs.inc"
    {
        int rv, id;
        unsigned char output[MAXBLOCKSIZE];
        unsigned long output_len;
        unsigned char *in_ptr = NULL, *salt_ptr = NULL;
        STRLEN in_len = 0, salt_len = 0;

        id = _find_hash(hash_name);
        if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);

        if (SvPOK(in))   in_ptr = (unsigned char *)SvPVbyte(in, in_len);
        if (SvPOK(salt)) salt_ptr = (unsigned char *)SvPVbyte(salt, salt_len);

        output_len = sizeof(output);
        rv = hkdf_extract(id, salt_ptr, (unsigned long)salt_len, in_ptr, (unsigned long)in_len, output, &output_len);
        if (rv != CRYPT_OK) croak("FATAL: hkdf_extract process failed: %s", error_to_string(rv));

        RETVAL = newSVpvn((char *)output, output_len);
    }
#line 15116 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__KeyDerivation_hkdf_expand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__KeyDerivation_hkdf_expand)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 4)
       croak_xs_usage(cv,  "in, hash_name= \"SHA256\", output_len= 32, info= &PL_sv_undef");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
	const char *	hash_name;
	unsigned long	output_len;
	SV *	info;

	if (items < 2)
	    hash_name = "SHA256";
	else {
	hash_name = (SvOK(ST(1))) ? SvPV_nolen(ST(1)) : NULL
;
	}

	if (items < 3)
	    output_len = 32;
	else {
	    output_len = (unsigned long)SvUV(ST(2))
;
	}

	if (items < 4)
	    info = &PL_sv_undef;
	else {
	    info = ST(3)
;
	}
#line 108 "./inc/CryptX_KeyDerivation.xs.inc"
    {
        int rv, id;
        unsigned char *output;
        unsigned char *in_ptr = NULL, *info_ptr = NULL;
        STRLEN in_len = 0, info_len = 0;

        if (output_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);

          if (SvPOK(in))   in_ptr = (unsigned char *)SvPVbyte(in, in_len);
          if (SvPOK(info)) info_ptr = (unsigned char *)SvPVbyte(info, info_len);

          RETVAL = NEWSV(0, output_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, output_len);
          output = (unsigned char *)SvPVX(RETVAL);

          rv = hkdf_expand(id, info_ptr, (unsigned long)info_len, in_ptr, (unsigned long)in_len, output, output_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: hkdf_expand process failed: %s", error_to_string(rv));
          }
          SvCUR_set(RETVAL, output_len);
        }
    }
#line 15188 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__KeyDerivation_hkdf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__KeyDerivation_hkdf)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "in, salt, hash_name= \"SHA256\", output_len= 32, info= &PL_sv_undef");
    {
	SV *	RETVAL;
	SV *	in = ST(0)
;
	SV *	salt = ST(1)
;
	const char *	hash_name;
	unsigned long	output_len;
	SV *	info;

	if (items < 3)
	    hash_name = "SHA256";
	else {
	hash_name = (SvOK(ST(2))) ? SvPV_nolen(ST(2)) : NULL
;
	}

	if (items < 4)
	    output_len = 32;
	else {
	    output_len = (unsigned long)SvUV(ST(3))
;
	}

	if (items < 5)
	    info = &PL_sv_undef;
	else {
	    info = ST(4)
;
	}
#line 143 "./inc/CryptX_KeyDerivation.xs.inc"
    {
        int rv, id;
        unsigned char *output;
        unsigned char *in_ptr = NULL, *info_ptr = NULL, *salt_ptr = NULL;
        STRLEN in_len = 0, info_len = 0, salt_len = 0;

        if (output_len == 0) {
          RETVAL = newSVpvn("", 0);
        }
        else {
          id = _find_hash(hash_name);
          if (id == -1) croak("FATAL: find_hash failed for '%s'", hash_name);

          if (SvPOK(in))   in_ptr   = (unsigned char *)SvPVbyte(in, in_len);
          if (SvPOK(info)) info_ptr = (unsigned char *)SvPVbyte(info, info_len);
          if (SvPOK(salt)) salt_ptr = (unsigned char *)SvPVbyte(salt, salt_len);

          RETVAL = NEWSV(0, output_len); /* avoid zero! */
          SvPOK_only(RETVAL);
          SvCUR_set(RETVAL, output_len);
          output = (unsigned char *)SvPVX(RETVAL);

          rv = hkdf(id, salt_ptr, (unsigned long)salt_len, info_ptr, (unsigned long)info_len, in_ptr, (unsigned long)in_len, output, output_len);
          if (rv != CRYPT_OK) {
            SvREFCNT_dec(RETVAL);
            croak("FATAL: hkdf_expand process failed: %s", error_to_string(rv));
          }
          SvCUR_set(RETVAL, output_len);
        }
    }
#line 15263 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_KeyDerivation.xs.inc' */


/* INCLUDE:  Including 'inc/CryptX_BigInt_LTM.xs.inc' from 'CryptX.xs' */


XS_EUPXS(XS_Math__BigInt__LTM__new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
#line 11 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15286 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	SV *	x = ST(1)
;
#line 13 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
#ifdef BN_MP_SET_INT_C
    if ((SvUOK(x) || SvIOK(x)) && (sizeof(UV) <= sizeof(unsigned long) || SvUV(x) == (unsigned long)SvUV(x))) {
      mp_set_int(RETVAL, (unsigned long)SvUV(x));
    }
#elif IVSIZE == 8
    if (SvUOK(x)) {
      mp_set_u64(RETVAL, (unsigned long long)SvUV(x));
    }
    else if (SvIOK(x)) {
      mp_set_i64(RETVAL, (long long)SvIV(x));
    }
#else
    if (SvUOK(x)) {
      mp_set_u32(RETVAL, (unsigned int)SvUV(x));
    }
    else if (SvIOK(x)) {
      mp_set_i32(RETVAL, (int)SvIV(x));
    }
#endif
    else {
      /* fallback - read the decimal number from string */
      merr = mp_read_radix(RETVAL, SvPV_nolen(x), 10);
    }
    PERL_UNUSED_VAR(merr);
#line 15317 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__from_bin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__from_bin)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
#line 48 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    char *str, *start;
#line 15339 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	SV *	x = ST(1)
;
#line 51 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    str = SvPV_nolen(x);
    start = (strlen(str)>2 && str[0] == '0' && str[1] == 'b') ? str+2 : str;
    merr = mp_read_radix(RETVAL, start, 2);
    PERL_UNUSED_VAR(merr);
#line 15350 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__from_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__from_hex)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
#line 66 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    char *str, *start;
#line 15372 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	SV *	x = ST(1)
;
#line 69 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    str = SvPV_nolen(x);
    start = (strlen(str)>2 && str[0] == '0' && str[1] == 'x') ? str+2 : str;
    merr = mp_read_radix(RETVAL, start, 16);
    PERL_UNUSED_VAR(merr);
#line 15383 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__from_oct); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__from_oct)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
#line 84 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15404 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	SV *	x = ST(1)
;
#line 86 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    merr = mp_read_radix(RETVAL, SvPV_nolen(x), 8);
    PERL_UNUSED_VAR(merr);
#line 15413 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__from_base); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__from_base)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, base");
    {
#line 99 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15434 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	SV *	x = ST(1)
;
	int	base = (int)SvIV(ST(2))
;
#line 101 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    merr = mp_read_radix(RETVAL, SvPV_nolen(x), base);
    PERL_UNUSED_VAR(merr);
#line 15445 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__from_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__from_bytes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
#line 114 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    STRLEN buf_len;
    unsigned char *buf_ptr;
#line 15468 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	SV *	x = ST(1)
;
#line 118 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    buf_ptr = (unsigned char *)SvPVbyte(x, buf_len);
    merr = mp_read_unsigned_bin(RETVAL, buf_ptr, buf_len);
    PERL_UNUSED_VAR(merr);
#line 15478 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__set); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__set)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, n, x");
    {
#line 132 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15499 "CryptX.c"
	Math__BigInt__LTM	n;
	SV *	x = ST(2)
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_set",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 134 "./inc/CryptX_BigInt_LTM.xs.inc"
#ifdef BN_MP_SET_INT_C
    if ((SvUOK(x) || SvIOK(x)) && (sizeof(UV) <= sizeof(unsigned long) || SvUV(x) == (unsigned long)SvUV(x))) {
      mp_set_int(n, (unsigned long)SvIV(x));
    }
#elif IVSIZE == 8
    if (SvUOK(x)) {
      mp_set_u64(n, (unsigned long long)SvUV(x));
    }
    else if (SvIOK(x)) {
      mp_set_i64(n, (long long)SvIV(x));
    }
#else
    if (SvUOK(x)) {
      mp_set_u32(n, (unsigned int)SvUV(x));
    }
    else if (SvIOK(x)) {
      mp_set_i32(n, (int)SvIV(x));
    }
#endif
    else {
      /* fallback - read the decimal number from string */
      merr = mp_read_radix(n, SvPV_nolen(x), 10);
      PERL_UNUSED_VAR(merr);
    }
#line 15542 "CryptX.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Math__BigInt__LTM__zero); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__zero)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
#line 165 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15557 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
#line 167 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    mp_zero(RETVAL);
    PERL_UNUSED_VAR(merr);
#line 15564 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__one); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__one)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
#line 180 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15585 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
#line 182 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
#ifdef BN_MP_SET_INT_C
    mp_set_int(RETVAL, 1);
#else
    mp_set_u32(RETVAL, 1);
#endif
    PERL_UNUSED_VAR(merr);
#line 15596 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__two); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__two)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
#line 199 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15617 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
#line 201 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
#ifdef BN_MP_SET_INT_C
    mp_set_int(RETVAL, 2);
#else
    mp_set_u32(RETVAL, 2);
#endif
    PERL_UNUSED_VAR(merr);
#line 15628 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__ten); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__ten)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "Class");
    {
#line 218 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15649 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
#line 220 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
#ifdef BN_MP_SET_INT_C
    mp_set_int(RETVAL, 10);
#else
    mp_set_u32(RETVAL, 10);
#endif
    PERL_UNUSED_VAR(merr);
#line 15660 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__1ex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__1ex)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
#line 237 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 15681 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	int	x = (int)SvIV(ST(1))
;
#line 239 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
#ifdef BN_MP_SET_INT_C
    mp_set_int(RETVAL, 10);
#else
    mp_set_u32(RETVAL, 10);
#endif
    merr = mp_expt_d(RETVAL, x, RETVAL);
    PERL_UNUSED_VAR(merr);
#line 15695 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "n");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Math__BigInt__LTM	n;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Math::BigInt::LTM::DESTROY",
			"n")
;
#line 257 "./inc/CryptX_BigInt_LTM.xs.inc"
    if (n) {
      mp_clear(n);
      Safefree(n);
    }
#line 15732 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__str); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__str)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 268 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    char *buf;
#line 15750 "CryptX.c"
	SV *	RETVAL;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_str",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 272 "./inc/CryptX_BigInt_LTM.xs.inc"
    if (mp_iszero(n) == MP_YES) {
      RETVAL = newSVpv("0", 0);
    }
    else {
      len = mp_count_bits(n) / 3 + 3; /* decimal_size ~ (binary_size/3 + 1) +1 for sign +1 for NUL-byte */
      Newz(0, buf, len, char);
      merr = mp_toradix_n(n, buf, 10, len);
      RETVAL = newSVpv(buf, 0);
      Safefree(buf);
    }
    PERL_UNUSED_VAR(merr);
#line 15779 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__len); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__len)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 292 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    char *buf;
#line 15798 "CryptX.c"
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_len",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 296 "./inc/CryptX_BigInt_LTM.xs.inc"
    if (mp_iszero(n) == MP_YES) {
      RETVAL = 1;
    }
    else {
      len = mp_count_bits(n) / 3 + 3; /* decimal_size ~ (binary_size/3 + 1) +1 for sign +1 for NUL-byte */
      Newz(0, buf, len, char);
      merr = mp_toradix_n(n, buf, 10, len);
      RETVAL = (int)strlen(buf);
      Safefree(buf);
    }
    PERL_UNUSED_VAR(merr);
#line 15828 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__alen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__alen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 317 "./inc/CryptX_BigInt_LTM.xs.inc"
    int bits;
#line 15845 "CryptX.c"
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_alen",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 319 "./inc/CryptX_BigInt_LTM.xs.inc"
    bits = mp_count_bits(n);
    /* alen = round(bits * log(2) / log(10)) */
    RETVAL = (bits < 5) ? 1 : (int)(bits * 0.301029995663 + 0.499999999999);
    /* less accurate approximation, but without floating-point calculations
       RETVAL = (bits < 5) ? 1 : bits / 4 + bits / 32 + bits / 64 + bits / 256;
       RETVAL = (bits < 5) ? 1 : bits / 4;
    */
#line 15871 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__zeros); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__zeros)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 335 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    char *buf;
#line 15890 "CryptX.c"
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_zeros",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 339 "./inc/CryptX_BigInt_LTM.xs.inc"
    if (mp_iszero(n) == MP_YES) {
      RETVAL = 0; /* '0' has no trailing zeros! */
    }
    else {
      len = mp_count_bits(n) / 3 + 3; /* decimal_size ~ (binary_size/3 + 1) +1 for sign +1 for NUL-byte */
      Newz(0, buf, len, char);
      merr = mp_toradix_n(n, buf, 10, len);
      len = (int)strlen(buf);
      RETVAL = 0;
      while (len > 0) {
        if (buf[len-1] != '0') break;
        RETVAL++;
        len--;
      }
      Safefree(buf);
    }
    PERL_UNUSED_VAR(merr);
#line 15926 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__to_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__to_hex)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 365 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int i, len;
    char *buf;
#line 15945 "CryptX.c"
	SV *	RETVAL;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_to_hex",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 369 "./inc/CryptX_BigInt_LTM.xs.inc"
    len = mp_unsigned_bin_size(n) * 2 + 1;
    RETVAL = newSV(len);
    SvPOK_on(RETVAL);
    buf = SvPVX(RETVAL);
    merr = mp_toradix(n, buf, 16); /* to hex */
    for (i=0; i<len && buf[i]>0; i++) buf[i] = toLOWER(buf[i]);
    SvCUR_set(RETVAL, strlen(buf));
    PERL_UNUSED_VAR(merr);
#line 15971 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__to_bin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__to_bin)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 386 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    char *buf;
#line 15990 "CryptX.c"
	SV *	RETVAL;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_to_bin",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 390 "./inc/CryptX_BigInt_LTM.xs.inc"
    len = mp_unsigned_bin_size(n) * 8 + 1;
    RETVAL = newSV(len);
    SvPOK_on(RETVAL);
    buf = SvPVX(RETVAL);
    merr = mp_toradix(n, buf, 2); /* to binary */
    SvCUR_set(RETVAL, strlen(buf));
    PERL_UNUSED_VAR(merr);
#line 16015 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__to_oct); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__to_oct)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 406 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    char *buf;
#line 16034 "CryptX.c"
	SV *	RETVAL;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_to_oct",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 410 "./inc/CryptX_BigInt_LTM.xs.inc"
    len = mp_unsigned_bin_size(n) * 3 + 1;
    RETVAL = newSV(len);
    SvPOK_on(RETVAL);
    buf = SvPVX(RETVAL);
    merr = mp_toradix(n, buf, 8); /* to octal */
    SvCUR_set(RETVAL, strlen(buf));
    PERL_UNUSED_VAR(merr);
#line 16059 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__to_base); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__to_base)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, n, base");
    {
#line 426 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    char *buf;
#line 16078 "CryptX.c"
	SV *	RETVAL;
	Math__BigInt__LTM	n;
	int	base = (int)SvIV(ST(2))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_to_base",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 430 "./inc/CryptX_BigInt_LTM.xs.inc"
    len = mp_unsigned_bin_size(n) * 8; /* the worst case for base == 2 */
    RETVAL = newSV(len + 1);
    SvPOK_on(RETVAL);
    buf = SvPVX(RETVAL);
    if (len > 0) {
      merr = mp_toradix_n(n, buf, base, len);
      SvCUR_set(RETVAL, strlen(buf));
    }
    else {
      buf[0] = '0';
      SvCUR_set(RETVAL, 1);
    }
    PERL_UNUSED_VAR(merr);
#line 16111 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__to_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__to_bytes)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
#line 455 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int len;
    unsigned char *buf;
#line 16131 "CryptX.c"
	SV *	RETVAL;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 459 "./inc/CryptX_BigInt_LTM.xs.inc"
    PERL_UNUSED_VAR(ix);
    len = mp_unsigned_bin_size(n);
    RETVAL = newSV(len + 1);
    SvPOK_on(RETVAL);
    buf = (unsigned char*)SvPVX(RETVAL);
    if (len > 0) {
      merr = mp_to_unsigned_bin(n, buf);
      SvCUR_set(RETVAL, len);
    }
    else {
      buf[0] = 0;
      SvCUR_set(RETVAL, 1);
    }
    PERL_UNUSED_VAR(merr);
#line 16163 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__modpow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__modpow)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "Class, n, exp, mod");
    {
#line 482 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16180 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	Math__BigInt__LTM	n;
	Math__BigInt__LTM	exp;
	Math__BigInt__LTM	mod;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_modpow",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    exp = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_modpow",
			"exp", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;

	if (SvROK(ST(3)) && sv_derived_from(ST(3), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    mod = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(3)) ? "" : SvOK(ST(3)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_modpow",
			"mod", "Math::BigInt::LTM",
			refstr, ST(3)
		);
	}
;
#line 484 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    if (mp_cmp_d(mod, 1) == MP_EQ) {
      mp_zero(RETVAL);
    }
    else {
      merr = mp_exptmod(n, exp, mod, RETVAL);
    }
    PERL_UNUSED_VAR(merr);
#line 16237 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__modinv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__modinv)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 502 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    int rc;
    SV* s;
    mp_int* RETVAL;
#line 16263 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_modinv",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_modinv",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 507 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    rc = mp_invmod(x, y, RETVAL);
    EXTEND(SP, 2);      /* we return two values */
    if (rc != MP_OKAY) {
      /* Inverse doesn't exist. Return both values undefined. */
      PUSHs(&PL_sv_undef);
      PUSHs(&PL_sv_undef);
    }
    else {
      /* Inverse exists. When the modulus to mp_invert() is positive,
       * the returned value is also positive. */
      PUSHs(sv_2mortal(sv_from_mpi(RETVAL)));
      s = sv_newmortal();
      sv_setpvn(s, "+", 1);
      PUSHs(s);
    }
    PERL_UNUSED_VAR(merr);
#line 16313 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__add)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 532 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16331 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_add",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_add",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 534 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_add(x, y, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 16366 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__inc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__inc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 544 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16384 "CryptX.c"
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_inc",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 546 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_add_d(x, 1, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 16404 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__dec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__dec)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 556 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16422 "CryptX.c"
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_dec",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 558 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_sub_d(x, 1, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 16442 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__sub)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "Class, x, y, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 569 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16460 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_sub",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_sub",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 571 "./inc/CryptX_BigInt_LTM.xs.inc"
    if ( items == 4 && SvTRUE(ST(3)) ) {
      /* y -= x */
      merr = mp_sub(x, y, y);
      XPUSHs(ST(2)); /* y */
    }
    else {
      /* x -= y */
      merr = mp_sub(x, y, x);
      XPUSHs(ST(1)); /* x */
    }
    PERL_UNUSED_VAR(merr);
#line 16503 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__rsft); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__rsft)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "Class, x, y, base_int");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 589 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    mp_int*  BASE;
#line 16522 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;
	unsigned long	base_int = (unsigned long)SvUV(ST(3))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_rsft",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_rsft",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 592 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, BASE, 1, mp_int);
    merr = mp_init(BASE);
#ifdef BN_MP_SET_INT_C
    mp_set_int(BASE, base_int);
#else
    mp_set_ul(BASE, base_int);
#endif
#ifdef BN_MP_GET_LONG_C
    merr = mp_expt_d(BASE, mp_get_long(y), BASE);
#else
    merr = mp_expt_d(BASE, mp_get_ul(y), BASE);
#endif
    merr = mp_div(x, BASE, x, NULL);
    PERL_UNUSED_VAR(merr);
    mp_clear(BASE);
    Safefree(BASE);
    XPUSHs(ST(1)); /* x */
#line 16573 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__lsft); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__lsft)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "Class, x, y, base_int");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 616 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    mp_int*  BASE;
#line 16592 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;
	unsigned long	base_int = (unsigned long)SvUV(ST(3))
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_lsft",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_lsft",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 619 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, BASE, 1, mp_int);
    merr = mp_init(BASE);
#ifdef BN_MP_SET_INT_C
    mp_set_int(BASE, base_int);
#else
    mp_set_ul(BASE, base_int);
#endif
#ifdef BN_MP_GET_LONG_C
    merr = mp_expt_d(BASE, mp_get_long(y), BASE);
#else
    merr = mp_expt_d(BASE, mp_get_ul(y), BASE);
#endif
    merr = mp_mul(x, BASE, x);
    PERL_UNUSED_VAR(merr);
    mp_clear(BASE);
    Safefree(BASE);
    XPUSHs(ST(1)); /* x */
#line 16643 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__mul); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__mul)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 643 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16661 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_mul",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_mul",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 645 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_mul(x, y, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 16696 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__div); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__div)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 655 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    mp_int * rem;
#line 16715 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_div",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_div",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 658 "./inc/CryptX_BigInt_LTM.xs.inc"
    if (GIMME_V == G_ARRAY) {
      Newz(0, rem, 1, mp_int);
      merr = mp_init(rem);
      merr = mp_div(x, y, x, rem);
      EXTEND(SP, 2);
      PUSHs(ST(1)); /* x */
      PUSHs(sv_2mortal(sv_from_mpi(rem)));
    }
    else {
      merr = mp_div(x, y, x, NULL);
      XPUSHs(ST(1)); /* x */
    }
    PERL_UNUSED_VAR(merr);
#line 16760 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__mod); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__mod)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 678 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 16778 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_mod",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_mod",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 680 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_mod(x, y, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 16813 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__acmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__acmp)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, m, n");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	m;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    m = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_acmp",
			"m", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_acmp",
			"n", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 690 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = mp_cmp(m, n);
    if ( RETVAL < 0) RETVAL = -1;
    if ( RETVAL > 0) RETVAL =  1;
#line 16863 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__is_zero); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__is_zero)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_is_zero",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 702 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = (mp_iszero(x) == MP_YES) ? 1 : 0;
#line 16897 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__is_one); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__is_one)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_is_one",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 712 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = (mp_cmp_d(x, 1) == MP_EQ) ? 1 : 0;
#line 16931 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__is_two); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__is_two)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_is_two",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 722 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = (mp_cmp_d(x, 2) == MP_EQ) ? 1 : 0;
#line 16965 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__is_ten); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__is_ten)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_is_ten",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 732 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = (mp_cmp_d(x, 10) == MP_EQ) ? 1 : 0;
#line 16999 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__pow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__pow)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 742 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17018 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_pow",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_pow",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 744 "./inc/CryptX_BigInt_LTM.xs.inc"
#ifdef BN_MP_GET_LONG_C
    merr = mp_expt_d(x, mp_get_long(y), x);
#else
    merr = mp_expt_d(x, mp_get_ul(y), x);
#endif
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17057 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__gcd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__gcd)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    {
#line 758 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17073 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_gcd",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_gcd",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 760 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    merr = mp_gcd(x, y, RETVAL);
    PERL_UNUSED_VAR(merr);
#line 17110 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__and); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__and)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 773 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17133 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_and",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_and",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 775 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_and(x, y, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17168 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__xor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__xor)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 785 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17186 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_xor",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_xor",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 787 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_xor(x, y, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17221 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__or); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__or)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 797 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17239 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_or",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_or",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 799 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_or(x, y, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17274 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__copy)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, m");
    {
#line 809 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17290 "CryptX.c"
	Math__BigInt__LTM	RETVAL;
	Math__BigInt__LTM	m;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    m = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_copy",
			"m", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 811 "./inc/CryptX_BigInt_LTM.xs.inc"
    Newz(0, RETVAL, 1, mp_int);
    merr = mp_init(RETVAL);
    merr = mp_copy(m, RETVAL);
    PERL_UNUSED_VAR(merr);
#line 17312 "CryptX.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Math::BigInt::LTM", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__is_odd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__is_odd)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_is_odd",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 824 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = (mp_isodd(n) == MP_YES) ? 1 : 0;
#line 17350 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__is_even); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__is_even)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, n");
    {
	int	RETVAL;
	dXSTARG;
	Math__BigInt__LTM	n;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_is_even",
			"n", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 834 "./inc/CryptX_BigInt_LTM.xs.inc"
    RETVAL = (mp_iseven(n) == MP_YES || mp_iszero(n) == MP_YES) ? 1 : 0;
#line 17384 "CryptX.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Math__BigInt__LTM__sqrt); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__sqrt)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "Class, x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 844 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17403 "CryptX.c"
	Math__BigInt__LTM	x;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_sqrt",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;
#line 846 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_sqrt(x, x);
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17423 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__root); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__root)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 856 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17441 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_root",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_root",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 858 "./inc/CryptX_BigInt_LTM.xs.inc"
#ifdef BN_MP_GET_LONG_C
    merr = mp_n_root(x, mp_get_long(y), x);
#else
    merr = mp_n_root(x, mp_get_ul(y), x);
#endif
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17480 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM__lcm); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM__lcm)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "Class, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 871 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
#line 17498 "CryptX.c"
	Math__BigInt__LTM	x;
	Math__BigInt__LTM	y;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    x = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_lcm",
			"x", "Math::BigInt::LTM",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    y = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::_lcm",
			"y", "Math::BigInt::LTM",
			refstr, ST(2)
		);
	}
;
#line 873 "./inc/CryptX_BigInt_LTM.xs.inc"
    merr = mp_lcm(x, y, x) ;
    PERL_UNUSED_VAR(merr);
    XPUSHs(ST(1)); /* x */
#line 17533 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM_STORABLE_thaw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM_STORABLE_thaw)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "blank_obj, cloning, serialized, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	blank_obj = ST(0)
;
	SV *	cloning;
	SV *	serialized = ST(2)
;
#line 886 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    SV *target;
    mp_int *mpi;
#line 17558 "CryptX.c"
#line 890 "./inc/CryptX_BigInt_LTM.xs.inc"
    PERL_UNUSED_VAR(cloning);
    if (SvROK(blank_obj) && sv_isa(blank_obj, "Math::BigInt::LTM")) {
        Newz(0, mpi, 1, mp_int);
        merr = mp_init(mpi);
        merr = mp_read_radix(mpi, SvPV_nolen(serialized), 10);
        PERL_UNUSED_VAR(merr);
        target = SvRV(blank_obj);
        SvIV_set(target, PTR2IV(mpi));
        SvIOK_on(target);
        PUSHs(target);
        XSRETURN(1);
    }
    else
        croak("Bad object for Math::BigInt::LTM::STORABLE_thaw call");
#line 17574 "CryptX.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Math__BigInt__LTM_STORABLE_freeze); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Math__BigInt__LTM_STORABLE_freeze)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, cloning = NULL");
    {
	Math__BigInt__LTM	self;
	SV *	cloning;
#line 910 "./inc/CryptX_BigInt_LTM.xs.inc"
    mp_err merr;
    unsigned long len;
    char *buf;
#line 17594 "CryptX.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Math::BigInt::LTM")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Math__BigInt__LTM,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Math::BigInt::LTM::STORABLE_freeze",
			"self", "Math::BigInt::LTM",
			refstr, ST(0)
		);
	}
;
#line 914 "./inc/CryptX_BigInt_LTM.xs.inc"
    PERL_UNUSED_VAR(cloning);
    if (mp_iszero(self) == MP_YES) {
      RETVAL = newSVpv("0", 0);
    }
    else {
      len = mp_count_bits(self) / 3 + 3; /* decimal_size ~ (binary_size/3 + 1) +1 for sign +1 for NUL-byte */
      Newz(0, buf, len, char);
      merr = mp_toradix_n(self, buf, 10, len);
      PERL_UNUSED_VAR(merr);
      RETVAL = newSVpv(buf, 0);
      Safefree(buf);
    }
#line 17623 "CryptX.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'CryptX.xs' from 'inc/CryptX_BigInt_LTM.xs.inc' */

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_CryptX); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_CryptX)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("CryptX::_ltc_build_settings", XS_CryptX__ltc_build_settings);
        newXS_deffile("CryptX::_ltc_mp_name", XS_CryptX__ltc_mp_name);
        newXS_deffile("CryptX::_ltc_mp_bits_per_digit", XS_CryptX__ltc_mp_bits_per_digit);
        newXS_deffile("Crypt::Misc::_radix_to_bin", XS_Crypt__Misc__radix_to_bin);
        newXS_deffile("Crypt::Misc::_bin_to_radix", XS_Crypt__Misc__bin_to_radix);
        cv = newXS_deffile("Crypt::Misc::encode_b64", XS_Crypt__Misc_encode_b64);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Misc::encode_b64u", XS_Crypt__Misc_encode_b64);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Misc::decode_b64", XS_Crypt__Misc_decode_b64);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Misc::decode_b64u", XS_Crypt__Misc_decode_b64);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Misc::encode_b32b", XS_Crypt__Misc_encode_b32r);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Misc::encode_b32c", XS_Crypt__Misc_encode_b32r);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Misc::encode_b32r", XS_Crypt__Misc_encode_b32r);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Misc::encode_b32z", XS_Crypt__Misc_encode_b32r);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Misc::decode_b32b", XS_Crypt__Misc_decode_b32r);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Misc::decode_b32c", XS_Crypt__Misc_decode_b32r);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Misc::decode_b32r", XS_Crypt__Misc_decode_b32r);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Misc::decode_b32z", XS_Crypt__Misc_decode_b32r);
        XSANY.any_i32 = 2;
        newXS_deffile("Crypt::Misc::increment_octets_le", XS_Crypt__Misc_increment_octets_le);
        newXS_deffile("Crypt::Misc::increment_octets_be", XS_Crypt__Misc_increment_octets_be);
        newXS_deffile("Crypt::Cipher::new", XS_Crypt__Cipher_new);
        newXS_deffile("Crypt::Cipher::DESTROY", XS_Crypt__Cipher_DESTROY);
        newXS_deffile("Crypt::Cipher::encrypt", XS_Crypt__Cipher_encrypt);
        newXS_deffile("Crypt::Cipher::decrypt", XS_Crypt__Cipher_decrypt);
        newXS_deffile("Crypt::Cipher::blocksize", XS_Crypt__Cipher_blocksize);
        newXS_deffile("Crypt::Cipher::max_keysize", XS_Crypt__Cipher_max_keysize);
        newXS_deffile("Crypt::Cipher::min_keysize", XS_Crypt__Cipher_min_keysize);
        newXS_deffile("Crypt::Cipher::default_rounds", XS_Crypt__Cipher_default_rounds);
        newXS_deffile("Crypt::Digest::SHAKE::new", XS_Crypt__Digest__SHAKE_new);
        newXS_deffile("Crypt::Digest::SHAKE::DESTROY", XS_Crypt__Digest__SHAKE_DESTROY);
        newXS_deffile("Crypt::Digest::SHAKE::reset", XS_Crypt__Digest__SHAKE_reset);
        newXS_deffile("Crypt::Digest::SHAKE::clone", XS_Crypt__Digest__SHAKE_clone);
        newXS_deffile("Crypt::Digest::SHAKE::add", XS_Crypt__Digest__SHAKE_add);
        newXS_deffile("Crypt::Digest::SHAKE::done", XS_Crypt__Digest__SHAKE_done);
        newXS_deffile("Crypt::Digest::new", XS_Crypt__Digest_new);
        newXS_deffile("Crypt::Digest::DESTROY", XS_Crypt__Digest_DESTROY);
        newXS_deffile("Crypt::Digest::reset", XS_Crypt__Digest_reset);
        newXS_deffile("Crypt::Digest::clone", XS_Crypt__Digest_clone);
        newXS_deffile("Crypt::Digest::add", XS_Crypt__Digest_add);
        cv = newXS_deffile("Crypt::Digest::b64digest", XS_Crypt__Digest_digest);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Digest::b64udigest", XS_Crypt__Digest_digest);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Digest::digest", XS_Crypt__Digest_digest);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Digest::hexdigest", XS_Crypt__Digest_digest);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Digest::digest_data", XS_Crypt__Digest_digest_data);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Digest::digest_data_b64", XS_Crypt__Digest_digest_data);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Digest::digest_data_b64u", XS_Crypt__Digest_digest_data);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Digest::digest_data_hex", XS_Crypt__Digest_digest_data);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Digest::hashsize", XS_Crypt__Digest_hashsize);
        newXS_deffile("Crypt::Checksum::CRC32::new", XS_Crypt__Checksum__CRC32_new);
        newXS_deffile("Crypt::Checksum::CRC32::DESTROY", XS_Crypt__Checksum__CRC32_DESTROY);
        newXS_deffile("Crypt::Checksum::CRC32::reset", XS_Crypt__Checksum__CRC32_reset);
        newXS_deffile("Crypt::Checksum::CRC32::clone", XS_Crypt__Checksum__CRC32_clone);
        newXS_deffile("Crypt::Checksum::CRC32::add", XS_Crypt__Checksum__CRC32_add);
        cv = newXS_deffile("Crypt::Checksum::CRC32::digest", XS_Crypt__Checksum__CRC32_digest);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Checksum::CRC32::hexdigest", XS_Crypt__Checksum__CRC32_digest);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Checksum::CRC32::intdigest", XS_Crypt__Checksum__CRC32_digest);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Checksum::CRC32::crc32_data", XS_Crypt__Checksum__CRC32_crc32_data);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Checksum::CRC32::crc32_data_hex", XS_Crypt__Checksum__CRC32_crc32_data);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Checksum::CRC32::crc32_data_int", XS_Crypt__Checksum__CRC32_crc32_data);
        XSANY.any_i32 = 2;
        newXS_deffile("Crypt::Checksum::Adler32::new", XS_Crypt__Checksum__Adler32_new);
        newXS_deffile("Crypt::Checksum::Adler32::DESTROY", XS_Crypt__Checksum__Adler32_DESTROY);
        newXS_deffile("Crypt::Checksum::Adler32::reset", XS_Crypt__Checksum__Adler32_reset);
        newXS_deffile("Crypt::Checksum::Adler32::clone", XS_Crypt__Checksum__Adler32_clone);
        newXS_deffile("Crypt::Checksum::Adler32::add", XS_Crypt__Checksum__Adler32_add);
        cv = newXS_deffile("Crypt::Checksum::Adler32::digest", XS_Crypt__Checksum__Adler32_digest);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Checksum::Adler32::hexdigest", XS_Crypt__Checksum__Adler32_digest);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Checksum::Adler32::intdigest", XS_Crypt__Checksum__Adler32_digest);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Checksum::Adler32::adler32_data", XS_Crypt__Checksum__Adler32_adler32_data);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Checksum::Adler32::adler32_data_hex", XS_Crypt__Checksum__Adler32_adler32_data);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Checksum::Adler32::adler32_data_int", XS_Crypt__Checksum__Adler32_adler32_data);
        XSANY.any_i32 = 2;
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::new", XS_Crypt__AuthEnc__ChaCha20Poly1305_new);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::DESTROY", XS_Crypt__AuthEnc__ChaCha20Poly1305_DESTROY);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::clone", XS_Crypt__AuthEnc__ChaCha20Poly1305_clone);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::set_iv", XS_Crypt__AuthEnc__ChaCha20Poly1305_set_iv);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::set_iv_rfc7905", XS_Crypt__AuthEnc__ChaCha20Poly1305_set_iv_rfc7905);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::adata_add", XS_Crypt__AuthEnc__ChaCha20Poly1305_adata_add);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::decrypt_add", XS_Crypt__AuthEnc__ChaCha20Poly1305_decrypt_add);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::encrypt_add", XS_Crypt__AuthEnc__ChaCha20Poly1305_encrypt_add);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::encrypt_done", XS_Crypt__AuthEnc__ChaCha20Poly1305_encrypt_done);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::decrypt_done", XS_Crypt__AuthEnc__ChaCha20Poly1305_decrypt_done);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::chacha20poly1305_encrypt_authenticate", XS_Crypt__AuthEnc__ChaCha20Poly1305_chacha20poly1305_encrypt_authenticate);
        newXS_deffile("Crypt::AuthEnc::ChaCha20Poly1305::chacha20poly1305_decrypt_verify", XS_Crypt__AuthEnc__ChaCha20Poly1305_chacha20poly1305_decrypt_verify);
        newXS_deffile("Crypt::AuthEnc::CCM::new", XS_Crypt__AuthEnc__CCM_new);
        newXS_deffile("Crypt::AuthEnc::CCM::DESTROY", XS_Crypt__AuthEnc__CCM_DESTROY);
        newXS_deffile("Crypt::AuthEnc::CCM::clone", XS_Crypt__AuthEnc__CCM_clone);
        newXS_deffile("Crypt::AuthEnc::CCM::encrypt_add", XS_Crypt__AuthEnc__CCM_encrypt_add);
        newXS_deffile("Crypt::AuthEnc::CCM::decrypt_add", XS_Crypt__AuthEnc__CCM_decrypt_add);
        newXS_deffile("Crypt::AuthEnc::CCM::encrypt_done", XS_Crypt__AuthEnc__CCM_encrypt_done);
        newXS_deffile("Crypt::AuthEnc::CCM::decrypt_done", XS_Crypt__AuthEnc__CCM_decrypt_done);
        newXS_deffile("Crypt::AuthEnc::CCM::ccm_encrypt_authenticate", XS_Crypt__AuthEnc__CCM_ccm_encrypt_authenticate);
        newXS_deffile("Crypt::AuthEnc::CCM::ccm_decrypt_verify", XS_Crypt__AuthEnc__CCM_ccm_decrypt_verify);
        newXS_deffile("Crypt::AuthEnc::OCB::new", XS_Crypt__AuthEnc__OCB_new);
        newXS_deffile("Crypt::AuthEnc::OCB::DESTROY", XS_Crypt__AuthEnc__OCB_DESTROY);
        newXS_deffile("Crypt::AuthEnc::OCB::clone", XS_Crypt__AuthEnc__OCB_clone);
        newXS_deffile("Crypt::AuthEnc::OCB::adata_add", XS_Crypt__AuthEnc__OCB_adata_add);
        newXS_deffile("Crypt::AuthEnc::OCB::encrypt_add", XS_Crypt__AuthEnc__OCB_encrypt_add);
        newXS_deffile("Crypt::AuthEnc::OCB::encrypt_last", XS_Crypt__AuthEnc__OCB_encrypt_last);
        newXS_deffile("Crypt::AuthEnc::OCB::decrypt_add", XS_Crypt__AuthEnc__OCB_decrypt_add);
        newXS_deffile("Crypt::AuthEnc::OCB::decrypt_last", XS_Crypt__AuthEnc__OCB_decrypt_last);
        newXS_deffile("Crypt::AuthEnc::OCB::encrypt_done", XS_Crypt__AuthEnc__OCB_encrypt_done);
        newXS_deffile("Crypt::AuthEnc::OCB::decrypt_done", XS_Crypt__AuthEnc__OCB_decrypt_done);
        newXS_deffile("Crypt::AuthEnc::OCB::ocb_encrypt_authenticate", XS_Crypt__AuthEnc__OCB_ocb_encrypt_authenticate);
        newXS_deffile("Crypt::AuthEnc::OCB::ocb_decrypt_verify", XS_Crypt__AuthEnc__OCB_ocb_decrypt_verify);
        newXS_deffile("Crypt::AuthEnc::GCM::new", XS_Crypt__AuthEnc__GCM_new);
        newXS_deffile("Crypt::AuthEnc::GCM::DESTROY", XS_Crypt__AuthEnc__GCM_DESTROY);
        newXS_deffile("Crypt::AuthEnc::GCM::clone", XS_Crypt__AuthEnc__GCM_clone);
        newXS_deffile("Crypt::AuthEnc::GCM::reset", XS_Crypt__AuthEnc__GCM_reset);
        newXS_deffile("Crypt::AuthEnc::GCM::encrypt_add", XS_Crypt__AuthEnc__GCM_encrypt_add);
        newXS_deffile("Crypt::AuthEnc::GCM::iv_add", XS_Crypt__AuthEnc__GCM_iv_add);
        newXS_deffile("Crypt::AuthEnc::GCM::adata_add", XS_Crypt__AuthEnc__GCM_adata_add);
        newXS_deffile("Crypt::AuthEnc::GCM::decrypt_add", XS_Crypt__AuthEnc__GCM_decrypt_add);
        newXS_deffile("Crypt::AuthEnc::GCM::encrypt_done", XS_Crypt__AuthEnc__GCM_encrypt_done);
        newXS_deffile("Crypt::AuthEnc::GCM::decrypt_done", XS_Crypt__AuthEnc__GCM_decrypt_done);
        newXS_deffile("Crypt::AuthEnc::GCM::gcm_encrypt_authenticate", XS_Crypt__AuthEnc__GCM_gcm_encrypt_authenticate);
        newXS_deffile("Crypt::AuthEnc::GCM::gcm_decrypt_verify", XS_Crypt__AuthEnc__GCM_gcm_decrypt_verify);
        newXS_deffile("Crypt::AuthEnc::EAX::new", XS_Crypt__AuthEnc__EAX_new);
        newXS_deffile("Crypt::AuthEnc::EAX::DESTROY", XS_Crypt__AuthEnc__EAX_DESTROY);
        newXS_deffile("Crypt::AuthEnc::EAX::clone", XS_Crypt__AuthEnc__EAX_clone);
        newXS_deffile("Crypt::AuthEnc::EAX::encrypt_add", XS_Crypt__AuthEnc__EAX_encrypt_add);
        newXS_deffile("Crypt::AuthEnc::EAX::decrypt_add", XS_Crypt__AuthEnc__EAX_decrypt_add);
        newXS_deffile("Crypt::AuthEnc::EAX::encrypt_done", XS_Crypt__AuthEnc__EAX_encrypt_done);
        newXS_deffile("Crypt::AuthEnc::EAX::decrypt_done", XS_Crypt__AuthEnc__EAX_decrypt_done);
        newXS_deffile("Crypt::AuthEnc::EAX::adata_add", XS_Crypt__AuthEnc__EAX_adata_add);
        newXS_deffile("Crypt::AuthEnc::EAX::eax_encrypt_authenticate", XS_Crypt__AuthEnc__EAX_eax_encrypt_authenticate);
        newXS_deffile("Crypt::AuthEnc::EAX::eax_decrypt_verify", XS_Crypt__AuthEnc__EAX_eax_decrypt_verify);
        newXS_deffile("Crypt::Stream::Rabbit::new", XS_Crypt__Stream__Rabbit_new);
        newXS_deffile("Crypt::Stream::Rabbit::DESTROY", XS_Crypt__Stream__Rabbit_DESTROY);
        newXS_deffile("Crypt::Stream::Rabbit::clone", XS_Crypt__Stream__Rabbit_clone);
        newXS_deffile("Crypt::Stream::Rabbit::keystream", XS_Crypt__Stream__Rabbit_keystream);
        newXS_deffile("Crypt::Stream::Rabbit::crypt", XS_Crypt__Stream__Rabbit_crypt);
        newXS_deffile("Crypt::Stream::Sosemanuk::new", XS_Crypt__Stream__Sosemanuk_new);
        newXS_deffile("Crypt::Stream::Sosemanuk::DESTROY", XS_Crypt__Stream__Sosemanuk_DESTROY);
        newXS_deffile("Crypt::Stream::Sosemanuk::clone", XS_Crypt__Stream__Sosemanuk_clone);
        newXS_deffile("Crypt::Stream::Sosemanuk::keystream", XS_Crypt__Stream__Sosemanuk_keystream);
        newXS_deffile("Crypt::Stream::Sosemanuk::crypt", XS_Crypt__Stream__Sosemanuk_crypt);
        newXS_deffile("Crypt::Stream::Sober128::new", XS_Crypt__Stream__Sober128_new);
        newXS_deffile("Crypt::Stream::Sober128::DESTROY", XS_Crypt__Stream__Sober128_DESTROY);
        newXS_deffile("Crypt::Stream::Sober128::clone", XS_Crypt__Stream__Sober128_clone);
        newXS_deffile("Crypt::Stream::Sober128::keystream", XS_Crypt__Stream__Sober128_keystream);
        newXS_deffile("Crypt::Stream::Sober128::crypt", XS_Crypt__Stream__Sober128_crypt);
        newXS_deffile("Crypt::Stream::RC4::new", XS_Crypt__Stream__RC4_new);
        newXS_deffile("Crypt::Stream::RC4::DESTROY", XS_Crypt__Stream__RC4_DESTROY);
        newXS_deffile("Crypt::Stream::RC4::clone", XS_Crypt__Stream__RC4_clone);
        newXS_deffile("Crypt::Stream::RC4::keystream", XS_Crypt__Stream__RC4_keystream);
        newXS_deffile("Crypt::Stream::RC4::crypt", XS_Crypt__Stream__RC4_crypt);
        newXS_deffile("Crypt::Stream::Salsa20::new", XS_Crypt__Stream__Salsa20_new);
        newXS_deffile("Crypt::Stream::Salsa20::DESTROY", XS_Crypt__Stream__Salsa20_DESTROY);
        newXS_deffile("Crypt::Stream::Salsa20::clone", XS_Crypt__Stream__Salsa20_clone);
        newXS_deffile("Crypt::Stream::Salsa20::keystream", XS_Crypt__Stream__Salsa20_keystream);
        newXS_deffile("Crypt::Stream::Salsa20::crypt", XS_Crypt__Stream__Salsa20_crypt);
        newXS_deffile("Crypt::Stream::ChaCha::new", XS_Crypt__Stream__ChaCha_new);
        newXS_deffile("Crypt::Stream::ChaCha::DESTROY", XS_Crypt__Stream__ChaCha_DESTROY);
        newXS_deffile("Crypt::Stream::ChaCha::clone", XS_Crypt__Stream__ChaCha_clone);
        newXS_deffile("Crypt::Stream::ChaCha::keystream", XS_Crypt__Stream__ChaCha_keystream);
        newXS_deffile("Crypt::Stream::ChaCha::crypt", XS_Crypt__Stream__ChaCha_crypt);
        newXS_deffile("Crypt::Mac::BLAKE2b::new", XS_Crypt__Mac__BLAKE2b_new);
        newXS_deffile("Crypt::Mac::BLAKE2b::DESTROY", XS_Crypt__Mac__BLAKE2b_DESTROY);
        newXS_deffile("Crypt::Mac::BLAKE2b::clone", XS_Crypt__Mac__BLAKE2b_clone);
        newXS_deffile("Crypt::Mac::BLAKE2b::add", XS_Crypt__Mac__BLAKE2b_add);
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::b64mac", XS_Crypt__Mac__BLAKE2b_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::b64umac", XS_Crypt__Mac__BLAKE2b_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::hexmac", XS_Crypt__Mac__BLAKE2b_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::mac", XS_Crypt__Mac__BLAKE2b_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::blake2b", XS_Crypt__Mac__BLAKE2b_blake2b);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::blake2b_b64", XS_Crypt__Mac__BLAKE2b_blake2b);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::blake2b_b64u", XS_Crypt__Mac__BLAKE2b_blake2b);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::BLAKE2b::blake2b_hex", XS_Crypt__Mac__BLAKE2b_blake2b);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::BLAKE2s::new", XS_Crypt__Mac__BLAKE2s_new);
        newXS_deffile("Crypt::Mac::BLAKE2s::DESTROY", XS_Crypt__Mac__BLAKE2s_DESTROY);
        newXS_deffile("Crypt::Mac::BLAKE2s::clone", XS_Crypt__Mac__BLAKE2s_clone);
        newXS_deffile("Crypt::Mac::BLAKE2s::add", XS_Crypt__Mac__BLAKE2s_add);
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::b64mac", XS_Crypt__Mac__BLAKE2s_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::b64umac", XS_Crypt__Mac__BLAKE2s_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::hexmac", XS_Crypt__Mac__BLAKE2s_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::mac", XS_Crypt__Mac__BLAKE2s_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::blake2s", XS_Crypt__Mac__BLAKE2s_blake2s);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::blake2s_b64", XS_Crypt__Mac__BLAKE2s_blake2s);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::blake2s_b64u", XS_Crypt__Mac__BLAKE2s_blake2s);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::BLAKE2s::blake2s_hex", XS_Crypt__Mac__BLAKE2s_blake2s);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::Poly1305::new", XS_Crypt__Mac__Poly1305_new);
        newXS_deffile("Crypt::Mac::Poly1305::DESTROY", XS_Crypt__Mac__Poly1305_DESTROY);
        newXS_deffile("Crypt::Mac::Poly1305::clone", XS_Crypt__Mac__Poly1305_clone);
        newXS_deffile("Crypt::Mac::Poly1305::add", XS_Crypt__Mac__Poly1305_add);
        cv = newXS_deffile("Crypt::Mac::Poly1305::b64mac", XS_Crypt__Mac__Poly1305_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::Poly1305::b64umac", XS_Crypt__Mac__Poly1305_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::Poly1305::hexmac", XS_Crypt__Mac__Poly1305_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::Poly1305::mac", XS_Crypt__Mac__Poly1305_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::Poly1305::poly1305", XS_Crypt__Mac__Poly1305_poly1305);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::Poly1305::poly1305_b64", XS_Crypt__Mac__Poly1305_poly1305);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::Poly1305::poly1305_b64u", XS_Crypt__Mac__Poly1305_poly1305);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::Poly1305::poly1305_hex", XS_Crypt__Mac__Poly1305_poly1305);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::XCBC::new", XS_Crypt__Mac__XCBC_new);
        newXS_deffile("Crypt::Mac::XCBC::DESTROY", XS_Crypt__Mac__XCBC_DESTROY);
        newXS_deffile("Crypt::Mac::XCBC::clone", XS_Crypt__Mac__XCBC_clone);
        newXS_deffile("Crypt::Mac::XCBC::add", XS_Crypt__Mac__XCBC_add);
        cv = newXS_deffile("Crypt::Mac::XCBC::b64mac", XS_Crypt__Mac__XCBC_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::XCBC::b64umac", XS_Crypt__Mac__XCBC_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::XCBC::hexmac", XS_Crypt__Mac__XCBC_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::XCBC::mac", XS_Crypt__Mac__XCBC_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::XCBC::xcbc", XS_Crypt__Mac__XCBC_xcbc);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::XCBC::xcbc_b64", XS_Crypt__Mac__XCBC_xcbc);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::XCBC::xcbc_b64u", XS_Crypt__Mac__XCBC_xcbc);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::XCBC::xcbc_hex", XS_Crypt__Mac__XCBC_xcbc);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::PMAC::new", XS_Crypt__Mac__PMAC_new);
        newXS_deffile("Crypt::Mac::PMAC::DESTROY", XS_Crypt__Mac__PMAC_DESTROY);
        newXS_deffile("Crypt::Mac::PMAC::clone", XS_Crypt__Mac__PMAC_clone);
        newXS_deffile("Crypt::Mac::PMAC::add", XS_Crypt__Mac__PMAC_add);
        cv = newXS_deffile("Crypt::Mac::PMAC::b64mac", XS_Crypt__Mac__PMAC_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::PMAC::b64umac", XS_Crypt__Mac__PMAC_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::PMAC::hexmac", XS_Crypt__Mac__PMAC_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::PMAC::mac", XS_Crypt__Mac__PMAC_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::PMAC::pmac", XS_Crypt__Mac__PMAC_pmac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::PMAC::pmac_b64", XS_Crypt__Mac__PMAC_pmac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::PMAC::pmac_b64u", XS_Crypt__Mac__PMAC_pmac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::PMAC::pmac_hex", XS_Crypt__Mac__PMAC_pmac);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::Pelican::new", XS_Crypt__Mac__Pelican_new);
        newXS_deffile("Crypt::Mac::Pelican::DESTROY", XS_Crypt__Mac__Pelican_DESTROY);
        newXS_deffile("Crypt::Mac::Pelican::clone", XS_Crypt__Mac__Pelican_clone);
        newXS_deffile("Crypt::Mac::Pelican::add", XS_Crypt__Mac__Pelican_add);
        cv = newXS_deffile("Crypt::Mac::Pelican::b64mac", XS_Crypt__Mac__Pelican_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::Pelican::b64umac", XS_Crypt__Mac__Pelican_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::Pelican::hexmac", XS_Crypt__Mac__Pelican_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::Pelican::mac", XS_Crypt__Mac__Pelican_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::Pelican::pelican", XS_Crypt__Mac__Pelican_pelican);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::Pelican::pelican_b64", XS_Crypt__Mac__Pelican_pelican);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::Pelican::pelican_b64u", XS_Crypt__Mac__Pelican_pelican);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::Pelican::pelican_hex", XS_Crypt__Mac__Pelican_pelican);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::OMAC::new", XS_Crypt__Mac__OMAC_new);
        newXS_deffile("Crypt::Mac::OMAC::DESTROY", XS_Crypt__Mac__OMAC_DESTROY);
        newXS_deffile("Crypt::Mac::OMAC::clone", XS_Crypt__Mac__OMAC_clone);
        newXS_deffile("Crypt::Mac::OMAC::add", XS_Crypt__Mac__OMAC_add);
        cv = newXS_deffile("Crypt::Mac::OMAC::b64mac", XS_Crypt__Mac__OMAC_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::OMAC::b64umac", XS_Crypt__Mac__OMAC_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::OMAC::hexmac", XS_Crypt__Mac__OMAC_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::OMAC::mac", XS_Crypt__Mac__OMAC_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::OMAC::omac", XS_Crypt__Mac__OMAC_omac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::OMAC::omac_b64", XS_Crypt__Mac__OMAC_omac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::OMAC::omac_b64u", XS_Crypt__Mac__OMAC_omac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::OMAC::omac_hex", XS_Crypt__Mac__OMAC_omac);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::HMAC::new", XS_Crypt__Mac__HMAC_new);
        newXS_deffile("Crypt::Mac::HMAC::DESTROY", XS_Crypt__Mac__HMAC_DESTROY);
        newXS_deffile("Crypt::Mac::HMAC::clone", XS_Crypt__Mac__HMAC_clone);
        newXS_deffile("Crypt::Mac::HMAC::add", XS_Crypt__Mac__HMAC_add);
        cv = newXS_deffile("Crypt::Mac::HMAC::b64mac", XS_Crypt__Mac__HMAC_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::HMAC::b64umac", XS_Crypt__Mac__HMAC_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::HMAC::hexmac", XS_Crypt__Mac__HMAC_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::HMAC::mac", XS_Crypt__Mac__HMAC_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::HMAC::hmac", XS_Crypt__Mac__HMAC_hmac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::HMAC::hmac_b64", XS_Crypt__Mac__HMAC_hmac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::HMAC::hmac_b64u", XS_Crypt__Mac__HMAC_hmac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::HMAC::hmac_hex", XS_Crypt__Mac__HMAC_hmac);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mac::F9::new", XS_Crypt__Mac__F9_new);
        newXS_deffile("Crypt::Mac::F9::DESTROY", XS_Crypt__Mac__F9_DESTROY);
        newXS_deffile("Crypt::Mac::F9::clone", XS_Crypt__Mac__F9_clone);
        newXS_deffile("Crypt::Mac::F9::add", XS_Crypt__Mac__F9_add);
        cv = newXS_deffile("Crypt::Mac::F9::b64mac", XS_Crypt__Mac__F9_mac);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::F9::b64umac", XS_Crypt__Mac__F9_mac);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::F9::hexmac", XS_Crypt__Mac__F9_mac);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::Mac::F9::mac", XS_Crypt__Mac__F9_mac);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::F9::f9", XS_Crypt__Mac__F9_f9);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mac::F9::f9_b64", XS_Crypt__Mac__F9_f9);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::Mac::F9::f9_b64u", XS_Crypt__Mac__F9_f9);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::Mac::F9::f9_hex", XS_Crypt__Mac__F9_f9);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mode::CTR::new", XS_Crypt__Mode__CTR_new);
        newXS_deffile("Crypt::Mode::CTR::DESTROY", XS_Crypt__Mode__CTR_DESTROY);
        cv = newXS_deffile("Crypt::Mode::CTR::start_decrypt", XS_Crypt__Mode__CTR_start_decrypt);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mode::CTR::start_encrypt", XS_Crypt__Mode__CTR_start_decrypt);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mode::CTR::add", XS_Crypt__Mode__CTR_add);
        newXS_deffile("Crypt::Mode::CTR::finish", XS_Crypt__Mode__CTR_finish);
        newXS_deffile("Crypt::Mode::OFB::new", XS_Crypt__Mode__OFB_new);
        newXS_deffile("Crypt::Mode::OFB::DESTROY", XS_Crypt__Mode__OFB_DESTROY);
        cv = newXS_deffile("Crypt::Mode::OFB::start_decrypt", XS_Crypt__Mode__OFB_start_decrypt);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mode::OFB::start_encrypt", XS_Crypt__Mode__OFB_start_decrypt);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mode::OFB::add", XS_Crypt__Mode__OFB_add);
        newXS_deffile("Crypt::Mode::OFB::finish", XS_Crypt__Mode__OFB_finish);
        newXS_deffile("Crypt::Mode::CFB::new", XS_Crypt__Mode__CFB_new);
        newXS_deffile("Crypt::Mode::CFB::DESTROY", XS_Crypt__Mode__CFB_DESTROY);
        cv = newXS_deffile("Crypt::Mode::CFB::start_decrypt", XS_Crypt__Mode__CFB_start_decrypt);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mode::CFB::start_encrypt", XS_Crypt__Mode__CFB_start_decrypt);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mode::CFB::add", XS_Crypt__Mode__CFB_add);
        newXS_deffile("Crypt::Mode::CFB::finish", XS_Crypt__Mode__CFB_finish);
        newXS_deffile("Crypt::Mode::ECB::new", XS_Crypt__Mode__ECB_new);
        newXS_deffile("Crypt::Mode::ECB::DESTROY", XS_Crypt__Mode__ECB_DESTROY);
        cv = newXS_deffile("Crypt::Mode::ECB::start_decrypt", XS_Crypt__Mode__ECB_start_decrypt);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mode::ECB::start_encrypt", XS_Crypt__Mode__ECB_start_decrypt);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mode::ECB::add", XS_Crypt__Mode__ECB_add);
        newXS_deffile("Crypt::Mode::ECB::finish", XS_Crypt__Mode__ECB_finish);
        newXS_deffile("Crypt::Mode::CBC::new", XS_Crypt__Mode__CBC_new);
        newXS_deffile("Crypt::Mode::CBC::DESTROY", XS_Crypt__Mode__CBC_DESTROY);
        cv = newXS_deffile("Crypt::Mode::CBC::start_decrypt", XS_Crypt__Mode__CBC_start_decrypt);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::Mode::CBC::start_encrypt", XS_Crypt__Mode__CBC_start_decrypt);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::Mode::CBC::add", XS_Crypt__Mode__CBC_add);
        newXS_deffile("Crypt::Mode::CBC::finish", XS_Crypt__Mode__CBC_finish);
        newXS_deffile("Crypt::PRNG::new", XS_Crypt__PRNG_new);
        newXS_deffile("Crypt::PRNG::DESTROY", XS_Crypt__PRNG_DESTROY);
        newXS_deffile("Crypt::PRNG::add_entropy", XS_Crypt__PRNG_add_entropy);
        cv = newXS_deffile("Crypt::PRNG::bytes", XS_Crypt__PRNG_bytes);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PRNG::bytes_b64", XS_Crypt__PRNG_bytes);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::PRNG::bytes_b64u", XS_Crypt__PRNG_bytes);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::PRNG::bytes_hex", XS_Crypt__PRNG_bytes);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::PRNG::int32", XS_Crypt__PRNG_int32);
        newXS_deffile("Crypt::PRNG::double", XS_Crypt__PRNG_double);
        newXS_deffile("Crypt::PK::ECC::_new", XS_Crypt__PK__ECC__new);
        newXS_deffile("Crypt::PK::ECC::generate_key", XS_Crypt__PK__ECC_generate_key);
        newXS_deffile("Crypt::PK::ECC::_import", XS_Crypt__PK__ECC__import);
        newXS_deffile("Crypt::PK::ECC::_import_old", XS_Crypt__PK__ECC__import_old);
        newXS_deffile("Crypt::PK::ECC::_import_pkcs8", XS_Crypt__PK__ECC__import_pkcs8);
        newXS_deffile("Crypt::PK::ECC::_import_x509", XS_Crypt__PK__ECC__import_x509);
        newXS_deffile("Crypt::PK::ECC::import_key_raw", XS_Crypt__PK__ECC_import_key_raw);
        newXS_deffile("Crypt::PK::ECC::is_private", XS_Crypt__PK__ECC_is_private);
        newXS_deffile("Crypt::PK::ECC::size", XS_Crypt__PK__ECC_size);
        newXS_deffile("Crypt::PK::ECC::key2hash", XS_Crypt__PK__ECC_key2hash);
        newXS_deffile("Crypt::PK::ECC::export_key_der", XS_Crypt__PK__ECC_export_key_der);
        newXS_deffile("Crypt::PK::ECC::export_key_raw", XS_Crypt__PK__ECC_export_key_raw);
        newXS_deffile("Crypt::PK::ECC::encrypt", XS_Crypt__PK__ECC_encrypt);
        newXS_deffile("Crypt::PK::ECC::decrypt", XS_Crypt__PK__ECC_decrypt);
        cv = newXS_deffile("Crypt::PK::ECC::sign_hash", XS_Crypt__PK__ECC_sign_hash);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PK::ECC::sign_hash_rfc7518", XS_Crypt__PK__ECC_sign_hash);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::PK::ECC::sign_message", XS_Crypt__PK__ECC_sign_hash);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::PK::ECC::sign_message_rfc7518", XS_Crypt__PK__ECC_sign_hash);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Crypt::PK::ECC::verify_hash", XS_Crypt__PK__ECC_verify_hash);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PK::ECC::verify_hash_rfc7518", XS_Crypt__PK__ECC_verify_hash);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("Crypt::PK::ECC::verify_message", XS_Crypt__PK__ECC_verify_hash);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::PK::ECC::verify_message_rfc7518", XS_Crypt__PK__ECC_verify_hash);
        XSANY.any_i32 = 2;
        newXS_deffile("Crypt::PK::ECC::shared_secret", XS_Crypt__PK__ECC_shared_secret);
        newXS_deffile("Crypt::PK::ECC::DESTROY", XS_Crypt__PK__ECC_DESTROY);
        newXS_deffile("Crypt::PK::DH::_new", XS_Crypt__PK__DH__new);
        newXS_deffile("Crypt::PK::DH::_generate_key_size", XS_Crypt__PK__DH__generate_key_size);
        newXS_deffile("Crypt::PK::DH::_generate_key_gp", XS_Crypt__PK__DH__generate_key_gp);
        newXS_deffile("Crypt::PK::DH::_generate_key_dhparam", XS_Crypt__PK__DH__generate_key_dhparam);
        newXS_deffile("Crypt::PK::DH::_import", XS_Crypt__PK__DH__import);
        newXS_deffile("Crypt::PK::DH::_import_raw", XS_Crypt__PK__DH__import_raw);
        newXS_deffile("Crypt::PK::DH::is_private", XS_Crypt__PK__DH_is_private);
        newXS_deffile("Crypt::PK::DH::size", XS_Crypt__PK__DH_size);
        newXS_deffile("Crypt::PK::DH::key2hash", XS_Crypt__PK__DH_key2hash);
        newXS_deffile("Crypt::PK::DH::params2hash", XS_Crypt__PK__DH_params2hash);
        newXS_deffile("Crypt::PK::DH::export_key", XS_Crypt__PK__DH_export_key);
        newXS_deffile("Crypt::PK::DH::shared_secret", XS_Crypt__PK__DH_shared_secret);
        newXS_deffile("Crypt::PK::DH::export_key_raw", XS_Crypt__PK__DH_export_key_raw);
        newXS_deffile("Crypt::PK::DH::DESTROY", XS_Crypt__PK__DH_DESTROY);
        newXS_deffile("Crypt::PK::DSA::_new", XS_Crypt__PK__DSA__new);
        newXS_deffile("Crypt::PK::DSA::_generate_key_size", XS_Crypt__PK__DSA__generate_key_size);
        newXS_deffile("Crypt::PK::DSA::_generate_key_dsaparam", XS_Crypt__PK__DSA__generate_key_dsaparam);
        newXS_deffile("Crypt::PK::DSA::_generate_key_pqg_hex", XS_Crypt__PK__DSA__generate_key_pqg_hex);
        newXS_deffile("Crypt::PK::DSA::_import", XS_Crypt__PK__DSA__import);
        newXS_deffile("Crypt::PK::DSA::_import_hex", XS_Crypt__PK__DSA__import_hex);
        newXS_deffile("Crypt::PK::DSA::is_private", XS_Crypt__PK__DSA_is_private);
        newXS_deffile("Crypt::PK::DSA::size", XS_Crypt__PK__DSA_size);
        newXS_deffile("Crypt::PK::DSA::size_q", XS_Crypt__PK__DSA_size_q);
        newXS_deffile("Crypt::PK::DSA::key2hash", XS_Crypt__PK__DSA_key2hash);
        newXS_deffile("Crypt::PK::DSA::export_key_der", XS_Crypt__PK__DSA_export_key_der);
        newXS_deffile("Crypt::PK::DSA::encrypt", XS_Crypt__PK__DSA_encrypt);
        newXS_deffile("Crypt::PK::DSA::decrypt", XS_Crypt__PK__DSA_decrypt);
        cv = newXS_deffile("Crypt::PK::DSA::sign_hash", XS_Crypt__PK__DSA_sign_hash);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PK::DSA::sign_message", XS_Crypt__PK__DSA_sign_hash);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::PK::DSA::verify_hash", XS_Crypt__PK__DSA_verify_hash);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PK::DSA::verify_message", XS_Crypt__PK__DSA_verify_hash);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::PK::DSA::DESTROY", XS_Crypt__PK__DSA_DESTROY);
        newXS_deffile("Crypt::PK::RSA::_new", XS_Crypt__PK__RSA__new);
        newXS_deffile("Crypt::PK::RSA::generate_key", XS_Crypt__PK__RSA_generate_key);
        newXS_deffile("Crypt::PK::RSA::_import", XS_Crypt__PK__RSA__import);
        newXS_deffile("Crypt::PK::RSA::_import_pkcs8", XS_Crypt__PK__RSA__import_pkcs8);
        newXS_deffile("Crypt::PK::RSA::_import_x509", XS_Crypt__PK__RSA__import_x509);
        newXS_deffile("Crypt::PK::RSA::_import_hex", XS_Crypt__PK__RSA__import_hex);
        newXS_deffile("Crypt::PK::RSA::is_private", XS_Crypt__PK__RSA_is_private);
        newXS_deffile("Crypt::PK::RSA::size", XS_Crypt__PK__RSA_size);
        newXS_deffile("Crypt::PK::RSA::key2hash", XS_Crypt__PK__RSA_key2hash);
        newXS_deffile("Crypt::PK::RSA::export_key_der", XS_Crypt__PK__RSA_export_key_der);
        newXS_deffile("Crypt::PK::RSA::encrypt", XS_Crypt__PK__RSA_encrypt);
        newXS_deffile("Crypt::PK::RSA::decrypt", XS_Crypt__PK__RSA_decrypt);
        cv = newXS_deffile("Crypt::PK::RSA::sign_hash", XS_Crypt__PK__RSA_sign_hash);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PK::RSA::sign_message", XS_Crypt__PK__RSA_sign_hash);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Crypt::PK::RSA::verify_hash", XS_Crypt__PK__RSA_verify_hash);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Crypt::PK::RSA::verify_message", XS_Crypt__PK__RSA_verify_hash);
        XSANY.any_i32 = 1;
        newXS_deffile("Crypt::PK::RSA::DESTROY", XS_Crypt__PK__RSA_DESTROY);
        newXS_deffile("Crypt::KeyDerivation::pbkdf1", XS_Crypt__KeyDerivation_pbkdf1);
        newXS_deffile("Crypt::KeyDerivation::pbkdf2", XS_Crypt__KeyDerivation_pbkdf2);
        newXS_deffile("Crypt::KeyDerivation::hkdf_extract", XS_Crypt__KeyDerivation_hkdf_extract);
        newXS_deffile("Crypt::KeyDerivation::hkdf_expand", XS_Crypt__KeyDerivation_hkdf_expand);
        newXS_deffile("Crypt::KeyDerivation::hkdf", XS_Crypt__KeyDerivation_hkdf);
        newXS_deffile("Math::BigInt::LTM::_new", XS_Math__BigInt__LTM__new);
        newXS_deffile("Math::BigInt::LTM::_from_bin", XS_Math__BigInt__LTM__from_bin);
        newXS_deffile("Math::BigInt::LTM::_from_hex", XS_Math__BigInt__LTM__from_hex);
        newXS_deffile("Math::BigInt::LTM::_from_oct", XS_Math__BigInt__LTM__from_oct);
        newXS_deffile("Math::BigInt::LTM::_from_base", XS_Math__BigInt__LTM__from_base);
        newXS_deffile("Math::BigInt::LTM::_from_bytes", XS_Math__BigInt__LTM__from_bytes);
        newXS_deffile("Math::BigInt::LTM::_set", XS_Math__BigInt__LTM__set);
        newXS_deffile("Math::BigInt::LTM::_zero", XS_Math__BigInt__LTM__zero);
        newXS_deffile("Math::BigInt::LTM::_one", XS_Math__BigInt__LTM__one);
        newXS_deffile("Math::BigInt::LTM::_two", XS_Math__BigInt__LTM__two);
        newXS_deffile("Math::BigInt::LTM::_ten", XS_Math__BigInt__LTM__ten);
        newXS_deffile("Math::BigInt::LTM::_1ex", XS_Math__BigInt__LTM__1ex);
        newXS_deffile("Math::BigInt::LTM::DESTROY", XS_Math__BigInt__LTM_DESTROY);
        newXS_deffile("Math::BigInt::LTM::_str", XS_Math__BigInt__LTM__str);
        newXS_deffile("Math::BigInt::LTM::_len", XS_Math__BigInt__LTM__len);
        newXS_deffile("Math::BigInt::LTM::_alen", XS_Math__BigInt__LTM__alen);
        newXS_deffile("Math::BigInt::LTM::_zeros", XS_Math__BigInt__LTM__zeros);
        newXS_deffile("Math::BigInt::LTM::_to_hex", XS_Math__BigInt__LTM__to_hex);
        newXS_deffile("Math::BigInt::LTM::_to_bin", XS_Math__BigInt__LTM__to_bin);
        newXS_deffile("Math::BigInt::LTM::_to_oct", XS_Math__BigInt__LTM__to_oct);
        newXS_deffile("Math::BigInt::LTM::_to_base", XS_Math__BigInt__LTM__to_base);
        cv = newXS_deffile("Math::BigInt::LTM::_as_bytes", XS_Math__BigInt__LTM__to_bytes);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Math::BigInt::LTM::_to_bytes", XS_Math__BigInt__LTM__to_bytes);
        XSANY.any_i32 = 0;
        newXS_deffile("Math::BigInt::LTM::_modpow", XS_Math__BigInt__LTM__modpow);
        newXS_deffile("Math::BigInt::LTM::_modinv", XS_Math__BigInt__LTM__modinv);
        newXS_deffile("Math::BigInt::LTM::_add", XS_Math__BigInt__LTM__add);
        newXS_deffile("Math::BigInt::LTM::_inc", XS_Math__BigInt__LTM__inc);
        newXS_deffile("Math::BigInt::LTM::_dec", XS_Math__BigInt__LTM__dec);
        newXS_deffile("Math::BigInt::LTM::_sub", XS_Math__BigInt__LTM__sub);
        newXS_deffile("Math::BigInt::LTM::_rsft", XS_Math__BigInt__LTM__rsft);
        newXS_deffile("Math::BigInt::LTM::_lsft", XS_Math__BigInt__LTM__lsft);
        newXS_deffile("Math::BigInt::LTM::_mul", XS_Math__BigInt__LTM__mul);
        newXS_deffile("Math::BigInt::LTM::_div", XS_Math__BigInt__LTM__div);
        newXS_deffile("Math::BigInt::LTM::_mod", XS_Math__BigInt__LTM__mod);
        newXS_deffile("Math::BigInt::LTM::_acmp", XS_Math__BigInt__LTM__acmp);
        newXS_deffile("Math::BigInt::LTM::_is_zero", XS_Math__BigInt__LTM__is_zero);
        newXS_deffile("Math::BigInt::LTM::_is_one", XS_Math__BigInt__LTM__is_one);
        newXS_deffile("Math::BigInt::LTM::_is_two", XS_Math__BigInt__LTM__is_two);
        newXS_deffile("Math::BigInt::LTM::_is_ten", XS_Math__BigInt__LTM__is_ten);
        newXS_deffile("Math::BigInt::LTM::_pow", XS_Math__BigInt__LTM__pow);
        newXS_deffile("Math::BigInt::LTM::_gcd", XS_Math__BigInt__LTM__gcd);
        newXS_deffile("Math::BigInt::LTM::_and", XS_Math__BigInt__LTM__and);
        newXS_deffile("Math::BigInt::LTM::_xor", XS_Math__BigInt__LTM__xor);
        newXS_deffile("Math::BigInt::LTM::_or", XS_Math__BigInt__LTM__or);
        newXS_deffile("Math::BigInt::LTM::_copy", XS_Math__BigInt__LTM__copy);
        newXS_deffile("Math::BigInt::LTM::_is_odd", XS_Math__BigInt__LTM__is_odd);
        newXS_deffile("Math::BigInt::LTM::_is_even", XS_Math__BigInt__LTM__is_even);
        newXS_deffile("Math::BigInt::LTM::_sqrt", XS_Math__BigInt__LTM__sqrt);
        newXS_deffile("Math::BigInt::LTM::_root", XS_Math__BigInt__LTM__root);
        newXS_deffile("Math::BigInt::LTM::_lcm", XS_Math__BigInt__LTM__lcm);
        newXS_deffile("Math::BigInt::LTM::STORABLE_thaw", XS_Math__BigInt__LTM_STORABLE_thaw);
        newXS_deffile("Math::BigInt::LTM::STORABLE_freeze", XS_Math__BigInt__LTM_STORABLE_freeze);

    /* Initialisation Section */

#line 367 "CryptX.xs"
    if(register_all_ciphers() != CRYPT_OK)     { croak("FATAL: register_all_ciphers failed"); }
    if(register_all_hashes()  != CRYPT_OK)     { croak("FATAL: register_all_hashes failed"); }
    if(register_all_prngs()   != CRYPT_OK)     { croak("FATAL: register_all_prngs failed"); }
    if(crypt_mp_init("ltm")   != CRYPT_OK)     { croak("FATAL: crypt_mp_init failed"); }

#line 18237 "CryptX.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
